import sys
import os.path

from Mobyle.MobyleError import *
from Mobyle import ConfigManager

__cfg = ConfigManager.Config()

from subprocess import Popen , PIPE
import dns.resolver


import logging 
m_log = logging.getLogger('mobyle.mobylejob')



def queue( **args ):
    """
    @return: the name of the queue to be used to execute the job
    @rtype: string
    """
    pass


def emailCheck( **args ):
    """
    check if an email is valid or not
    @return: True if the user email is valid, False otherwise
    @rtype boolean:
    """
    
    user , domainName  = args['email'].split('@')


    if domainName == 'pasteur.fr':
        #si c'est un local (campus) verifier que le login existe

        return  isLocal( user )
    else:

        command = "dig %s -t MX +noadditional +noauthority +short" % domainName

        try:
            pipe = Popen( command , 
                          shell = True,
                          stdout = PIPE ,
                          stdin = None ,
                          stderr = PIPE ,
                          close_fds = True)
            
        except OSError, err:
            msg= "dig execution failed: "+ str(err)
            raise MobyleError , msg

        pipe.wait()
        
        if pipe.returncode != 0:
            err = ''.join( pipe.stderr.readlines() )
            msg= "dig exit abnormaly: "+ err
            raise MobyleError , msg
        else:
            for line in pipe.stdout:
                print line
                return True

            return False

    


    
    #soit retourne un booleen
    # soit ne fait rien mais leve une erreur
    # l'erreur permet de faire passe un message different selon les cas
    # de refus ??
    #mais attention le catch n'est prevu que pour les MobyleError 
    return True




def emailCheck2( **args ):
    """
    check if an email is valid or not
    @return: True if the user email is valid, False otherwise
    @rtype boolean:
    """
    
    user , domainName  = args['email'].split('@')


    if domainName == 'pasteur.fr':
        #si c'est un local (campus) verifier que le login existe

        local = isLocal( user )
        if not local:
            raise MobyleError , user+" = invalid login"
    
    else:
        _error = False
        try:
            answers = dns.resolver.query( domainName , 'MX')
        except dns.resolver.NXDOMAIN , err :
            msg= "unknown name domain"
            _error = True
        except dns.resolver.NoAnswer ,err :
            msg= "no mail at " + str( domainName )
            _error = True
        except dns.name.EmptyLabel:
            msg= ""
            _error= True
            
        if _error:
            raise MobyleError , msg
        else:
            return True

    return True




def isLocal( userName ):
    m_log.debug( "appel de isLocal("+str(userName) +")")
    loginFileName = os.path.join( os.environ['MOBYLEHOME'] , "Tools/passwd" )
    fh = open( loginFileName , "r" )
    for line in fh:
        m_log.debug( "-------line ="+line+"--------------")
        name = line.strip()
        m_log.debug( "name ="+name+"##")
        if userName == name :
            fh.close()
            return True
    fh.close()
    return False
