import os, sys

##################################
#
# Python
#
#################################

try:
    os.environ['MOBYLEHOME'] 
    MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME'] = '/home/bneron/Mobyle'
    MOBYLEHOME = os.environ['MOBYLEHOME']


##################################
#
# Debug
#
#################################

# 0   pas de DEBUG   
# 1   construction de la ligne de commande pas de logs, pas d'execution du job 
# 2   logs du remplissage de l'evaluatueur a la construction de la ligne de commande
#        pas d'execution de la ligne de commande
# 3   logs du remplissage de l'evaluateur a la construction de la ligne de commande
#        EXECUTION  de la ligne de commande

DEBUG = 3
             
PARTICULAR_DEBUG ={
    "basicbuilder"    : 2 ,
    "dssp"            : 2 ,
    "melting"         : 2 ,
    "predator"        : 2 ,
    "genscan"         : 2 ,
    "cap3"            : 2 ,
    "dreg"            : 2 ,
    "rnapdist"        : 2 ,
    } 



###################################
#
# Directories
#
##################################

  
# where to work:
# this is the absolut prefix for jobs results sub-directories
# the results will be in
# TMP_DIR+ programName + xx
# where xx is a random key

 
RESULTS_PATH = "/home/bneron/Developement/Python/MobyleTest/Results"
#RESULTS_PATH = "/home/bneron/Developement/Python/MobyleTest2/Results"

# were are the binary corresponding to the services
# a list of string
# each element must be a valid path
# the element order is kept to build the final PATH
BINARY_PATH = ["/usr/local/bin"]

#cache pour les template html 
TEMPLATES_CACHE_PATH = "/tmp"

FORMAT_DETECTOR_CACHE_PATH = "/home/bneron/tmp/squizz"

# path to the user sessions folder
USER_SESSIONS_PATH = "/home/bneron/Developement/Python/MobyleTest/Sessions"
#USER_SESSIONS_PATH = "/home/bneron/Developement/Python/MobyleTest2/Sessions" 

###################################
#
# Portal
#
###################################


# the root url of mobyle 
ROOT_URL = "http://kerka.sis.pasteur.fr:81"

# this is the relative path to access to the jobs results sub-directories
# the complete url of a job will be
# ROOT_URL + TMP_URL + programName + xx
# where xx is a random key
# exemple for toppred:
# here  http://kerka.sis.pasteur.fr/Mobyle/Results/toppred/M85111376732714
# this directory should correspond to the TMP_DIR

RESULTS_URL = "Mobyle/Results" #utilise uniquement dans jobstate
#RESULTS_URL = "Mobyle2/Results"

#idem for session access
SESSIONS_URL = "Mobyle/Sessions" 
#SESSIONS_URL = "Mobyle2/Sessions" 

#the path to the golden binary 
GOLDEN_PATH = "/usr/local/bin/golden"


#base_project_files_url = '/MobylePortal'
#ROOT_URL + MOBYLEROOT_HTDOCS_URL
MOBYLEROOT_HTDOCS_URL = 'MobylePortal'

#base_project_cgi_url = '/cgi-bin/MobylePortal'
#ROOT_URL + MOBYLEROOT_CGI_URL
MOBYLEROOT_CGI_URL = 'cgi-bin/MobylePortal'



DATABANKS_CONFIG = [
    {'id'       : 'embl' ,
     'dataType' : 'Sequence' ,
     'bioTypes' : ['Nucleic'] ,   
     'label'    : 'EMBL Nucleotide Sequence Database'
    },
    {'id'       : 'genbank',
     'dataType' : 'Sequence',
     'bioTypes' : ['Nucleic'],
     'label'    : 'Genbank NIH DNA sequence database'
    },
    {'id'       : 'genpept', 
     'dataType' : 'Sequence',
     'bioTypes' : ['Protein'],   
     'label'    : 'Genbank Translated Protein-coding Sequences'
    },
    {'id'       : 'imgt',
     'dataType' : 'Sequence',
     'bioTypes' : ['Nucleic'],   
     'label'    : 'IMGT - ImMunoGeneTics sequence database'
    },
    {'id'       : 'refseq',
     'dataType' : 'Sequence',
     'bioTypes' : ['Nucleic' , 'Protein'],    
     'label'    : 'NCBI Reference Sequence (RefSeq) Database'
    },
    {'id'       : 'uniprot', 
     'dataType' : 'Sequence', 
     'bioTypes' : ['Protein'], 
     'label'    : 'UniprotKB - Universal Protein Knowlege Base'
    },
    {'id'       : 'wgs',
     'dataType' : 'Sequence', 
     'bioTypes' : ['Nucleic'],    
     'label'    : 'Genbank - Whole Genome Shotgun'
    },
    ]

#####################################
#
#    Authentication
#
######################################


# to make email optional for all programs, set this to True
# default value = True
OPT_EMAIL  = False
#OPT_EMAIL  = True

# to have a more control on the mandatory email
# it able to have the general option but
# it could be set to another value for particular service
# exemple :
# OPT_EMAIL could be set at False ( the email is mandatory )
# but set a True for some very short services.

PARTICULAR_OPT_EMAIL = {'typetest' : True ,
                        #'toppred'  : True
                        }

#
#
#

#anonymous session there is 3 available values 
# no      : the anonymous sessions are not allowed
# yes     : the anonymous sessions are allowed, without any verification 
# captcha : the anonymous sessions are allowed, but with a captcha challenge ( default )
ANONYMOUS_SESSION = "captcha"


#authenticated session ther is 3 available values
# 'no'    : the authenticated session are not allowed.
# 'yes'   : the authenticated session are allowed and activated without any restriction.
# 'email' : the authenticated session are allowed but an email confirmation is needed to activate it.

AUTHENTICATED_SESSION = "yes"
#AUTHENTICATED_SESSION = "no"

#####################################
#
#
#
######################################

LANG = 'en'

TIMEOUT = 15 #in seconds


# max size for any file (2 Go)
FILELIMIT = 4294967296 / 2

# max size for a session ( 50Mo )
#SESSIONLIMIT = 52428800 
SESSIONLIMIT = 524288

#a list of email adresses who will recieved messages when problems occur
MAINTAINER = [ "bneron@pasteur.fr" ]

HELP="bneron@pasteur.fr"

# local mailhost
MAILHOST= "mail.pasteur.fr"
#MAILHOST= "smtp.free.fr"
#MAILHOST= "localhost"

#set this True if you don't want results to be sent by email.
#This does not make email optional
DONT_EMAIL_RESULTS = False
#DONT_EMAIL_RESULTS = True

# max size for results by email ( default 2 Mo)
MAXMAILSIZE = 2 * 1048576


# how long should results be available on the server ( in days default = 10)?
RESULT_REMAIN = 10


DNS_RESOLVER = True
# if you want to resolv the domain name of the user email
# and if it has a mail exchanger fiel
# (to avoid fake user email address)
# by default DNS_RESOLVER = False



####################################################
#                                                  #
#    programs needed by the sequences format       #
#          detection and conversion                # 
#                                                  #
####################################################

# the 2 sequences conveter supported by Mobyle are
# squizz and the java version of readseq
# squizz is HIGHLY recommanded

SEQCONVERTER= {
    'SQUIZZ': '/usr/local/bin/squizz',
    #'SQUIZZ':  '/home/bneron/bin/squizz',
    #'READSEQ': '/usr/local/bin/jreadseq' 
    }

#SEQCONVERTER= {}



#####################################
#
# queuing system
#
######################################

# the allowed values are : PBS , LSF , SGE , Sys
# mandatory
BATCH = "Sys"

PARTICULAR_BATCH = {
    'toppred' : 'Sys'
    }


# the name of the default queue
DEFAULT_Q = 'local'


# the name of a particular queue for a service
PARTICULAR_Q = {
    'golden' : 'short' }


Q_PROPERTIES={}
   
########################################
#
#     SGE Configuration
#
########################################


SGE_ROOT = "/local/gensoft/adm/sge" 
SGE_CELL = "gensoft"


########################################
#
#       logging
#
########################################

LOGDIR = '/var/log/Mobyle'

# to monitored the elapsed time per job ( defailt = False )
ACCOUNTING = True


#########################################
#
# disabling services
#
#########################################


DISABLE_ALL = False

DISABLED_SERVICES = [ ] 


#########################################
#
# restriction services access
#
#########################################


AUTHORIZED_SERVICES = {
    'toppred'  : [ '157.99.*.*' ],
    'blast2'   : [ '157.99.*.*' , '192,168.3.1'],
    'dnapars'  : [ '157.99.60.*'],
    'fake_1'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*' ],  
    'fake_3'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_4'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_5'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_6'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_7'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_8'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_9'   : [ '157.99.*.*' , '100,100,100,*' , '100,100,200,*' , '100,100,300,*' , '100,100,400,*' , '100,100,500,*' , '100,100,600,*' , '100,100,700,*' , '100,100,800,*' ,'100,100,900,*' , '500,100,*,*' , '500,200,*,*' , '500,300,*,*'],
    'fake_10'  : [ '157.99.*.*' , '200,100,100,*' , '200,100,200,*' , '200,100,300,*' , '200,100,400,*' , '200,100,500,*' , '200,100,600,*' , '200,100,700,*' , '200,100,800,*' ,'200,100,900,*' , '600,100,*,*' , '600,200,*,*' , '600,300,*,*'],
    'fake_11'  : [ '157.99.*.*' , '200,100,100,*' , '200,100,200,*' , '200,100,300,*' , '200,100,400,*' , '200,100,500,*' , '200,100,600,*' , '200,100,700,*' , '200,100,800,*' ,'200,100,900,*' , '600,100,*,*' , '600,200,*,*' , '600,300,*,*'],
    'fake_12'  : [ '157.99.*.*' , '200,100,100,*' , '200,100,200,*' , '200,100,300,*' , '200,100,400,*' , '200,100,500,*' , '200,100,600,*' , '200,100,700,*' , '200,100,800,*' ,'200,100,900,*' , '600,100,*,*' , '600,200,*,*' , '600,300,*,*'],
    'fake_13'  : [ '157.99.*.*' , '200,100,100,*' , '200,100,200,*' , '200,100,300,*' , '200,100,400,*' , '200,100,500,*' , '200,100,600,*' , '200,100,700,*' , '200,100,800,*' ,'200,100,900,*' , '600,100,*,*' , '600,200,*,*' , '600,300,*,*'],
    'fake_14'  : [ '157.99.*.*' , '200,100,100,*' , '200,100,200,*' , '200,100,300,*' , '200,100,400,*' , '200,100,500,*' , '200,100,600,*' , '200,100,700,*' , '200,100,800,*' ,'200,100,900,*' , '600,100,*,*' , '600,200,*,*' , '600,300,*,*'],
    'fake_15'  : [ '157.99.*.*' , '200,100,110,*' , '200,100,210,*' , '200,100,310,*' , '200,100,410,*' , '200,100,510,*' , '200,100,610,*' , '200,100,710,*' , '200,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_16'  : [ '157.99.*.*' , '200,100,110,*' , '200,100,210,*' , '200,100,310,*' , '200,100,410,*' , '200,100,510,*' , '200,100,610,*' , '200,100,710,*' , '200,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_17'  : [ '157.99.*.*' , '200,100,110,*' , '200,100,210,*' , '200,100,310,*' , '200,100,410,*' , '200,100,510,*' , '200,100,610,*' , '200,100,710,*' , '200,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_18'  : [ '157.99.*.*' , '200,100,110,*' , '200,100,210,*' , '200,100,310,*' , '200,100,410,*' , '200,100,510,*' , '200,100,610,*' , '200,100,710,*' , '200,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_19'  : [ '157.99.*.*' , '200,100,110,*' , '200,100,210,*' , '200,100,310,*' , '200,100,410,*' , '200,100,510,*' , '200,100,610,*' , '200,100,710,*' , '200,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_20'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_20'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_21'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_22'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_23'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_24'  : [ '157.99.60.*' , '300,100,110,*' , '300,100,210,*' , '300,100,310,*' , '300,100,410,*' , '300,100,510,*' , '300,100,610,*' , '300,100,710,*' , '300,100,810,*' ,'200,100,910,*' , '600,110,*,*' , '600,210,*,*' , '600,310,*,*'],
    'fake_25'  : [ '157.99.60.*' , '300,100,120,*' , '300,100,220,*' , '300,100,320,*' , '300,100,420,*' , '300,100,520,*' , '300,100,620,*' , '300,100,720,*' , '300,100,820,*' ,'200,100,920,*' , '600,120,*,*' , '600,210,*,*' , '600,320,*,*'],
    'fake_26'  : [ '157.99.60.*' , '300,100,120,*' , '300,100,220,*' , '300,100,320,*' , '300,100,420,*' , '300,100,520,*' , '300,100,620,*' , '300,100,720,*' , '300,100,820,*' ,'200,100,920,*' , '600,120,*,*' , '600,210,*,*' , '600,320,*,*'],
    'fake_27'  : [ '157.99.60.*' , '300,100,120,*' , '300,100,220,*' , '300,100,320,*' , '300,100,420,*' , '300,100,520,*' , '300,100,620,*' , '300,100,720,*' , '300,100,820,*' ,'200,100,920,*' , '600,120,*,*' , '600,210,*,*' , '600,320,*,*'],
    'fake_28'  : [ '157.99.60.*' , '300,100,120,*' , '300,100,220,*' , '300,100,320,*' , '300,100,420,*' , '300,100,520,*' , '300,100,620,*' , '300,100,720,*' , '300,100,820,*' ,'200,100,920,*' , '600,120,*,*' , '600,210,*,*' , '600,320,*,*'],
    'fake_29'  : [ '157.99.60.*' , '300,100,120,*' , '300,100,220,*' , '300,100,320,*' , '300,100,420,*' , '300,100,520,*' , '300,100,620,*' , '300,100,720,*' , '300,100,820,*' ,'200,100,920,*' , '600,120,*,*' , '600,210,*,*' , '600,320,*,*'],
    'fake_30'  : [ '157.99.60.74']         
    }


# serviceName : [ ip , ip mask ]

# the ip address which can use the service
# ip syntax
#
# 'toppred' : [ '125.234.60.18' , # only the machine with this ip could acces to toppred
#               '125.234.60.*'  , # all the machines in subnet could acces to toppred
#               '125.234.*.15   , # all the machine 
#             ] 
#
# if there is no entry for a service it's mean that
# every body can acces to this service


