import os, sys

##################################
#
# Python
#
#################################

try:
    os.environ['MOBYLEHOME'] 
    MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME'] = '/Users/letondal/Packages/Mobyle'
    MOBYLEHOME = os.environ['MOBYLEHOME']
    print >> sys.stderr , "CGIJob: the environement variable MOBYLEHOME is not defined"


##################################
#
# Debug
#
#################################

# 0   pas de DEBUG   
# 1   construction de la ligne de commande pas de logs, pas d'execution du job 
# 2   logs du remplissage de l'evaluatueur a la construction de la ligne de commande
#        pas d'execution de la ligne de commande
# 3   logs du remplissage de l'evaluateur a la construction de la ligne de commande
#        EXECUTION  de la ligne de commande

DEBUG = 3
             
PARTICULAR_DEBUG ={
    "toppred" : 3
    }



###################################
#
# Directories
#
##################################

  
# where to work:
# this is the absolut prefix for jobs results sub-directories
# the results will be in
# TMP_DIR+ programName + xx
# where xx is a random key


RESULTS_PATH = "/Library/WebServer/Documents/tmp"

# were are the binary corresponding to the services
# a list of string
BINARY_PATH = []

TEMPLATES_CACHE_PATH = "/tmp"

USER_SESSIONS_PATH = "/Library/Webserver/Documents/tmp/userSessions"
SESSIONS_URL = "tmp/userSessions" #utilise uniquement dans jobstate

FORMAT_DETECTOR_CACHE_PATH = "/tmp"


###################################
#
# Portal
#
###################################


# the root url of mobyle 
ROOT_URL = "http://localhost"


# this is the relative path to access to the jobs results sub-directories
# the complete url of a job will be
# ROOT_URL + TMP_URL + programName + xx
# where xx is a random key
# exemple for toppred:
# here  http://kerka.sis.pasteur.fr/Mobyle/Results/toppred/M85111376732714
# this directory should correspond to the TMP_DIR

RESULTS_URL = "tmp" #utilise uniquement dans jobstate


#the path to the golden binary 
GOLDEN_PATH = "/usr/local/bin/golden"
os.environ['GOLDENDATA'] = "/Users/letondal/Documents/Data/db"

#base_project_files_url = '/MobylePortal'
#ROOT_URL + MOBYLEROOT_HTDOCS_URL
MOBYLEROOT_HTDOCS_URL = 'MobylePortal'

#base_project_cgi_url = '/cgi-bin/MobylePortal'
#ROOT_URL + MOBYLEROOT_CGI_URL
MOBYLEROOT_CGI_URL = 'cgi-bin/MobylePortal'


DATATYPE_DATABANK_MAPPING= {
    'Sequence' : ['Swissprot'],
    'Protein' : ['Swissprot']
    }

#########################33

Response ={}

Response['datatypes'] = [
		{'datatype' : 'DB'},
		{'datatype' : 'Sequence'},
		{'datatype' : 'Sequences'},
		{'datatype' : 'DNA'},
		{'datatype' : 'Protein'},
		{'datatype' : 'Alignment'},
		{'datatype' : 'Structure'},
		{'datatype' : 'Report'}
		]

  
#####################################
#
#    user email
#
######################################


# to make email optional for all programs, set this to True
OPT_EMAIL  = False

# to have a more control on the mandatory email
# it able to have the general option at False
# ( the email is mandatory )
# but for some special services  it could be set at True
# for some very short services form examples

PARTICULAR_OPT_EMAIL = ['golden' , 'toppred']


DNS_RESOLVER = True
# if you want to resolv the domain name of the user email
# and if it has a mail exchanger fiel
# (to avoid fake user email address)
# by default DNS_RESOLVER = False



#####################################
#
#
#
######################################

LANG = 'en'

TIMEOUT = 30 #in seconds


# max size for any file (2 Go)
FILELIMIT = 4294967296 / 2


# who receives emails when problems occur

MAINTAINER = "letondal@pasteur.fr"

HELP="letondal@pasteur.fr"

# local mailhost
MAILHOST= "smtp.free.fr"

#set this True if you don't want results to be sent by email.
#This does not make email optional
DONT_EMAIL_RESULTS = False

# max size for results by email (2 Mo)
MAXMAILSIZE = 2 * 1048576


# how long should results be available on the server ( in days )?
RESULT_REMAIN = 10



####################################################
#                                                  #
#    programs needed by the sequences format       #
#          detection and conversion                # 
#                                                  #
####################################################

# the 2 sequence conveter supported by Mobyle are
# squizz and the java version of readseq
# squizz is highly recommanded

SEQCONVERTER= {
    'SQUIZZ': '/usr/local/bin/squizz' }



#####################################
#
# queuing system
#
######################################

# the allowed values are : PBS , LSF , SGE , Sys
# mandatory
BATCH = "Sys"

PARTICULAR_BATCH = {
    'toppred' : 'Sys'
    }


# the name of the default queue
DEFAULT_Q = 'local'


# the name of a particular queue for a service
PARTICULAR_Q = {
    'golden':'short'
    }

########################################
#
#     SGE Configuration
#
########################################

# est ce que ca doit etre definit dans le fichier de config de Mobyle?
# est ce qu'il peut y avoir une valeur par default?
# est ce que certains ne vont pas les mettre dans leur environemnt?

SGE_ROOT = "/local/gensoft/adm/sge" 
SGE_CELL = "gensoft"

########################################
#
#       logging
#
########################################

LOGDIR = '/var/log/Mobyle'

# to monitored the elapsed time per job
ACCOUNTING = True


#########################################
#
# disabling services
#
#########################################


DISABLE_ALL = False

#DISABLED_SERVICES = [ ] 
