import os, sys

##################################
#
# Python
#
#################################

try:
    os.environ['MOBYLEHOME'] 
    MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME']= "/home/hmenager/cvs/Mobyle"
    MOBYLEHOME = os.environ['MOBYLEHOME']
    print >> sys.stderr , "CGIJob: the environement variable MOBYLEHOME is not defined"

#append Mobyle Home to the search modules path
if MOBYLEHOME not in sys.path:
    sys.path.append(MOBYLEHOME)
if (os.path.join(MOBYLEHOME,'Src')) not in sys.path:  
    sys.path.append(os.path.join(MOBYLEHOME,'Src'))
    


# path for biopython
#sys.path.append('/opt/local/lib/python2.3/site-packages')

##################################
#
# Debug
#
#################################

# 0   pas de DEBUG   
# 1   construction de la ligne de commande pas de logs, pas d'execution du job 
# 2   logs du remplissage de l'evaluatueur a la construction de la ligne de commande
#        pas d'execution de la ligne de commande
# 3   logs du remplissage de l'evaluateur a la construction de la ligne de commande
#        EXECUTION  de la ligne de commande

DEBUG = 3

PARTICULAR_DEBUG ={
    "toppred" : 3,
    "basicbuilder": 2
    }

###################################
#
# Directories
#
##################################

  
# where to work:
# this is the absolut prefix for jobs results sub-directories
# the results will be in
# TMP_DIR+ programName + xx
# where xx is a random key
RESULTS_PATH = "/var/www/htdocs/MobyleData/jobs"

# were are the binary corresponding to the services
# a list of string
BINARY_PATH = []

TEMPLATES_CACHE_PATH = "/var/www/htdocs/MobyleData/cache"

USER_SESSIONS_PATH = "/var/www/htdocs/MobyleData/sessions"

FORMAT_DETECTOR_CACHE_PATH = "/var/www/htdocs/MobyleData/formatDetector"


###################################
#
# Portal
#
###################################


# the root url of mobyle 
ROOT_URL = "http://antimee.sis.pasteur.fr:80"


# this is the relative path to access to the jobs results sub-directories
# the complete url of a job will be
# ROOT_URL + RESULTS_URL + programName + xx
# where xx is a random key
# exemple for toppred:
# here  http://kerka.sis.pasteur.fr/Mobyle/Results/toppred/M85111376732714
# this directory should correspond to the TMP_DIR

RESULTS_URL = "MobyleData/jobs" #utilise uniquement dans jobstate

SESSIONS_URL = "MobyleData/sessions" #utilise uniquement dans jobstate


#the path to the golden binary 
GOLDEN_PATH = "/usr/local/bin/golden"

#base_project_files_url = '/MobylePortal'
#ROOT_URL + MOBYLEROOT_HTDOCS_URL
MOBYLEROOT_HTDOCS_URL = 'MobylePortal'

#base_project_cgi_url = '/cgi-bin/MobylePortal'
#ROOT_URL + MOBYLEROOT_CGI_URL
MOBYLEROOT_CGI_URL = 'cgi-bin/MobylePortal'


DATATYPE_DATABANK_MAPPING = {
    'Sequence' : ['uniprot'],
    'ProteinSequence' : ['uniprot']
    }

DATABANKS_CONFIG = [
    {'id':'embl', 'dataType':'Sequence', 'bioTypes':['Nucleotide'], 'label': 'EMBL Nucleotide Sequence Database'},
    {'id':'enzyme', 'dataType':'Sequence', 'bioTypes':['Protein'], 'label': 'Enzyme nomenclature database'},
    {'id':'uniprot', 'dataType':'Sequence', 'bioTypes':['Protein'], 'label': 'Universal Protein Resource = SwissProt + TrEMBL + PIR'},
]

  
#####################################
#
# 
#
######################################

# who receives emails when problems occur
# PLEASE change it ;-)
MAINTAINER = "hmenager@pasteur.fr"

HELP="hmenager@pasteur.fr"

# local mailhost
# PLEASE change it ;-)
MAILHOST="mail.pasteur.fr"

# to make email optional for all programs, set this to True
# default value = True
OPT_EMAIL  = False

# to have a more control on the mandatory email
# it able to have the general option but
# it could be set to another value for particular service
# exemple :
# OPT_EMAIL could be set at False ( the email is mandatory )
# but set a True for some very short services.

PARTICULAR_OPT_EMAIL = {'typetest' : True ,
                        'toppred'  : True
                        }

#anonymous session
# 3 availables values 
# no      : the anonymous sessions are not allowed
# yes     : the anonymous sessions are allowed, without any verification 
# captcha : the anonymous sessions are allowed, but with a captcha challenge ( default )
ANONYMOUS_SESSION = "captcha"


#the authenticated sessions are allowed 
#True ( default )/ False
AUTHENTICATED_SESSION = "email"



#####################################
#
#
#
######################################

LANG = 'en'

TIMEOUT = 60 #in seconds


# max size for any file (2 Go)
FILELIMIT = 4294967296 / 2

# set this to 1 if you don't want results to be sent by email
# (this must be set at installation time)
# Notice: This does not make email optional.
# See Makefile.global to make the email optional for all programs
# or do a: make PROGRAM=program OPT_EMAIL=1
# to make it optional for a specific program
DONT_EMAIL_RESULTS = False

# max size for results by email (2 Mo)
MAXMAILSIZE = 2 * 1048576

# parameter for nice (programs are run by the CGI with a given nice priority)
#NICE_VALUE = 5

# how long should results be available on the server?
# See Scripts/clean.pl
RESULT_REMAIN = 10

DNS_RESOLVER = False


####################################################
#                                                  #
#    programs needed by the sequences format       #
#          detection and conversion                # 
#                                                  #
####################################################

# the 2 sequence conveter supprotted by Mobyle are
# squizz and the java version of readseq

SEQCONVERTER= {
    'SQUIZZ': '/usr/local/bin/squizz'
}



#####################################
#
# queuing system
#
######################################

# the allowed values are : PBS , LSF , SGE , Sys
# mandatory
BATCH = "Sys"

PARTICULAR_BATCH = {
    'toppred' : 'Sys'
    }


# the name of the default queue
DEFAULT_Q = 'local'


# the name of a particular queue for a service
PARTICULAR_Q = {
    'golden':'short'
    }

########################################
#
#     SGE Configuration
#
########################################

# est ce que ca doit etre definit dans le fichier de config de Mobyle?
# est ce qu'il peut y avoir une valeur par default?
# est ce que certains ne vont pas les mettre dans leur environemnt?

SGE_ROOT = "/local/gensoft/sge" 
SGE_CELL = "gensoft"

########################################
#
#       logging
#
########################################

LOGDIR = '/var/www/htdocs/MobyleLogs'

# to monitored the elapsed time per job
ACCOUNTING = True



#########################################
#
# disabling services
#
#########################################


DISABLE_ALL = False

#DISABLED_SERVICES = [ ] 


#########################################
#
# restriction services access
#
#########################################


AUTHORIZED_SERVICES = {
    'toppred'  : [ '157.99.*.*' ,'127.0.*.*'],
    'testblast'   : [ '157.99.*.*' , '192,168.3.1','127.0.*.*'],
    'dnapars'  : [ '157.99.60.*','127.0.*.*'],
    'blast2'  : [ '157.99.60.*','127.0.*.*']
    }


# serviceName : [ ip , ip mask ]

# the ip address which can use the service
# ip syntax
#
# 'toppred' : [ '125.234.60.18' , # only the machine with this ip could acces to toppred
#               '125.234.60.*'  , # all the machines in subnet could acces to toppred
#               '125.234.*.15   , # all the machine 
#             ] 
#
# if there is no entry for a service it's mean that
# every body can acces to this service