from Mobyle import ClientAPI
import sys

factory = ClientAPI.ClientFactory()
clustalw = factory.createService('clustalw-multialign')
job1 = clustalw.createJob(quicktree="fast", typeseq="protein", output="PHYLIP")
print >>sys.stderr, "Running clustalw..."
job1.run(infile=sys.argv[1])

if job1.error():
    print >>sys.stderr, sys.argv[0] + ": an error has occured: ", job1.error_message()
    sys.exit(1)


dnapars = factory.createService('protpars')
job2 = dnapars.createJob()
job2.makePipe(job1, outParamName='aligfile', inParamName='infile')
job2.run()

print >>sys.stderr, "Running dnapars..."

if job2.error():
    print >>sys.stderr, "an error has occured: ", job2.error_message()
    sys.exit(1)

for f in job2.getResults():
    s = job2.saveSomeResult(f)
    print "result: ",f, " saved in: ", s







