dnl PERL macros for autoconf

dnl
dnl Checks for perl program, set absolute path to $PERL
dnl
AC_DEFUN(AC_PROG_PERL,
[AC_PATH_PROG(PERL, perl)
if test "x$PERL" = "x"; then
  AC_MSG_ERROR([Perl program not found])
fi
])


dnl
dnl Checks for perl module
dnl
dnl AC_CHECK_PERL_MODULE(VARIABLE, MODULE [, VERSION])
AC_DEFUN(AC_CHECK_PERL_MODULE,
[AC_REQUIRE([AC_PROG_PERL])dnl
ac_msg_module="$2"
if test "x$3" != "x"; then
  ac_msg_module="$2 v$3"
fi
AC_MSG_CHECKING([$ac_msg_module perl module])
ac_have_module="no"
if test "x`$PERL -e 'use $2 $3;' 2>&1`" = "x"; then
  ac_have_module="yes"
fi
$1="$ac_have_module"
AC_MSG_RESULT([$]$1)
])
