/* locus.c - Entry names functions */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "error.h"
#include "index.h"
#include "locus.h"


/* Search in entry names indexes */
result_t *locus_search(char *dbase, char *name) {
  FILE *f;
  char *p, *file, buf[1024];
  result_t *res;

  /* Virtual database indexes */
  file = index_file(NULL, dbase, VIRSUF);
   if (access(file, F_OK) != -1) {
    if ((f = fopen(file, "r")) == NULL) {
      error_fatal("memory", NULL); }
    while (fgets(buf, 1023, f) != NULL) {
      if ((p = strrchr(buf, '\n')) != NULL) { *p = '\0'; }
      res = locus_search(buf, name);
      if (res == NULL) { continue; }
      res->dbase = strdup(buf);
      break; }
    if (fclose(f) == EOF) {
      error_fatal("memory", NULL); }
    free(file); return res; }
 free(file);

  /* Real database indexes */
  file = index_file(NULL, dbase, LOCSUF);
  res = index_search(file, name);
  if (res != NULL) { res->dbase = strdup(dbase); }
  free(file);

  return res; }


/* Merge locus indexes with existing file */
int locus_merge(char *dbase, long nb, indix_t *ind) {
  int i;
  char *file;

  file = index_file(".", dbase, LOCSUF);
  i = index_merge(file, nb, ind);
  free(file);

  return i; }
