/* entry.c - Databases entries functions */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif
#include <ctype.h>

#include "error.h"
#include "entry.h"


/* Parse database flat file entry */
int entry_parse(FILE *f, entry_t *ent) {
  int n;
  char *p, *q, *buf;
  int len;

  len = BUFINC;
  if ((buf = (char *)malloc((size_t)len+1)) == NULL)
    error_fatal("memory", NULL);

  *ent->locus = *ent->access = '\0'; ent->offset = -1;
  while(fgets(buf, len, f) != NULL) {

    /* Checks for entry end */
    if (*buf == '/' && *(buf+1) == '/') break;

    /* Checks for locus line (entry offset) */
    if ((*buf == 'I' && strncmp(buf, "ID ", 3) == 0) ||
        (*buf == 'L' && strncmp(buf, "LOCUS ", 6) == 0) ||
        (*buf == 'E' && strncmp(buf, "ENTRY ", 6) == 0)) {
      ent->offset = ftell(f) - strlen(buf);
      p = buf; q = ent->locus; n = NAMLEN;
      while(*p && !isspace((int)*p)) p++;
      while(*p && isspace((int)*p)) p++;
      while(*p && *p != ';' && !isspace((int)*p) && n--) *q++ = *p++;
      *q = '\0';
      if (n < 0 && *p != ';' && !isspace((int)*p))
	error_fatal("locus", "name too long");
      continue; }

    /* Checks for primary accession */
    if (*buf == 'A' && (strncmp(buf, "AC ", 3) == 0 ||
                        strncmp(buf, "ACCESSION ", 10) == 0 ||
                        strncmp(buf, "ACCESSIONS ", 11) == 0)) {
      p = buf; q = ent->access; n = NAMLEN;
      if (*q != '\0') continue;
      while(*p && !isspace((int)*p)) p++;
      while(*p && isspace((int)*p)) p++;
      while(*p && *p != ';' && !isspace((int)*p) && n--) *q++ = *p++;
      *q = '\0';
      if (n < 0 && *p != ';' && !isspace((int)*p))
	error_fatal("accession", "name too long");
      continue; }
    
  }

  free(buf);

  if (feof(f) && ent->offset == -1)
    return 1;

  return 0; }


/* Display database flat file entry */
int entry_display(FILE *f) {
  char *buf;
  int len;
  
  len = BUFINC;
  if ((buf = (char *)malloc((size_t)len+1)) == NULL)
    error_fatal("memory", NULL);

  while(fgets(buf, len, f) != NULL) {
    
    /* Print entry line */
    (void)fprintf(stdout, "%s", buf);
    
    /* Checks for entry end */
    if (*buf == '/' && *(buf+1) == '/') break; }

  free(buf);

  return 0; }
