/* access.c - Accession numbers functions */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "access.h"
#include "error.h"
#include "index.h"

#define ACCSUF "acx"


/* Search in accession indexes */
indix_t access_search(char *dbase, char *name) {
  char *p, *file;
  size_t len;
  indix_t res;

  p = index_dir();
  len = strlen(p) + 1 + strlen(dbase) + 1 + strlen(ACCSUF);
  if ((file = (char *)malloc(len+1)) == NULL)
    error_fatal("memory", NULL);
  (void)sprintf(file, "%s/%s.%s", p, dbase, ACCSUF);

  res = index_search(file, name);

  free(file);

  return res; }


/* Merge accession indexes */
int access_merge(char *dbase, long nb, indix_t *ind) {
  int i;
  char *file;
  size_t len;
  
  len = strlen(dbase) + 1 + strlen(ACCSUF);
  if ((file = (char *)malloc(len+1)) == NULL)
    error_fatal("memory", NULL);
  (void)sprintf(file, "%s.%s", dbase, ACCSUF);

  i = index_merge(file, nb, ind);

  free(file);

  return i; }
