#! /bin/sh

# Default
./fastqrw $srcdir/sample.fq || exit 1

# Without data on quality header line
sed 's,^+.*/1$,+,' $srcdir/sample.fq >_sample.fq || exit 1
./fastqrw _sample.fq || exit 1

# Sequence/Quality count mismatch
printf "@seq\nATCG\n+\nbbbb\n" >_sample.fq || exit 1
./fastqrw _sample.fq || exit 1
printf "@seq\nATCG\n+\nbbb\n" >_sample.fq || exit 1
./fastqrw _sample.fq && exit 1
printf "@seq\nATCG\n+\nbbbbb\n" >_sample.fq || exit 1
./fastqrw _sample.fq && exit 1

# Cleanup
rm -f _*.fq

exit 0
