
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <err.h>
#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#include <libgen.h>
#include <stddef.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <stdlib.h>
#include <string.h>

#include "compat.h"
#include "xfile.h"

static void usage(char *);


int main(int argc, char **argv) {
  FILE *ou;
  char *p, *prg, *ofile;
  int i;
  uint64_t nseq, nbas;

  char *q, *xbuf;
  ptrdiff_t dif;
  size_t xfer, xinc, xmax;
  ssize_t ssiz, rsiz;
  uint64_t lig;
  xfile_t *xf;

  /* Inits */
  prg = basename(*argv);
  ou = stdout; ofile = NULL;
  nseq = nbas = 0;

  while ((i = getopt(argc, argv, "ho:")) != -1) {
    switch (i) {
    case 'h':
      usage(prg); return EXIT_SUCCESS;
    case 'o':
      ofile = optarg; break;
    default:
      usage(prg); return EXIT_FAILURE; }
  }
  if (argc - optind < 1) {
    usage(prg); return EXIT_FAILURE; }

  if (ofile != NULL && (ou = fopen(ofile, "w")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", ofile);

  /* Proceed all sequence files */
  for (i = optind; i < argc; i++) {
    const char *ifile = *(argv+i);

    if ((xf = xfile_open(ifile, "r")) == NULL)
      err(EXIT_FAILURE, "%s: open failed", ifile);
    xfile_xfer(&xfer, xf); xinc = xfer; xmax = 10 * xinc;
    if ((xbuf = malloc(xfer+1)) == NULL)
      err(EXIT_FAILURE, "memory allocation failed");
    ssiz = rsiz = 0; lig = 0;
    while (/*CONSTCOND*/1) {
      ssiz = xfile_read(xf, xbuf + rsiz, xfer - (size_t)rsiz);
      if (ssiz < 1) break;
      rsiz += ssiz; p = xbuf;
      while (/*CONSTCOND*/ 1) {
	q = memchr(p, '\n', (size_t)rsiz);
	if (q == NULL) { break; }
	dif = q - p + 1; p = q + 1; lig++;
	rsiz -= dif;
	if (lig % 4 != 0) continue;
	nseq += 1; nbas += (uint64_t)dif - 1;
      }
      if (rsiz == 0) continue;
      (void)memmove(xbuf, p, (size_t)rsiz);
      if (p != xbuf) continue;
      if (xfer == xmax)
        errx(EXIT_FAILURE, "%s: line too long", ifile);
      xfer += xinc;
      if ((xbuf = realloc(xbuf, xfer+1)) == NULL)
        err(EXIT_FAILURE, "realloc failed");
    }
    if (xfile_error(xf) != 0)
      err(EXIT_FAILURE, "%s: read failed", ifile);
    if (lig % 4 != 0)
      errx(EXIT_FAILURE, "%s: truncated file", ifile);
    free(xbuf);
    if (xfile_close(xf) == EOF)
      err(EXIT_FAILURE, "%s: close failed", ifile);
  }

  fprintf(ou, "Found %"PRIu64" sequences, %"PRIu64" bases\n", nseq, nbas);
  if (ofile != NULL && fclose(ou) == EOF)
    err(EXIT_FAILURE, "%s: close failed", ofile);

  return EXIT_SUCCESS; }


static void usage(char *prg) {
  FILE *f = stderr;

  (void)fprintf(f, "usage: %s [options] <file> [...]\n", prg);
  (void)fprintf(f, "\noptions:\n");
  (void)fprintf(f, "  -h        ... Print this message and exit.\n");
  (void)fprintf(f, "  -o <file> ... Save output to <file>.\n");

  return; }
