#! @XPERLX@

use strict;
use warnings;

use sigtrap qw(handler handler normal-signals);

use File::Basename;
use Getopt::Std;

# Inits
my $prg = File::Basename::basename($0);
my %opt = ();
my $dir = '@pkglibexecdir@';
my ($ouf, $ofd) = (undef, \*STDOUT);

# Command line
if (not Getopt::Std::getopts('ho:', \%opt)) { usage($prg); exit 1; }
if (exists $opt{'h'}) { usage($prg); exit 0; }
if (exists $opt{'o'}) { $ouf = $opt{'o'}; }
if (scalar @ARGV != 2) { usage($prg); exit 1; }
my ($fil1, $fil2) = @ARGV;

# Output file
if (defined $ouf) {
  END { close $ofd; }
  open $ofd, ">$ouf" or die "$prg: $ouf: $!\n"; }

# Extract sequence names from files
END { unlink "$prg$$.1", "$prg$$.2"; }
system "fqseqname -p -o $prg$$.1 $fil1 && sort -o $prg$$.1 $prg$$.1" and
  die "$prg: $fil1: sequence names failed\n";
system "fqseqname -p -o $prg$$.2 $fil2 && sort -o $prg$$.2 $prg$$.2" and
  die "$prg: $fil2: sequence names failed\n";
open IN, "comm -12 $prg$$.1 $prg$$.2 |" or
  die "$prg: cannot get pairs\n";
while (<IN>) { print $ofd "$_"; }
close IN;

exit 0;


## Usage display
sub usage {
  my ($nam) = @_;
  printf STDERR "usage: %s [-h] [-o <file>] <file> <file>\n", $nam; }

## Signal handler
sub handler { exit 1; }
