/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.Alignment;
import java.util.Arrays;
import java.util.TreeSet;

public class NucleotideAlignment
extends Alignment {
    private final char[] character = new char[]{'A', 'G', 'C', 'T', 'U', 'M', 'R', 'W', 'S', 'Y', 'K', 'B', 'D', 'H', 'V', 'N', 'X', '?', '-'};
    private final int A = 0;
    private final int G = 1;
    private final int C = 2;
    private final int T = 3;
    private final double THD = 0.3333333333333333;
    private final double PVAL = 0.1;
    private static double[] freq;
    private static double total;
    private static TreeSet<Character> alphabet;
    private static int i;
    private static int j;
    private static int b;
    private static char c;
    private static StringBuffer sb;
    private static NucleotideAlignment dnaAlig;

    public NucleotideAlignment() {
        alphabet = new TreeSet();
        i = -1;
        while (++i < this.character.length) {
            alphabet.add(new Character(this.character[i]));
        }
    }

    public static String filter(String string) {
        sb = new StringBuffer(string);
        j = -1;
        while (++j < sb.length()) {
            if (alphabet.contains(new Character(sb.charAt(j)))) continue;
            sb.setCharAt(j, new Character('X').charValue());
        }
        return sb.toString();
    }

    public boolean isRNA() {
        i = -1;
        while (++i < super.size()) {
            if (super.getSequence(i).indexOf("U") == -1) continue;
            return true;
        }
        return false;
    }

    public boolean setCharAt(int n, int n2, char c) {
        if (!alphabet.contains(new Character(c))) {
            return false;
        }
        return super.setCharAt(n, n2, c);
    }

    public int getAlphabetSize() {
        return 4;
    }

    public double[] getFrequencies(int n) {
        freq = new double[this.getAlphabetSize()];
        Arrays.fill(freq, 0.0);
        total = 0.0;
        i = -1;
        block17: while (++i < super.size()) {
            total += 1.0;
            switch (super.getSequence(i).charAt(n)) {
                case 'A': {
                    freq[0] = freq[0] + 1.0;
                    continue block17;
                }
                case 'G': {
                    freq[1] = freq[1] + 1.0;
                    continue block17;
                }
                case 'C': {
                    freq[2] = freq[2] + 1.0;
                    continue block17;
                }
                case 'T': 
                case 'U': {
                    freq[3] = freq[3] + 1.0;
                    continue block17;
                }
                case 'M': {
                    freq[0] = freq[0] + 0.5;
                    freq[2] = freq[2] + 0.5;
                    continue block17;
                }
                case 'R': {
                    freq[0] = freq[0] + 0.5;
                    freq[1] = freq[1] + 0.5;
                    continue block17;
                }
                case 'W': {
                    freq[0] = freq[0] + 0.5;
                    freq[3] = freq[3] + 0.5;
                    continue block17;
                }
                case 'S': {
                    freq[2] = freq[2] + 0.5;
                    freq[1] = freq[1] + 0.5;
                    continue block17;
                }
                case 'Y': {
                    freq[2] = freq[2] + 0.5;
                    freq[3] = freq[3] + 0.5;
                    continue block17;
                }
                case 'K': {
                    freq[1] = freq[1] + 0.5;
                    freq[3] = freq[3] + 0.5;
                    continue block17;
                }
                case 'B': {
                    freq[2] = freq[2] + 0.3333333333333333;
                    freq[1] = freq[1] + 0.3333333333333333;
                    freq[3] = freq[3] + 0.3333333333333333;
                    continue block17;
                }
                case 'D': {
                    freq[0] = freq[0] + 0.3333333333333333;
                    freq[1] = freq[1] + 0.3333333333333333;
                    freq[3] = freq[3] + 0.3333333333333333;
                    continue block17;
                }
                case 'H': {
                    freq[0] = freq[0] + 0.3333333333333333;
                    freq[2] = freq[2] + 0.3333333333333333;
                    freq[3] = freq[3] + 0.3333333333333333;
                    continue block17;
                }
                case 'V': {
                    freq[0] = freq[0] + 0.3333333333333333;
                    freq[2] = freq[2] + 0.3333333333333333;
                    freq[1] = freq[1] + 0.3333333333333333;
                    continue block17;
                }
                case 'N': 
                case 'X': {
                    freq[0] = freq[0] + 0.25;
                    freq[1] = freq[1] + 0.25;
                    freq[2] = freq[2] + 0.25;
                    freq[3] = freq[3] + 0.25;
                    continue block17;
                }
            }
            total -= 1.0;
        }
        freq[0] = freq[0] / total;
        freq[1] = freq[1] / total;
        freq[2] = freq[2] / total;
        freq[3] = freq[3] / total;
        return freq;
    }

    public NucleotideAlignment toNucleotideAlignment() {
        dnaAlig = new NucleotideAlignment();
        i = -1;
        while (++i < super.size()) {
            dnaAlig.add(super.getSequence(i), super.getLabel(i));
        }
        return dnaAlig;
    }

    public NucleotideAlignment toRYcodingAlignment() {
        dnaAlig = new NucleotideAlignment();
        i = -1;
        while (++i < super.size()) {
            sb = new StringBuffer(super.getSequence(i));
            j = -1;
            block7: while (++j < super.length()) {
                switch (sb.charAt(j)) {
                    case 'A': 
                    case 'G': {
                        sb.setCharAt(j, 'R');
                        continue block7;
                    }
                    case 'C': 
                    case 'T': {
                        sb.setCharAt(j, 'Y');
                        continue block7;
                    }
                    case '?': {
                        sb.setCharAt(j, '?');
                        continue block7;
                    }
                    case '-': {
                        sb.setCharAt(j, '-');
                        continue block7;
                    }
                }
                sb.setCharAt(j, 'X');
            }
            dnaAlig.add(sb.toString(), super.getLabel(i));
        }
        return dnaAlig;
    }
}

