/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.AminoAcidAlignment;
import jap.CodonAlignment;
import jap.NucleotideAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment {
    private ArrayList<StringBuffer> sequence = new ArrayList(0);
    private ArrayList<String> label = new ArrayList(0);
    private ArrayList<Character> alphabet = new ArrayList(0);
    private double[] freq;
    private double total;
    private int i;
    private int j;
    private int c;
    private char ch;
    private String line;
    private ArrayList<String> charState;
    private ArrayList<Integer> charStateCount;

    public int size() {
        return this.sequence.size();
    }

    public int length() {
        if (this.size() == 0) {
            return -1;
        }
        return this.sequence.get(0).length();
    }

    public boolean add(String string) {
        this.i = 0;
        this.line = "label" + this.i;
        while (!this.label.contains(this.line)) {
            this.line = "label" + ++this.i;
        }
        return this.add(string, this.line);
    }

    public boolean add(String string, String string2) {
        if (this.size() == 0 || string.length() == this.length()) {
            this.sequence.add(new StringBuffer(string.toUpperCase()));
            this.label.add(string2);
            return true;
        }
        return false;
    }

    public boolean add(int n, String string) {
        this.i = 0;
        this.line = "label" + this.i;
        while (!this.label.contains(this.line)) {
            this.line = "label" + ++this.i;
        }
        return this.add(n, string, this.line);
    }

    public boolean add(int n, String string, String string2) {
        if (this.size() > n && n >= 0 && string.length() == this.length()) {
            this.sequence.add(n, new StringBuffer(string.toUpperCase()));
            this.label.add(n, string2);
            return true;
        }
        return false;
    }

    public boolean set(int n, String string) {
        return this.set(n, string, this.label.get(n));
    }

    public boolean set(int n, String string, String string2) {
        if (this.size() > n && n >= 0 && string.length() == this.length()) {
            this.sequence.set(n, new StringBuffer(string.toUpperCase()));
            this.label.set(n, string2);
            return true;
        }
        return false;
    }

    public boolean removeRow(int n) {
        if (this.size() > n && n >= 0) {
            this.sequence.remove(n);
            this.label.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeColumn(int n) {
        if (this.length() > n && n >= 0) {
            this.i = -1;
            while (++this.i < this.size()) {
                this.sequence.set(this.i, this.sequence.get(this.i).deleteCharAt(n));
            }
            return true;
        }
        return false;
    }

    public String getSequence(int n) {
        if (this.size() > n && n >= 0) {
            return this.sequence.get(n).toString();
        }
        return null;
    }

    public String getLabel(int n) {
        if (this.size() > n && n >= 0) {
            return this.label.get(n);
        }
        return null;
    }

    public char charAt(int n, int n2) {
        if (this.size() > n && n >= 0 && this.length() > n2 && n2 >= 0) {
            return this.sequence.get(n).charAt(n2);
        }
        return '\u0000';
    }

    public String getCharAt(int n, int n2) {
        return "" + this.charAt(n, n2);
    }

    public String getCodonAt(int n, int n2) {
        return null;
    }

    public boolean setCodonAt(int n, int n2, String string) {
        return false;
    }

    public boolean setCharAt(int n, int n2, char c) {
        if (this.size() > n && n >= 0 && this.length() > n2 && n2 >= 0) {
            this.sequence.get(n).setCharAt(n2, c);
            return true;
        }
        return false;
    }

    public int getAlphabetSize() {
        return this.alphabet.size();
    }

    public double[] getFrequencies(int n) {
        this.freq = new double[this.getAlphabetSize()];
        Arrays.fill(this.freq, 0.0);
        return this.freq;
    }

    public double getColGapRate(int n) {
        if (this.length() > n && n >= 0) {
            this.c = 0;
            this.total = 0.0;
            this.i = -1;
            while (++this.i < this.size()) {
                this.total += 1.0;
                if (this.sequence.get(this.i).charAt(n) != '-') continue;
                ++this.c;
            }
            return (double)this.c / this.total;
        }
        return 0.0;
    }

    public double getRowGapRate(int n) {
        if (this.size() > n && n >= 0) {
            this.c = 0;
            this.total = 0.0;
            this.j = -1;
            while (++this.j < this.length()) {
                this.total += 1.0;
                if (this.sequence.get(n).charAt(this.j) != '-') continue;
                ++this.c;
            }
            return (double)this.c / this.total;
        }
        return 0.0;
    }

    public ArrayList<String> getMajorityCharacter(int n) {
        this.charState = new ArrayList(0);
        if (this.length() > n && n >= 0) {
            this.charStateCount = new ArrayList(0);
            this.total = 0.0;
            this.i = -1;
            while (++this.i < this.size()) {
                this.line = this.getCharAt(this.i, n);
                if (this.line.equals("-") || this.line.equals("X") || this.line.equals("?")) continue;
                if (!this.charState.contains(this.line)) {
                    this.charState.add(this.line);
                    this.charStateCount.add(new Integer(1));
                    if (!(this.total < 1.0)) continue;
                    this.total = 1.0;
                    continue;
                }
                this.j = this.charState.indexOf(this.line);
                this.c = this.charStateCount.get(this.j);
                this.charStateCount.set(this.j, new Integer(++this.c));
                if (!(this.total < (double)this.c)) continue;
                this.total = this.c;
            }
            this.c = -1;
            while (++this.c < this.charState.size()) {
                if (!((double)this.charStateCount.get(this.c).intValue() < this.total)) continue;
                this.charState.remove(this.c);
                this.charStateCount.remove(this.c--);
            }
        }
        return this.charState;
    }

    public AminoAcidAlignment toAminoAcidAlignment() {
        return new AminoAcidAlignment();
    }

    public NucleotideAlignment toNucleotideAlignment() {
        return new NucleotideAlignment();
    }

    public NucleotideAlignment toNucleotideAlignment(int n) {
        return new NucleotideAlignment();
    }

    public CodonAlignment toCodonAlignment() {
        return new CodonAlignment();
    }

    public NucleotideAlignment toRYcodingAlignment() {
        return new NucleotideAlignment();
    }

    public BitSet stationaryTrimming(ArrayList<Double> arrayList, BitSet bitSet, BitSet bitSet2) {
        return new BitSet();
    }
}

