/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import jap.Alignment;
import jap.AminoAcidAlignment;
import jap.AminoAcidMeter;
import jap.CodonAlignment;
import jap.CodonMeter;
import jap.Meter;
import jap.Model;
import jap.NucleotideAlignment;
import jap.NucleotideMeter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Locale;

public class BMGE {
    static final byte AA = 0;
    static final byte DNA = 1;
    static final byte COD = 2;
    static final byte RY = 3;
    static final byte PHYLIP = 0;
    static final byte FASTA = 1;
    static final byte PAUP = 2;
    static final byte HTML = 3;
    static final byte PHYLIP_TAX = 4;
    static final byte PAUP_TAX = 5;
    static final byte PHYLIP_ACCN = 6;
    static final byte PAUP_ACCN = 7;
    static final byte NO = 0;
    static final byte WARNING = 1;
    static final byte YES = 2;
    static final byte FAST = 3;
    static final String BLANK = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ";
    static final int REPLICATE = 10;
    static final double REJECTION_PVALUE = 0.1;
    static final char[] NT = new char[]{'A', 'C', 'G', 'T'};
    static final char[] AM = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    static final String[] optName = new String[]{"-i", "-t", "-m", "-w", "-g", "-o", "-c", "-h", "-b", "-l", "-s"};
    static String[] optChoice;
    static byte characterState;
    static double hmin;
    static double hmax;
    static Matrix similarity;
    static double rowGapRate;
    static double colGapRate;
    static int slidingWindow;
    static int minBlockSize;
    static int lengthDisplay;
    static byte stationarity;
    static Alignment alignment;
    static Alignment alignment_;
    static Alignment alignmentCleaned;
    static Alignment alignmentComplement;
    static BitSet keepRow;
    static BitSet keepCol;
    static ArrayList<String> rwLabel;
    static ArrayList<Double> entropy;
    static ArrayList<Double> smoothedEntropy;
    static ArrayList<Double> gapCol;
    static ArrayList<Double> gapRow;
    static double[] frequency;
    static double[] eigenvalue;
    static Matrix density;
    static ArrayList<ArrayList<Meter>> alignmentMeter;
    static ArrayList<ArrayList<Meter>> alignmentGamma;
    static ArrayList<ArrayList<Double>> alignmentStuartValue;
    static double stuartMax;
    static double sigma;
    static double sigmaMax;
    static double sigmaCentile;
    static int b_sigmaMax;
    static File infile;
    static File outfile;
    static BufferedReader in;
    static BufferedWriter out;
    static ArrayList<String> outputOption;
    static ArrayList<File> outputFileName;
    static byte outputFormat;
    static byte outputType;
    static int codonCode;
    static int maxLabelLength;
    static int b;
    static int bb;
    static int i;
    static int j;
    static int c;
    static int n;
    static int cpt1;
    static int cpt2;
    static int left;
    static int right;
    static int lgth;
    static int s1;
    static int s2;
    static int r;
    static int best_character;
    static int min_stscore;
    static int max;
    static double d;
    static double g;
    static double h;
    static double up;
    static double down;
    static double maxGapFrequency;
    static double pValue;
    static double score;
    static char ch;
    static char c1;
    static char c2;
    static String line;
    static String label;
    static String codon1;
    static String codon2;
    static StringBuffer sequence;
    static ArrayList<Integer> blockStart;
    static ArrayList<Integer> blockEnd;
    static boolean ok;
    static boolean previousCol;
    static boolean recompute;
    static BitSet removed;
    static Meter meter;
    static ArrayList<Double> sigmaArray;
    static ArrayList<Double> sigmaArray2;
    static int i_;
    static int l_;
    static double[] array_;
    static String _b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        Arrays.sort(optName);
        optChoice = new String[optName.length];
        Arrays.fill(optChoice, "null");
        outputOption = new ArrayList(0);
        outputFileName = new ArrayList(0);
        if (stringArray.length == 0) {
            System.out.println("   mandatory parameters: -i 'infile' -t 'type'");
            System.out.println("   use option -? for a description of the arguments");
            System.exit(0);
        }
        try {
            b = -1;
            while (++b < stringArray.length) {
                if (stringArray[b].equals("-i") || stringArray[b].equals("-h") || stringArray[b].equals("-g") || stringArray[b].equals("-w") || stringArray[b].equals("-b") || stringArray[b].equals("-t") || stringArray[b].equals("-l") || stringArray[b].equals("-s") || stringArray[b].equals("-m")) {
                    line = stringArray[b];
                    BMGE.optChoice[Arrays.binarySearch((Object[])BMGE.optName, (Object)BMGE.line)] = stringArray[++b];
                } else {
                    if (stringArray[b].equals("-?")) {
                        BMGE.displayUserGuide();
                        System.exit(0);
                    }
                    if (stringArray[b].startsWith("-o") || stringArray[b].startsWith("-c")) {
                        outputOption.add(stringArray[b]);
                        outputFileName.add(new File(stringArray[++b]));
                    }
                }
                if (!stringArray[b].startsWith("-")) continue;
                System.out.println("   incorrect option " + stringArray[b - 1]);
                System.exit(0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("   incorrect options");
            System.exit(0);
        }
        b = Arrays.binarySearch(optName, "-i");
        if (optChoice[b].equals("null")) {
            System.out.println("   the input file name is not given (option -i)");
            System.exit(0);
        }
        if (!(infile = new File(optChoice[b])).exists()) {
            System.out.println("   problem with the input file : " + infile.toString() + " does not exist");
            System.exit(0);
        }
        if (optChoice[b = Arrays.binarySearch(optName, "-t")].equals("null")) {
            System.out.println("   the type of character states is not given (option -t [AA,DNA,RNA,CODON])");
            System.exit(0);
        }
        characterState = (byte)-1;
        if (optChoice[b].equals("AA")) {
            characterState = 0;
        }
        if (optChoice[b].equals("DNA") || line.equals("RNA")) {
            characterState = 1;
        }
        if (optChoice[b].equals("CODON")) {
            characterState = (byte)2;
        }
        if (characterState == -1) {
            System.out.println("   invalid type of character states (option -t [AA,DNA,RNA,CODON])");
            System.exit(0);
        }
        if (optChoice[b = Arrays.binarySearch(optName, "-w")].equals("null")) {
            slidingWindow = 3;
        } else {
            try {
                slidingWindow = Integer.parseInt(optChoice[b]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("   incorrect sliding window size (option -w)");
                System.exit(0);
            }
        }
        if (slidingWindow % 2 == 0) {
            System.out.println("   the size of the sliding window must be odd (option -w)");
            System.exit(0);
        }
        if (optChoice[b = Arrays.binarySearch(optName, "-b")].equals("null")) {
            minBlockSize = 5;
        } else {
            try {
                minBlockSize = Integer.parseInt(optChoice[b]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("   incorrect minimum block size (option -b)");
                System.exit(0);
            }
        }
        if (minBlockSize < 0) {
            System.out.println("   the minimum block size must be greater than 0 (option -b)");
            System.exit(0);
        }
        b = Arrays.binarySearch(optName, "-g");
        rowGapRate = 1.0;
        colGapRate = 0.2;
        if (!optChoice[b].equals("null")) {
            line = optChoice[b];
            c = line.indexOf(":");
            if (c != -1) {
                try {
                    rowGapRate = Double.parseDouble(line.substring(0, c));
                    colGapRate = Double.parseDouble(line.substring(++c));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   the gap rates are not correct (option -g)");
                    System.exit(0);
                }
            } else {
                try {
                    colGapRate = Double.parseDouble(line);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   the gap rate is not correct (option -g)");
                    System.exit(0);
                }
            }
            if (Math.min(rowGapRate, colGapRate) < 0.0 || Math.max(rowGapRate, colGapRate) > 1.0) {
                System.out.println("   the gap rates must range from 0 to 1");
                System.exit(0);
            }
        }
        b = Arrays.binarySearch(optName, "-h");
        hmin = 0.0;
        hmax = 0.5;
        if (!optChoice[b].equals("null")) {
            line = optChoice[b];
            c = line.indexOf(":");
            if (c != -1) {
                try {
                    hmin = Double.parseDouble(line.substring(0, c));
                    hmax = Double.parseDouble(line.substring(++c));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   the entropy cut-off values are not correct (option -h)");
                    System.exit(0);
                }
            } else {
                try {
                    hmax = Double.parseDouble(line);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   the entropy cut-off value is not correct (option -h)");
                    System.exit(0);
                }
            }
            if (Math.min(hmin, hmax) < 0.0 || Math.max(hmin, hmax) > 1.0) {
                System.out.println("   the entropy cut-off values must range from 0 to 1");
                System.exit(0);
            }
        }
        similarity = Model.getID(1);
        b = Arrays.binarySearch(optName, "-m");
        if (optChoice[b].equals("null")) {
            switch (characterState) {
                case 0: 
                case 2: {
                    similarity = Model.getAminoAcidSimilarity((byte)62);
                    break;
                }
                case 1: {
                    similarity = Model.getDNAPAM(100, 2.0);
                }
            }
        } else {
            if (optChoice[b].startsWith("BLOSUM")) {
                if (characterState != 0 && characterState != 2) {
                    System.out.println("   the similarity matrix (option -m) is not compatible with the character states (option -t)");
                    System.exit(0);
                }
                try {
                    c = Integer.parseInt(optChoice[b].substring(6));
                }
                catch (NumberFormatException numberFormatException) {
                    c = 0;
                }
                switch (c) {
                    case 30: {
                        similarity = Model.getAminoAcidSimilarity((byte)30);
                        break;
                    }
                    case 35: {
                        similarity = Model.getAminoAcidSimilarity((byte)35);
                        break;
                    }
                    case 40: {
                        similarity = Model.getAminoAcidSimilarity((byte)40);
                        break;
                    }
                    case 45: {
                        similarity = Model.getAminoAcidSimilarity((byte)45);
                        break;
                    }
                    case 50: {
                        similarity = Model.getAminoAcidSimilarity((byte)50);
                        break;
                    }
                    case 55: {
                        similarity = Model.getAminoAcidSimilarity((byte)55);
                        break;
                    }
                    case 60: {
                        similarity = Model.getAminoAcidSimilarity((byte)60);
                        break;
                    }
                    case 62: {
                        similarity = Model.getAminoAcidSimilarity((byte)62);
                        break;
                    }
                    case 65: {
                        similarity = Model.getAminoAcidSimilarity((byte)65);
                        break;
                    }
                    case 70: {
                        similarity = Model.getAminoAcidSimilarity((byte)70);
                        break;
                    }
                    case 75: {
                        similarity = Model.getAminoAcidSimilarity((byte)75);
                        break;
                    }
                    case 80: {
                        similarity = Model.getAminoAcidSimilarity((byte)80);
                        break;
                    }
                    case 85: {
                        similarity = Model.getAminoAcidSimilarity((byte)85);
                        break;
                    }
                    case 90: {
                        similarity = Model.getAminoAcidSimilarity((byte)90);
                        break;
                    }
                    case 95: {
                        similarity = Model.getAminoAcidSimilarity((byte)95);
                        break;
                    }
                    case 100: {
                        similarity = Model.getAminoAcidSimilarity((byte)100);
                        break;
                    }
                    default: {
                        similarity = Model.getAminoAcidSimilarity((byte)62);
                    }
                }
            }
            if (optChoice[b].equals("PAM0") || optChoice[b].equals("ID")) {
                switch (characterState) {
                    case 0: 
                    case 2: {
                        similarity = Model.getID(20);
                        break;
                    }
                    case 1: {
                        similarity = Model.getID(4);
                    }
                }
            }
            if (optChoice[b].startsWith("DNAPAM")) {
                if (characterState != 1) {
                    System.out.println("   the similarity matrix (option -m) is not compatible with the character states (option -t)");
                    System.exit(0);
                }
                line = optChoice[b].substring(6);
                c = line.indexOf(":");
                try {
                    i = c == -1 ? Integer.parseInt(line) : Integer.parseInt(line.substring(0, c));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   the similarity matrix DNAPAM must be defined with an integer value, e.g. DNAPAM47 (option -m)");
                    System.exit(0);
                }
                try {
                    h = c == -1 ? 1.0 : Double.parseDouble(line.substring(++c));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("   incorrect DNAPAM transition/tranversion ratio (option -m)");
                    System.exit(0);
                }
                similarity = Model.getDNAPAM(i, h);
            }
            if (similarity.getRowDimension() * similarity.getColumnDimension() == 1) {
                System.out.println("   incorrect similarity matrix name (option -m)");
                System.exit(0);
            }
        }
        b = Arrays.binarySearch(optName, "-s");
        stationarity = 0;
        if (optChoice[b].toUpperCase().equals("NO")) {
            stationarity = 0;
        }
        if (optChoice[b].toUpperCase().equals("YES")) {
            stationarity = (byte)2;
        }
        if (optChoice[b].toUpperCase().equals("FAST")) {
            stationarity = (byte)3;
        }
        if (optChoice[b = Arrays.binarySearch(optName, "-l")].equals("null")) {
            lengthDisplay = Integer.MAX_VALUE;
        } else {
            try {
                lengthDisplay = Integer.parseInt(optChoice[b]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("   incorrect number of characters per line (option -l)");
                System.exit(0);
            }
        }
        if (lengthDisplay < 0) {
            System.out.println("   the number of characters per line must be greater than 0 (option -l)");
            System.exit(0);
        }
        if (stationarity != 0 && characterState == 2) {
            System.out.println("  the stationary-based character trimming (option -s) is not available for codon alignments (-t CODON)");
            System.out.print("  set character states as nucleotides (-t DNA -s ");
            if (stationarity == 2) {
                System.out.print("YES");
            } else {
                System.out.print("FAST");
            }
            System.out.println(") or convert them into amino acids (-t CODON -h 1 -g 1 -w 1 -oaa)");
            System.out.println("  in order to use the stationary-based character trimming (option -s)");
            System.exit(0);
        }
        in = new BufferedReader(new FileReader(infile));
        alignment_ = new Alignment();
        try {
            try {
                label = "phylip";
                line = "";
                while (line.length() == 0) {
                    line = in.readLine().trim();
                }
                if (line.startsWith(">")) {
                    label = line.substring(1).trim();
                    sequence = new StringBuffer("");
                    line = in.readLine().trim();
                    while (!line.startsWith(">")) {
                        sequence = sequence.append(line);
                        line = in.readLine().trim();
                    }
                    alignment_.add(sequence.toString(), label);
                    while (true) {
                        label = line.substring(1);
                        sequence = new StringBuffer("");
                        line = in.readLine().trim();
                        while (!line.startsWith(">")) {
                            sequence = sequence.append(line);
                            line = in.readLine().trim();
                        }
                        alignment_.add(sequence.toString(), label);
                    }
                }
                while (true) {
                    if ((line = in.readLine().trim()).length() == 0) {
                        continue;
                    }
                    b = line.indexOf(" ");
                    alignment_.add(line.substring(b).trim(), line.substring(0, b).trim());
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!label.equals("phylip")) {
                    alignment_.add(sequence.toString(), label);
                }
                in.close();
            }
        }
        catch (Throwable throwable) {
            in.close();
            throw throwable;
        }
        if (alignment_.size() * alignment_.length() == 0) {
            System.out.println("   problem with the alignment inside the file " + infile.getName());
            System.exit(0);
        }
        alignment = new Alignment();
        i = -1;
        switch (characterState) {
            case 0: {
                System.out.print("   Amino acid sequence alignment ");
                alignment = new AminoAcidAlignment();
                while (++i < alignment_.size()) {
                    if (alignment.add(AminoAcidAlignment.filter(alignment_.getSequence(i)), alignment_.getLabel(i))) continue;
                    System.out.println("");
                    System.out.println("   problem with sequence " + (i + 1) + " : " + alignment_.getLabel(i));
                    System.exit(0);
                }
                break;
            }
            case 1: {
                System.out.print("   DNA sequence alignment ");
                alignment = new NucleotideAlignment();
                while (++i < alignment_.size()) {
                    if (alignment.add(NucleotideAlignment.filter(alignment_.getSequence(i)), alignment_.getLabel(i))) continue;
                    System.out.println("");
                    System.out.println("   problem with sequence " + (i + 1) + " : " + alignment_.getLabel(i));
                    System.exit(0);
                }
                break;
            }
            case 2: {
                System.out.print("   Codon sequence alignment ");
                alignment = new CodonAlignment();
                while (++i < alignment_.size()) {
                    if (alignment.add(CodonAlignment.filter(alignment_.getSequence(i)), alignment_.getLabel(i))) continue;
                    System.out.println("");
                    System.out.println("   problem with sequence " + (i + 1) + " : " + alignment_.getLabel(i));
                    if (alignment_.getSequence(i).length() % 3 != 0) {
                        System.out.println("   this does not contain trinucleotide character states : length = 3 * " + alignment_.getSequence(i).length() / 3 + " + " + alignment_.getSequence(i).length() % 3);
                    }
                    System.exit(0);
                }
                break;
            }
        }
        System.out.println(infile.getName());
        alignment_ = null;
        System.out.println("   before : " + alignment.size() + " sequences / " + alignment.length() + " characters");
        keepRow = new BitSet(alignment.size());
        i = -1;
        while (++i < alignment.size()) {
            keepRow.set(i);
        }
        do {
            alignment_ = new Alignment();
            i = -1;
            switch (characterState) {
                case 0: {
                    alignment_ = alignment.toAminoAcidAlignment();
                    break;
                }
                case 1: {
                    alignment_ = alignment.toNucleotideAlignment();
                    break;
                }
                case 2: {
                    alignment_ = alignment.toCodonAlignment();
                }
            }
            b = 0;
            i = -1;
            while (++i < keepRow.size()) {
                if (!keepRow.get(i)) {
                    alignment_.removeRow(b);
                    continue;
                }
                ++b;
            }
            entropy = new ArrayList(alignment_.length());
            smoothedEntropy = new ArrayList(alignment_.length());
            gapCol = new ArrayList(alignment_.length());
            g = alignment_.size();
            maxGapFrequency = (g - 1.0) / g;
            j = -1;
            while (++j < alignment_.length()) {
                g = alignment_.getColGapRate(j);
                gapCol.add(new Double(g));
                h = 0.0;
                if (g < 1.0) {
                    if (g == maxGapFrequency) {
                        h = 0.0;
                    } else {
                        frequency = alignment_.getFrequencies(j);
                        h = -1.0;
                        density = new Matrix(alignment_.getAlphabetSize(), alignment_.getAlphabetSize());
                        c = -1;
                        while (++c < alignment_.getAlphabetSize()) {
                            density.set(c, c, frequency[c]);
                            if (frequency[c] != 1.0) continue;
                            h = 0.0;
                            break;
                        }
                        if (h < 0.0) {
                            density = density.times(similarity);
                            density = density.times(1.0 / density.trace());
                            eigenvalue = BMGE.round(density.eig().getRealEigenvalues());
                            h = 0.0;
                            c = -1;
                            while (++c < alignment_.getAlphabetSize()) {
                                h -= eigenvalue[c] * BMGE.log(alignment_.getAlphabetSize(), eigenvalue[c]);
                            }
                        }
                    }
                }
                entropy.add(new Double(h));
                smoothedEntropy.add(new Double(h));
            }
            alignment_ = null;
            if (slidingWindow > 1 && hmax < 1.0) {
                smoothedEntropy = new ArrayList(alignment.length());
                j = -1;
                while (++j < alignment.length()) {
                    up = 0.0;
                    down = 0.0;
                    c = Math.max(-1, j - slidingWindow / 2 - 1);
                    while (++c < Math.min(j + slidingWindow / 2 + 1, alignment.length())) {
                        up += (1.0 - gapCol.get(c)) * entropy.get(c);
                        down += 1.0 - gapCol.get(c);
                    }
                    if (down == 0.0) {
                        down = 1.0E-5;
                    }
                    smoothedEntropy.add(new Double(up / down));
                }
            }
            keepCol = new BitSet(alignment.length());
            j = -1;
            while (++j < alignment.length()) {
                if (!(smoothedEntropy.get(j) < hmax)) continue;
                keepCol.set(j);
            }
            if (hmax < 1.0) {
                ok = true;
                while (!ok) {
                    ok = false;
                    blockStart = new ArrayList(0);
                    blockEnd = new ArrayList(0);
                    j = -1;
                    while (!keepCol.get(++j)) {
                    }
                    blockStart.add(new Integer(j));
                    while (++j < alignment_.length()) {
                        if (keepCol.get(j - 1) == keepCol.get(j)) continue;
                        blockEnd.add(new Integer(j - 1));
                        blockStart.add(new Integer(j));
                    }
                    if (!keepCol.get(j - 1)) {
                        blockStart.remove(blockStart.size() - 1);
                    } else {
                        blockEnd.add(new Integer(j - 1));
                    }
                    i = -1;
                    while ((i += 2) < blockStart.size() - 1) {
                        lgth = blockEnd.get(i) - blockStart.get(i);
                        left = Math.max(0, blockEnd.get(i - 1) - lgth);
                        right = Math.min(alignment_.length(), blockStart.get(i + 1) + lgth) - 1;
                        g = 0.0;
                        j = left - 1;
                        while (++j <= right) {
                            g += gapCol.get(j).doubleValue();
                        }
                        if (!(g < 0.3)) continue;
                        j = blockStart.get(i - 1) - 1;
                        up = 0.0;
                        down = 0.0;
                        while (++j <= blockEnd.get(i + 1)) {
                            up += (1.0 - gapCol.get(j)) * entropy.get(j);
                            down += 1.0 - gapCol.get(j);
                        }
                        h = up / down;
                        if (!(h <= hmax)) continue;
                        j = blockStart.get(i) - 1;
                        while (++j <= blockEnd.get(i)) {
                            keepCol.set(j);
                        }
                        ok = true;
                    }
                }
            }
            if (colGapRate < 1.0) {
                j = -1;
                while (++j < alignment.length()) {
                    if (!(gapCol.get(j) > colGapRate)) continue;
                    keepCol.set(j, false);
                }
            }
            if (minBlockSize > 0) {
                blockStart = new ArrayList(0);
                blockEnd = new ArrayList(0);
                cpt1 = 0;
                j = -1;
                while (++j < alignment.length()) {
                    if (keepCol.get(j) && cpt1 == 0) {
                        blockStart.add(new Integer(j));
                        ++cpt1;
                    }
                    if (keepCol.get(j) || cpt1 <= 0) continue;
                    blockEnd.add(j);
                    cpt1 = 0;
                }
                if (blockStart.size() > blockEnd.size()) {
                    blockEnd.add(new Integer(--j));
                }
                i = -1;
                while (++i < blockStart.size()) {
                    if (blockEnd.get(i) - blockStart.get(i) >= minBlockSize) continue;
                    j = blockStart.get(i) - 1;
                    while (++j < blockEnd.get(i)) {
                        keepCol.set(j, false);
                    }
                }
            }
            if (hmin > 0.0) {
                j = -1;
                while (++j < alignment.length()) {
                    if (!(smoothedEntropy.get(j) <= hmin)) continue;
                    keepCol.set(j, false);
                }
            }
            alignment_ = new Alignment();
            switch (characterState) {
                case 0: {
                    alignment_ = alignment.toAminoAcidAlignment();
                    break;
                }
                case 1: {
                    alignment_ = alignment.toNucleotideAlignment();
                    break;
                }
                case 2: {
                    alignment_ = alignment.toCodonAlignment();
                }
            }
            j = -1;
            while (++j < alignment.length()) {
                if (keepCol.get(j)) continue;
                i = -1;
                while (++i < alignment.size()) {
                    alignment_.setCharAt(i, j, '-');
                }
            }
            if (stationarity != 0) {
                System.out.print("\r" + BLANK.substring(0, 100) + "\r   after :  " + keepRow.cardinality() + " sequences / " + keepCol.cardinality() + " characters");
                stuartMax = 0.0;
                switch (characterState) {
                    case 0: {
                        stuartMax = 27.203;
                        break;
                    }
                    case 1: 
                    case 2: {
                        stuartMax = 6.251;
                    }
                }
                down = alignment.size() * (alignment.size() - 1) / 2;
                alignmentMeter = new ArrayList(alignment.size());
                alignmentStuartValue = new ArrayList(alignment.size());
                ok = true;
                up = 0.0;
                i = -1;
                while (++i < alignment.size()) {
                    alignmentMeter.add(new ArrayList(i));
                    alignmentStuartValue.add(new ArrayList(i));
                    j = -1;
                    while (++j < i) {
                        alignmentMeter.get(i).add(new Meter());
                        alignmentStuartValue.get(i).add(new Double(0.0));
                        if (!keepRow.get(i) || !keepRow.get(j)) continue;
                        switch (characterState) {
                            case 0: {
                                alignmentMeter.get(i).set(j, new AminoAcidMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                break;
                            }
                            case 1: {
                                alignmentMeter.get(i).set(j, new NucleotideMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                break;
                            }
                            case 2: {
                                alignmentMeter.get(i).set(j, new CodonMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                            }
                        }
                        alignmentStuartValue.get(i).set(j, new Double(alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                        if (alignmentStuartValue.get(i).get(j) > stuartMax) {
                            ok = false;
                            continue;
                        }
                        up += 1.0;
                    }
                }
                if (!ok) {
                    alignmentGamma = new ArrayList(alignment.size());
                    i = -1;
                    while (++i < alignment.size()) {
                        alignmentGamma.add(new ArrayList(i));
                        j = -1;
                        while (++j < i) {
                            switch (characterState) {
                                case 0: {
                                    alignmentGamma.get(i).add(new AminoAcidMeter());
                                    break;
                                }
                                case 1: {
                                    alignmentGamma.get(i).add(new NucleotideMeter());
                                    break;
                                }
                                case 2: {
                                    alignmentGamma.get(i).add(new CodonMeter());
                                }
                            }
                        }
                    }
                    switch (stationarity) {
                        case 2: {
                            while (!ok) {
                                System.out.print("\r" + BLANK.substring(0, 100) + "\r   after :  " + keepRow.cardinality() + " sequences / " + keepCol.cardinality() + " characters" + "   [" + (int)(100.0 * up / down) + "%]");
                                i = -1;
                                while (++i < alignment.size()) {
                                    if (!keepRow.get(i)) continue;
                                    j = -1;
                                    block289: while (++j < i) {
                                        if (!keepRow.get(j)) continue;
                                        b = alignmentGamma.get(i).get(j).size();
                                        switch (characterState) {
                                            case 1: {
                                                for (char c : NT) {
                                                    for (char c2 : NT) {
                                                        if (c == c2 || !(alignmentMeter.get(i).get(j).get(c, c2) > 0.0)) continue;
                                                        switch (c) {
                                                            case 'A': {
                                                                s1 = 0;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s1 = 2;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s1 = 1;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s1 = 3;
                                                            }
                                                        }
                                                        switch (c2) {
                                                            case 'A': {
                                                                s2 = 0;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s2 = 2;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s2 = 1;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s2 = 3;
                                                            }
                                                        }
                                                        alignmentMeter.get(i).get(j).decrement(c, c2);
                                                        alignmentGamma.get(i).get(j).set(s1, s2, alignmentStuartValue.get(i).get(j) * (alignmentStuartValue.get(i).get(j) - alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                                        alignmentMeter.get(i).get(j).increment(c, c2);
                                                    }
                                                }
                                                continue block289;
                                            }
                                            case 0: {
                                                for (char c : AM) {
                                                    for (char c2 : AM) {
                                                        if (c == c2 || !(alignmentMeter.get(i).get(j).get(c, c2) > 0.0)) continue;
                                                        switch (c) {
                                                            case 'A': {
                                                                s1 = 0;
                                                                break;
                                                            }
                                                            case 'R': {
                                                                s1 = 4;
                                                                break;
                                                            }
                                                            case 'N': {
                                                                s1 = 7;
                                                                break;
                                                            }
                                                            case 'D': {
                                                                s1 = 3;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s1 = 4;
                                                                break;
                                                            }
                                                            case 'Q': {
                                                                s1 = 5;
                                                                break;
                                                            }
                                                            case 'E': {
                                                                s1 = 6;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s1 = 7;
                                                                break;
                                                            }
                                                            case 'H': {
                                                                s1 = 8;
                                                                break;
                                                            }
                                                            case 'I': {
                                                                s1 = 9;
                                                                break;
                                                            }
                                                            case 'L': {
                                                                s1 = 10;
                                                                break;
                                                            }
                                                            case 'K': {
                                                                s1 = 11;
                                                                break;
                                                            }
                                                            case 'M': {
                                                                s1 = 12;
                                                                break;
                                                            }
                                                            case 'F': {
                                                                s1 = 13;
                                                                break;
                                                            }
                                                            case 'P': {
                                                                s1 = 14;
                                                                break;
                                                            }
                                                            case 'S': {
                                                                s1 = 15;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s1 = 16;
                                                                break;
                                                            }
                                                            case 'W': {
                                                                s1 = 17;
                                                                break;
                                                            }
                                                            case 'Y': {
                                                                s1 = 18;
                                                                break;
                                                            }
                                                            case 'V': {
                                                                s1 = 19;
                                                            }
                                                        }
                                                        switch (c2) {
                                                            case 'A': {
                                                                s2 = 0;
                                                                break;
                                                            }
                                                            case 'R': {
                                                                s2 = 4;
                                                                break;
                                                            }
                                                            case 'N': {
                                                                s2 = 7;
                                                                break;
                                                            }
                                                            case 'D': {
                                                                s2 = 3;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s2 = 4;
                                                                break;
                                                            }
                                                            case 'Q': {
                                                                s2 = 5;
                                                                break;
                                                            }
                                                            case 'E': {
                                                                s2 = 6;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s2 = 7;
                                                                break;
                                                            }
                                                            case 'H': {
                                                                s2 = 8;
                                                                break;
                                                            }
                                                            case 'I': {
                                                                s2 = 9;
                                                                break;
                                                            }
                                                            case 'L': {
                                                                s2 = 10;
                                                                break;
                                                            }
                                                            case 'K': {
                                                                s2 = 11;
                                                                break;
                                                            }
                                                            case 'M': {
                                                                s2 = 12;
                                                                break;
                                                            }
                                                            case 'F': {
                                                                s2 = 13;
                                                                break;
                                                            }
                                                            case 'P': {
                                                                s2 = 14;
                                                                break;
                                                            }
                                                            case 'S': {
                                                                s2 = 15;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s2 = 16;
                                                                break;
                                                            }
                                                            case 'W': {
                                                                s2 = 17;
                                                                break;
                                                            }
                                                            case 'Y': {
                                                                s2 = 18;
                                                                break;
                                                            }
                                                            case 'V': {
                                                                s2 = 19;
                                                            }
                                                        }
                                                        alignmentMeter.get(i).get(j).decrement(c, c2);
                                                        alignmentGamma.get(i).get(j).set(s1, s2, alignmentStuartValue.get(i).get(j) * (alignmentStuartValue.get(i).get(j) - alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                                        alignmentMeter.get(i).get(j).increment(c, c2);
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                    }
                                }
                                sigmaMax = 0.0;
                                b_sigmaMax = -1;
                                b = -1;
                                while (++b < alignment.length()) {
                                    if (!keepCol.get(b) || !(entropy.get(b) > 0.0)) continue;
                                    sigma = 0.0;
                                    i = -1;
                                    while (++i < alignment.size()) {
                                        if (!keepRow.get(i) || (c1 = alignment.charAt(i, b)) == '?' || c1 == '-') continue;
                                        j = -1;
                                        while (++j < i) {
                                            if (!keepRow.get(j) || (c2 = alignment.charAt(j, b)) == '?' || c2 == '-' || c2 == c1) continue;
                                            sigma += alignmentGamma.get(i).get(j).get(c1, c2);
                                        }
                                    }
                                    if (!(sigma > sigmaMax)) continue;
                                    sigmaMax = sigma;
                                    b_sigmaMax = b;
                                }
                                b = b_sigmaMax;
                                keepCol.set(b, false);
                                i = -1;
                                while (++i < alignment.size()) {
                                    alignment_.setCharAt(i, b, '-');
                                }
                                ok = true;
                                d = 0.0;
                                i = -1;
                                while (++i < alignment.size()) {
                                    if (!keepRow.get(i)) continue;
                                    j = -1;
                                    while (++j < i) {
                                        if (!keepRow.get(j)) continue;
                                        switch (characterState) {
                                            case 0: {
                                                alignmentMeter.get(i).set(j, new AminoAcidMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                                break;
                                            }
                                            case 1: {
                                                alignmentMeter.get(i).set(j, new NucleotideMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                                break;
                                            }
                                            case 2: {
                                                alignmentMeter.get(i).set(j, new CodonMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                            }
                                        }
                                        alignmentStuartValue.get(i).set(j, new Double(alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                        if (alignmentStuartValue.get(i).get(j) > stuartMax) {
                                            ok = false;
                                            continue;
                                        }
                                        d += 1.0;
                                    }
                                }
                                up = Math.min(d, up);
                            }
                            break;
                        }
                        case 3: {
                            while (!ok) {
                                System.out.print("\r" + BLANK.substring(0, 100) + "\r   after :  " + keepRow.cardinality() + " sequences / " + keepCol.cardinality() + " characters" + "   [" + (int)(100.0 * up / down) + "%]");
                                i = -1;
                                while (++i < alignment.size()) {
                                    if (!keepRow.get(i)) continue;
                                    j = -1;
                                    block302: while (++j < i) {
                                        if (!keepRow.get(j)) continue;
                                        b = alignmentGamma.get(i).get(j).size();
                                        switch (characterState) {
                                            case 1: {
                                                for (char c : NT) {
                                                    for (char c2 : NT) {
                                                        if (c == c2 || !(alignmentMeter.get(i).get(j).get(c, c2) > 0.0)) continue;
                                                        switch (c) {
                                                            case 'A': {
                                                                s1 = 0;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s1 = 2;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s1 = 1;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s1 = 3;
                                                            }
                                                        }
                                                        switch (c2) {
                                                            case 'A': {
                                                                s2 = 0;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s2 = 2;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s2 = 1;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s2 = 3;
                                                            }
                                                        }
                                                        alignmentMeter.get(i).get(j).decrement(c, c2);
                                                        alignmentGamma.get(i).get(j).set(s1, s2, alignmentStuartValue.get(i).get(j) * (alignmentStuartValue.get(i).get(j) - alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                                        alignmentMeter.get(i).get(j).increment(c, c2);
                                                    }
                                                }
                                                continue block302;
                                            }
                                            case 0: {
                                                for (char c : AM) {
                                                    for (char c2 : AM) {
                                                        if (c == c2 || !(alignmentMeter.get(i).get(j).get(c, c2) > 0.0)) continue;
                                                        switch (c) {
                                                            case 'A': {
                                                                s1 = 0;
                                                                break;
                                                            }
                                                            case 'R': {
                                                                s1 = 4;
                                                                break;
                                                            }
                                                            case 'N': {
                                                                s1 = 7;
                                                                break;
                                                            }
                                                            case 'D': {
                                                                s1 = 3;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s1 = 4;
                                                                break;
                                                            }
                                                            case 'Q': {
                                                                s1 = 5;
                                                                break;
                                                            }
                                                            case 'E': {
                                                                s1 = 6;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s1 = 7;
                                                                break;
                                                            }
                                                            case 'H': {
                                                                s1 = 8;
                                                                break;
                                                            }
                                                            case 'I': {
                                                                s1 = 9;
                                                                break;
                                                            }
                                                            case 'L': {
                                                                s1 = 10;
                                                                break;
                                                            }
                                                            case 'K': {
                                                                s1 = 11;
                                                                break;
                                                            }
                                                            case 'M': {
                                                                s1 = 12;
                                                                break;
                                                            }
                                                            case 'F': {
                                                                s1 = 13;
                                                                break;
                                                            }
                                                            case 'P': {
                                                                s1 = 14;
                                                                break;
                                                            }
                                                            case 'S': {
                                                                s1 = 15;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s1 = 16;
                                                                break;
                                                            }
                                                            case 'W': {
                                                                s1 = 17;
                                                                break;
                                                            }
                                                            case 'Y': {
                                                                s1 = 18;
                                                                break;
                                                            }
                                                            case 'V': {
                                                                s1 = 19;
                                                            }
                                                        }
                                                        switch (c2) {
                                                            case 'A': {
                                                                s2 = 0;
                                                                break;
                                                            }
                                                            case 'R': {
                                                                s2 = 4;
                                                                break;
                                                            }
                                                            case 'N': {
                                                                s2 = 7;
                                                                break;
                                                            }
                                                            case 'D': {
                                                                s2 = 3;
                                                                break;
                                                            }
                                                            case 'C': {
                                                                s2 = 4;
                                                                break;
                                                            }
                                                            case 'Q': {
                                                                s2 = 5;
                                                                break;
                                                            }
                                                            case 'E': {
                                                                s2 = 6;
                                                                break;
                                                            }
                                                            case 'G': {
                                                                s2 = 7;
                                                                break;
                                                            }
                                                            case 'H': {
                                                                s2 = 8;
                                                                break;
                                                            }
                                                            case 'I': {
                                                                s2 = 9;
                                                                break;
                                                            }
                                                            case 'L': {
                                                                s2 = 10;
                                                                break;
                                                            }
                                                            case 'K': {
                                                                s2 = 11;
                                                                break;
                                                            }
                                                            case 'M': {
                                                                s2 = 12;
                                                                break;
                                                            }
                                                            case 'F': {
                                                                s2 = 13;
                                                                break;
                                                            }
                                                            case 'P': {
                                                                s2 = 14;
                                                                break;
                                                            }
                                                            case 'S': {
                                                                s2 = 15;
                                                                break;
                                                            }
                                                            case 'T': {
                                                                s2 = 16;
                                                                break;
                                                            }
                                                            case 'W': {
                                                                s2 = 17;
                                                                break;
                                                            }
                                                            case 'Y': {
                                                                s2 = 18;
                                                                break;
                                                            }
                                                            case 'V': {
                                                                s2 = 19;
                                                            }
                                                        }
                                                        alignmentMeter.get(i).get(j).decrement(c, c2);
                                                        alignmentGamma.get(i).get(j).set(s1, s2, alignmentStuartValue.get(i).get(j) * (alignmentStuartValue.get(i).get(j) - alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                                        alignmentMeter.get(i).get(j).increment(c, c2);
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                    }
                                }
                                sigmaArray = new ArrayList(alignment.length());
                                sigmaArray2 = new ArrayList(alignment.length());
                                b = -1;
                                while (++b < alignment.length()) {
                                    sigmaArray.add(new Double(0.0));
                                    if (!keepCol.get(b) || !(entropy.get(b) > 0.0)) continue;
                                    sigma = 0.0;
                                    i = -1;
                                    while (++i < alignment.size()) {
                                        if (!keepRow.get(i) || (c1 = alignment.charAt(i, b)) == '?' || c1 == '-') continue;
                                        j = -1;
                                        while (++j < i) {
                                            if (!keepRow.get(j) || (c2 = alignment.charAt(j, b)) == '?' || c2 == '-' || c2 == c1) continue;
                                            sigma += alignmentGamma.get(i).get(j).get(c1, c2);
                                        }
                                    }
                                    sigmaArray.set(b, new Double(sigma));
                                    sigmaArray2.add(new Double(sigma));
                                }
                                Collections.sort(sigmaArray2);
                                cpt1 = keepCol.cardinality() / 1000;
                                cpt2 = 0;
                                b = sigmaArray2.size();
                                while (--b >= 0) {
                                    sigmaMax = sigmaArray2.get(b);
                                    j = -1;
                                    while (++j < alignment.length()) {
                                        if (keepCol.get(j) && entropy.get(j) > 0.0 && sigmaArray.get(j) == sigmaMax) {
                                            keepCol.set(j, false);
                                            i = -1;
                                            while (++i < alignment.size()) {
                                                alignment_.setCharAt(i, j, '-');
                                            }
                                            ++cpt2;
                                        }
                                        if (cpt1 != cpt2) continue;
                                    }
                                    if (cpt1 != cpt2) continue;
                                }
                                ok = true;
                                d = 0.0;
                                i = -1;
                                while (++i < alignment.size()) {
                                    if (!keepRow.get(i)) continue;
                                    j = -1;
                                    while (++j < i) {
                                        if (!keepRow.get(j)) continue;
                                        switch (characterState) {
                                            case 0: {
                                                alignmentMeter.get(i).set(j, new AminoAcidMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                                break;
                                            }
                                            case 1: {
                                                alignmentMeter.get(i).set(j, new NucleotideMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                                break;
                                            }
                                            case 2: {
                                                alignmentMeter.get(i).set(j, new CodonMeter(alignment_.getSequence(i), alignment_.getSequence(j)));
                                            }
                                        }
                                        alignmentStuartValue.get(i).set(j, new Double(alignmentMeter.get(i).get(j).getStuartMarginalSymmetryTestValue()));
                                        if (alignmentStuartValue.get(i).get(j) > stuartMax) {
                                            ok = false;
                                            continue;
                                        }
                                        d += 1.0;
                                    }
                                }
                                up = Math.min(d, up);
                            }
                            break;
                        }
                    }
                }
            }
            ok = true;
            i = -1;
            while (++i < keepRow.size()) {
                if (!keepRow.get(i) || !(alignment_.getRowGapRate(i) >= rowGapRate)) continue;
                keepRow.set(i, false);
                ok = false;
            }
        } while (!ok);
        System.out.print("\r" + BLANK.substring(0, 100) + "\r   after :  " + keepRow.cardinality() + " sequences / " + keepCol.cardinality() + " characters");
        alignmentCleaned = new Alignment();
        alignmentComplement = new Alignment();
        switch (characterState) {
            case 0: {
                alignmentCleaned = alignment.toAminoAcidAlignment();
                alignmentComplement = alignment.toAminoAcidAlignment();
                break;
            }
            case 1: {
                alignmentCleaned = alignment.toNucleotideAlignment();
                alignmentComplement = alignment.toNucleotideAlignment();
                break;
            }
            case 2: {
                alignmentCleaned = alignment.toCodonAlignment();
                alignmentComplement = alignment.toCodonAlignment();
            }
        }
        b = 0;
        j = -1;
        while (++j < keepCol.size()) {
            if (!keepCol.get(j)) {
                alignmentCleaned.removeColumn(b);
                continue;
            }
            ++b;
        }
        b = 0;
        i = -1;
        while (++i < keepRow.size()) {
            if (!keepRow.get(i)) {
                alignmentCleaned.removeRow(b);
                continue;
            }
            ++b;
        }
        b = 0;
        j = -1;
        while (++j < keepCol.size()) {
            if (keepCol.get(j)) {
                alignmentComplement.removeColumn(b);
                continue;
            }
            ++b;
        }
        b = 0;
        i = -1;
        while (++i < keepRow.size()) {
            if (!keepRow.get(i)) {
                alignmentComplement.removeRow(b);
                continue;
            }
            ++b;
        }
        System.out.println("\r                                          \r   after :  " + alignmentCleaned.size() + " sequences / " + alignmentCleaned.length() + " characters");
        bb = -1;
        while (++bb < outputOption.size()) {
            line = outputOption.get(bb).toLowerCase();
            alignment_ = new Alignment();
            if (line.startsWith("-o")) {
                switch (characterState) {
                    case 0: {
                        alignment_ = alignmentCleaned.toAminoAcidAlignment();
                        break;
                    }
                    case 1: {
                        alignment_ = alignmentCleaned.toNucleotideAlignment();
                        break;
                    }
                    case 2: {
                        alignment_ = alignmentCleaned.toCodonAlignment();
                    }
                }
            }
            if (line.startsWith("-c")) {
                switch (characterState) {
                    case 0: {
                        alignment_ = alignmentComplement.toAminoAcidAlignment();
                        break;
                    }
                    case 1: {
                        alignment_ = alignmentComplement.toNucleotideAlignment();
                        break;
                    }
                    case 2: {
                        alignment_ = alignmentComplement.toCodonAlignment();
                    }
                }
            }
            outputFormat = (byte)6;
            if (line.indexOf("p") != -1) {
                outputFormat = 0;
            }
            if (line.indexOf("pp") != -1) {
                outputFormat = (byte)4;
            }
            if (line.indexOf("ppp") != -1) {
                outputFormat = (byte)6;
            }
            if (line.indexOf("f") != -1) {
                outputFormat = 1;
            }
            if (line.indexOf("n") != -1) {
                outputFormat = (byte)2;
            }
            if (line.indexOf("nn") != -1) {
                outputFormat = (byte)5;
            }
            if (line.indexOf("nnn") != -1) {
                outputFormat = (byte)7;
            }
            if (line.indexOf("h") != -1) {
                outputFormat = (byte)3;
            }
            codonCode = 0;
            if (line.indexOf("1") != -1) {
                ++codonCode;
            }
            if (line.indexOf("2") != -1) {
                codonCode += 2;
            }
            if (line.indexOf("3") != -1) {
                codonCode += 4;
            }
            if (codonCode == 0) {
                codonCode = 7;
            }
            outputType = characterState;
            if (line.indexOf("aa") != -1) {
                outputType = 0;
                if (characterState == 1) {
                    System.out.println("   impossible to convert into amino acid sequence alignment");
                    System.exit(0);
                }
                if (characterState != 0) {
                    alignment_ = alignment_.toAminoAcidAlignment();
                }
            } else if (line.indexOf("co") != -1) {
                if (characterState == 1) {
                    System.out.println("   impossible to convert into codon sequence alignment");
                    System.exit(0);
                }
                if (codonCode == 7) {
                    outputType = (byte)2;
                    if (characterState != 2) {
                        alignment_ = alignment_.toCodonAlignment();
                    }
                } else {
                    if (characterState != 2) {
                        alignment_ = alignment_.toCodonAlignment();
                    }
                    outputType = 1;
                    alignment_ = alignment_.toNucleotideAlignment(codonCode);
                }
            } else if (line.indexOf("dna") != -1) {
                outputType = 1;
                if (codonCode == 7) {
                    alignment_ = alignment_.toNucleotideAlignment();
                } else {
                    if (characterState == 1) {
                        System.out.println("   impossible to convert into codon sequence alignment");
                        System.exit(0);
                    }
                    if (characterState != 2) {
                        alignment_ = alignment_.toCodonAlignment();
                    }
                    alignment_ = alignment_.toNucleotideAlignment(codonCode);
                }
            } else if (line.indexOf("ry") != -1) {
                outputType = 1;
                if (codonCode == 7) {
                    alignment_ = alignment_.toRYcodingAlignment();
                } else {
                    if (characterState == 1) {
                        System.out.println("   impossible to convert into codon sequence alignment");
                        System.exit(0);
                    }
                    if (characterState != 2) {
                        alignment_ = alignment_.toCodonAlignment();
                    }
                    alignment_ = alignment_.toNucleotideAlignment(codonCode);
                    alignment_ = alignment_.toRYcodingAlignment();
                }
            }
            rwLabel = new ArrayList(0);
            if (outputFormat == 0 || outputFormat == 2) {
                rwLabel = new ArrayList(alignment_.size());
                i = -1;
                while (++i < alignment_.size()) {
                    rwLabel.add(BMGE.noBlank(alignment_.getLabel(i).trim()));
                }
            }
            if (outputFormat == 4 || outputFormat == 5) {
                rwLabel = new ArrayList(alignment_.size());
                i = -1;
                while (++i < alignment_.size()) {
                    rwLabel.add("");
                    line = alignment_.getLabel(i).trim();
                    if (line.endsWith("]")) {
                        b = line.lastIndexOf("[");
                        c = line.lastIndexOf("]");
                        if (b != -1 && b < c) {
                            rwLabel.set(i, BMGE.noBlank(line.substring(b + 1, c)));
                            continue;
                        }
                        rwLabel.set(i, BMGE.noBlank(line));
                        continue;
                    }
                    rwLabel.set(i, BMGE.noBlank(line));
                }
            }
            if (outputFormat == 6 || outputFormat == 7) {
                rwLabel = new ArrayList(alignment_.size());
                i = -1;
                while (++i < alignment_.size()) {
                    rwLabel.add("");
                    line = alignment_.getLabel(i).trim();
                    if (line.endsWith("]")) {
                        b = line.lastIndexOf("[");
                        c = line.lastIndexOf("]");
                        if (b != -1 && b < c) {
                            rwLabel.set(i, BMGE.noBlank(line.substring(b + 1, c)));
                            c = line.lastIndexOf("|");
                            if (c != -1) {
                                while (line.charAt(--c) == '|') {
                                }
                                b = ++c;
                                while (--b >= 0 && line.charAt(b) != '|') {
                                }
                                if (b != -1 && b + 1 != c) {
                                    rwLabel.set(i, rwLabel.get(i) + "_____" + BMGE.noBlank(line.substring(b + 1, c)));
                                    continue;
                                }
                                rwLabel.set(i, rwLabel.get(i) + "_____" + BMGE.noBlank(line.substring(0, line.lastIndexOf("[")).trim()));
                                continue;
                            }
                            rwLabel.set(i, rwLabel.get(i) + "_____" + BMGE.noBlank(line.substring(0, line.lastIndexOf("[")).trim()));
                            continue;
                        }
                        rwLabel.set(i, BMGE.noBlank(line.trim()));
                        continue;
                    }
                    rwLabel.set(i, BMGE.noBlank(line.trim()));
                }
            }
            if (rwLabel.size() > 0) {
                i = -1;
                while (++i < rwLabel.size()) {
                    line = rwLabel.get(i);
                    if (i == rwLabel.lastIndexOf(line)) continue;
                    j = i - 1;
                    while (++j < rwLabel.size()) {
                        label = rwLabel.get(j);
                        if (!line.equals(label)) continue;
                        label = alignment_.getLabel(j).trim();
                        b = label.lastIndexOf("[");
                        c = label.lastIndexOf("]");
                        if (b != -1 && c != -1 && b < c && (c = label.lastIndexOf("|")) != -1) {
                            while (label.charAt(--c) == '|') {
                            }
                            b = ++c;
                            while (--b >= 0 && label.charAt(b) != '|') {
                            }
                            if (b != -1 && b + 1 != c) {
                                rwLabel.set(j, rwLabel.get(j) + "_____" + BMGE.noBlank(label.substring(b + 1, c)));
                                continue;
                            }
                            rwLabel.set(j, rwLabel.get(j) + "_____" + BMGE.noBlank(label.substring(0, label.lastIndexOf("[")).trim()));
                            continue;
                        }
                        rwLabel.set(j, rwLabel.get(j) + "_____" + BMGE.noBlank(label.trim()));
                    }
                }
                i = -1;
                while (++i < rwLabel.size()) {
                    line = rwLabel.get(i);
                    if (i == rwLabel.lastIndexOf(line)) continue;
                    b = 0;
                    j = i - 1;
                    while (++j < rwLabel.size()) {
                        if (!line.equals(rwLabel.get(j))) continue;
                        rwLabel.set(j, rwLabel.get(j) + "___" + ++b);
                    }
                }
            }
            outfile = outputFileName.get(bb);
            out = new BufferedWriter(new FileWriter(outfile));
            switch (outputFormat) {
                case 1: {
                    i = -1;
                    while (++i < alignment_.size()) {
                        out.write(">" + alignment_.getLabel(i));
                        out.newLine();
                        b = 0;
                        do {
                            if (characterState != 2) {
                                out.write(alignment_.getSequence(i).substring(b, Math.min(b + lengthDisplay, alignment_.length())));
                            } else {
                                out.write(alignment_.getSequence(i).substring(b, Math.min(b + lengthDisplay, 3 * alignment_.length())));
                            }
                            out.newLine();
                        } while (Math.min(b += lengthDisplay, alignment_.length()) < alignment_.length());
                    }
                    break;
                }
                case 0: 
                case 4: 
                case 6: {
                    maxLabelLength = -1;
                    i = -1;
                    while (++i < rwLabel.size()) {
                        maxLabelLength = maxLabelLength > rwLabel.get(i).length() ? maxLabelLength : rwLabel.get(i).length();
                    }
                    out.write(" " + alignment_.size());
                    if (outputType == 2) {
                        out.write(" " + 3 * alignment_.length());
                    } else {
                        out.write(" " + alignment_.length());
                    }
                    out.newLine();
                    i = -1;
                    while (++i < alignment_.size()) {
                        out.write((rwLabel.get(i) + BLANK).substring(0, maxLabelLength + 1));
                        out.write(alignment_.getSequence(i));
                        out.newLine();
                    }
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    maxLabelLength = -1;
                    i = -1;
                    while (++i < rwLabel.size()) {
                        maxLabelLength = maxLabelLength > rwLabel.get(i).length() ? maxLabelLength : rwLabel.get(i).length();
                    }
                    out.write("#NEXUS");
                    out.newLine();
                    out.newLine();
                    out.write("begin data;");
                    out.newLine();
                    out.write("   dimensions ntax=" + alignment_.size());
                    if (outputType == 2) {
                        out.write(" nchar=" + 3 * alignment_.length() + ";");
                    } else {
                        out.write(" nchar=" + alignment_.length() + ";");
                    }
                    out.newLine();
                    if (outputType == 0) {
                        out.write("   format datatype=PROTEIN;");
                    } else {
                        out.write("   format datatype=NUCLEOTIDE;");
                    }
                    out.newLine();
                    out.write("   matrix");
                    out.newLine();
                    i = -1;
                    while (++i < alignment_.size()) {
                        out.write("     " + (rwLabel.get(i) + BLANK).substring(0, maxLabelLength + 1));
                        out.write(alignment_.getSequence(i));
                        out.newLine();
                    }
                    out.write("   ;");
                    out.newLine();
                    out.write("end;");
                    out.newLine();
                    break;
                }
                case 3: {
                    maxLabelLength = -1;
                    i = -1;
                    while (++i < alignment.size()) {
                        maxLabelLength = maxLabelLength > alignment.getLabel(i).length() ? maxLabelLength : alignment.getLabel(i).length();
                    }
                    maxLabelLength = maxLabelLength > 5 ? maxLabelLength : 5;
                    out.write("<html>");
                    out.newLine();
                    out.write("<body bgcolor=\"#FFFFFF\" text=\"#D3D4D4\">");
                    out.newLine();
                    out.write("<pre>");
                    out.newLine();
                    out.newLine();
                    out.newLine();
                    sequence = new StringBuffer("");
                    while (sequence.length() < alignment.length() + 10) {
                        sequence = sequence.append(BLANK);
                    }
                    line = sequence.substring(0, alignment.length() + 10);
                    out.write(BLANK.substring(0, maxLabelLength + 1));
                    out.write(line);
                    out.newLine();
                    i = 11;
                    while (--i >= 0) {
                        switch (i) {
                            case 10: {
                                out.write(BLANK.substring(0, maxLabelLength - 3) + BMGE.htmlEntry("1.0_", "", "#000000"));
                                break;
                            }
                            case 5: {
                                out.write(BLANK.substring(0, maxLabelLength - 3) + BMGE.htmlEntry("0.5_", "", "#000000"));
                                break;
                            }
                            case 0: {
                                out.write(BLANK.substring(0, maxLabelLength - 3) + BMGE.htmlEntry("0.0_", "", "#000000"));
                                break;
                            }
                            default: {
                                out.write(BLANK.substring(0, maxLabelLength + 1));
                            }
                        }
                        j = -1;
                        while (++j < alignment.length()) {
                            if (smoothedEntropy.get(j) < (double)i / 10.0) {
                                if (gapCol.get(j) <= (double)i / 10.0) {
                                    if (characterState == 2) {
                                        out.write("   ");
                                        continue;
                                    }
                                    out.write(" ");
                                    continue;
                                }
                                if (characterState == 2) {
                                    out.write("===");
                                    continue;
                                }
                                out.write("=");
                                continue;
                            }
                            if (smoothedEntropy.get(j) > ((double)i + 0.5) / 10.0) {
                                if (characterState == 2) {
                                    out.write(BMGE.htmlEntry("<b>:::</b>", "", "#000000"));
                                    continue;
                                }
                                out.write(BMGE.htmlEntry("<b>:</b>", "", "#000000"));
                                continue;
                            }
                            if (characterState == 2) {
                                out.write(BMGE.htmlEntry("<b>...</b>", "", "#000000"));
                                continue;
                            }
                            out.write(BMGE.htmlEntry("<b>.</b>", "", "#000000"));
                        }
                        out.newLine();
                    }
                    out.newLine();
                    sequence = new StringBuffer(line);
                    lgth = alignment.length();
                    if (characterState == 2) {
                        lgth *= 3;
                        sequence = sequence.append(line).append(line);
                    }
                    j = -1;
                    while (++j <= lgth) {
                        if (j % 5 == 0) {
                            if (j % 10 == 0) {
                                sequence.setCharAt(j, '|');
                                continue;
                            }
                            sequence.setCharAt(j, '-');
                            continue;
                        }
                        sequence.setCharAt(j, '=');
                    }
                    sequence = sequence.deleteCharAt(0);
                    out.write(BLANK.substring(0, maxLabelLength + 1));
                    out.write(BMGE.htmlEntry("" + sequence.substring(0, lgth) + "", "#F0F0F0", "#000000"));
                    out.newLine();
                    sequence = new StringBuffer(line);
                    if (characterState == 2) {
                        sequence = sequence.append(line).append(line);
                    }
                    j = 0;
                    while (++j < lgth) {
                        if (j % 10 != 0) continue;
                        label = new Integer(j).toString();
                        int n = j - 1;
                        j = n;
                        --j;
                        sequence = sequence.replace(n, j += label.length(), label);
                    }
                    out.write(BLANK.substring(0, maxLabelLength + 1));
                    out.write(BMGE.htmlEntry(sequence.substring(0, lgth), "#F0F0F0", "#000000"));
                    out.newLine();
                    sequence = new StringBuffer(line);
                    if (characterState == 2) {
                        sequence = sequence.append(line).append(line);
                    }
                    j = -1;
                    while (++j <= lgth) {
                        if (j % 5 == 0) {
                            if (j % 10 == 0) {
                                sequence.setCharAt(j, '|');
                                continue;
                            }
                            sequence.setCharAt(j, '-');
                            continue;
                        }
                        sequence.setCharAt(j, '=');
                    }
                    sequence = sequence.deleteCharAt(0);
                    out.write(BLANK.substring(0, maxLabelLength + 1));
                    out.write(BMGE.htmlEntry(sequence.substring(0, lgth), "#F0F0F0", "#000000"));
                    out.newLine();
                    sequence = null;
                    label = null;
                    line = null;
                    out.newLine();
                    i = -1;
                    while (++i < alignment.size()) {
                        out.write(BMGE.htmlEntry((alignment.getLabel(i) + BLANK).substring(0, maxLabelLength + 1), "", "#000000"));
                        j = -1;
                        while (++j < alignment.length()) {
                            line = characterState == 2 ? alignment.getCodonAt(i, j) : alignment.getCharAt(i, j);
                            if (!keepCol.get(j) || !keepRow.get(i)) {
                                out.write(line);
                                continue;
                            }
                            if (characterState == 2 && alignment.getMajorityCharacter(j).contains(CodonAlignment.toAminoAcidCharacter(line) + "") || characterState != 2 && alignment.getMajorityCharacter(j).contains(line)) {
                                out.write(BMGE.htmlEntry(line, "#000000", "#FFFFFF"));
                                continue;
                            }
                            out.write(BMGE.htmlEntry(line, "", "#000000"));
                        }
                        out.newLine();
                    }
                    out.write("<span style=\"color:#000000\">");
                    out.newLine();
                    if (stationarity != 0) {
                        out.newLine();
                        out.newLine();
                        out.write("Stuart's (1955) test p-values");
                        out.newLine();
                        out.newLine();
                        i = -1;
                        while (++i < alignment.size()) {
                            out.write((alignment.getLabel(i) + BLANK).substring(0, maxLabelLength + 1));
                            j = -1;
                            while (++j < i) {
                                switch (characterState) {
                                    case 0: {
                                        meter = new AminoAcidMeter(alignment.getSequence(i), alignment.getSequence(j));
                                        break;
                                    }
                                    case 1: {
                                        meter = new NucleotideMeter(alignment.getSequence(i), alignment.getSequence(j));
                                        break;
                                    }
                                    case 2: {
                                        meter = new NucleotideMeter(alignment.getSequence(i), alignment.getSequence(j));
                                    }
                                }
                                pValue = meter.getStuartMarginalSymmetryTestPvalue();
                                out.write("  " + String.format(Locale.ENGLISH, "%.6f", new Double(pValue)));
                            }
                            out.newLine();
                        }
                        out.newLine();
                        out.newLine();
                        i = -1;
                        while (++i < alignment.size()) {
                            out.write((alignment.getLabel(i) + BLANK).substring(0, maxLabelLength + 1));
                            j = -1;
                            while (++j < i) {
                                switch (characterState) {
                                    case 0: {
                                        meter = new AminoAcidMeter(alignmentCleaned.getSequence(i), alignmentCleaned.getSequence(j));
                                        break;
                                    }
                                    case 1: {
                                        meter = new NucleotideMeter(alignmentCleaned.getSequence(i), alignmentCleaned.getSequence(j));
                                        break;
                                    }
                                    case 2: {
                                        meter = new CodonMeter(alignmentCleaned.getSequence(i), alignmentCleaned.getSequence(j));
                                    }
                                }
                                pValue = meter.getStuartMarginalSymmetryTestPvalue();
                                out.write("  " + String.format(Locale.ENGLISH, "%.6f", new Double(pValue)));
                            }
                            out.newLine();
                        }
                    }
                    out.newLine();
                    out.newLine();
                    out.write("Characters : " + keepCol.cardinality() + " selected  " + (alignment.length() - keepCol.cardinality()) + " removed");
                    out.newLine();
                    out.write("  selected: ");
                    left = -1;
                    b = -1;
                    while (++b < alignment.length()) {
                        if (keepCol.get(b) && left == -1) {
                            left = b + 1;
                            out.write(" " + left);
                        }
                        if (keepCol.get(b) || left == -1) continue;
                        if (b - 1 > left) {
                            out.write("-" + b);
                        }
                        left = -1;
                    }
                    if (keepCol.get(--b) && left != -1 && b - 1 > left) {
                        out.write("-" + b);
                    }
                    out.newLine();
                    out.write("  removed:  ");
                    left = -1;
                    b = -1;
                    while (++b < alignment.length()) {
                        if (!keepCol.get(b) && left == -1) {
                            left = b + 1;
                            out.write(" " + left);
                        }
                        if (!keepCol.get(b) || left == -1) continue;
                        if (b - 1 > left) {
                            out.write("-" + b);
                        }
                        left = -1;
                    }
                    if (!keepCol.get(--b) && left != -1 && b - 1 > left) {
                        out.write("-" + b);
                    }
                    out.newLine();
                    out.newLine();
                    lgth = (int)Math.rint(Math.log10(alignment.length())) + 1;
                    out.write("ch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ".substring(0, lgth));
                    out.write(" entropy     smooth. entr.     gap rate");
                    out.newLine();
                    j = -1;
                    while (++j < alignment.length()) {
                        b = j + 1;
                        line = (b + BLANK).substring(0, lgth);
                        out.write(line);
                        out.write(" " + String.format(Locale.ENGLISH, "%.6f", entropy.get(j)));
                        out.write("       " + String.format(Locale.ENGLISH, "%.6f", smoothedEntropy.get(j)));
                        out.write("       " + String.format(Locale.ENGLISH, "%.6f", gapCol.get(j)));
                        out.newLine();
                    }
                    out.write("</span>");
                    out.newLine();
                    out.write("</pre>");
                    out.newLine();
                    out.write("</body>");
                    out.newLine();
                    out.write("</html>");
                    out.newLine();
                }
            }
            out.close();
        }
    }

    public static double[] round(double[] dArray) {
        l_ = dArray.length;
        array_ = new double[l_];
        Arrays.fill(array_, 0.0);
        i_ = -1;
        while (++i_ < l_) {
            if (Math.floor(1.0E10 * Math.abs(dArray[i_])) == 0.0) continue;
            BMGE.array_[BMGE.i_] = dArray[i_];
        }
        return array_;
    }

    public static double log(double d, double d2) {
        if (Math.abs(d2) == 0.0) {
            return 0.0;
        }
        return Math.log(d2) / Math.log(d);
    }

    public static String toString(double d, int n) {
        return String.format(Locale.ENGLISH, "%." + n + "f", new Double(d));
    }

    public static String htmlEntry(String string, String string2, String string3) {
        if (!string2.equals("") && !string3.equals("")) {
            return "<span style=\"background-color:" + string2 + ";color:" + string3 + "\">" + string + "</span>";
        }
        if (!string2.equals("")) {
            return "<span style=\"background-color:" + string2 + "\">" + string + "</span>";
        }
        if (!string3.equals("")) {
            return "<span style=\"color:" + string3 + "\">" + string + "</span>";
        }
        return string;
    }

    public static String noBlank(String string) {
        return string.replace(' ', '_').replace('(', '_').replace(')', '_').replace('[', '_').replace(']', '_').replace('{', '_').replace('}', '_').replace('/', '_').replace('\\', '_').replace(',', '_').replace(';', '_').replace(':', '_').replace('=', '_').replace('*', '_').replace('\"', '_').replace('\'', '_').replace('+', '_').replace('-', '_').replace('<', '_').replace('>', '_').replace('|', '_').replace('.', '_');
    }

    public static boolean neq(String string, String string2) {
        return !string.equals(string2);
    }

    public static void displayUserGuide() {
        System.out.println("");
        System.out.println(" BMGE comes with ABSOLUTELY NO WARRANTY.  This is free software, and you are welcome to");
        System.out.println(" redistribute it under certain conditions.  See the file COPYING.txt for details.");
        System.out.println("");
        System.out.println(" BMGE (version 1.0) arguments :");
        System.out.println("   -i <infile> : input file in fasta or phylip sequential format");
        System.out.println("   -t [AA,DNA,CODON] : sequence coding in the input file (Amino Acid-, DNA-, RNA-, or");
        System.out.println("                       CODON-coding sequences, respectively)");
        System.out.println("   -m BLOSUM<n> :   for Amino Acid or CODON sequence alignment; name of the BLOSUM");
        System.out.println("                    matrix used to estimate the entropy-like value for each character");
        System.out.println("                    (n = 30, 35, 40, ..., 60, 62, 65, ..., 90, 95; default: BLOSUM62)");
        System.out.println("   -m DNAPAM<n:r> : for DNA or RNA sequence alignment; name of the PAM matrix (n ranges");
        System.out.println("                    from 1 to 10,000) and transition/transvertion ratio r value (r ranges");
        System.out.println("                    from 0 to 10,000) used to estimate the entropy-like value for each");
        System.out.println("                    character (default: DNAPAM100:2)");
        System.out.println("   -m DNAPAM<n> :   same as previous option but with r = 1");
        System.out.println("   -m [ID,PAM0] :   for all sequence coding; identity matrix used to estimate entropy-");
        System.out.println("                    like values for each characters");
        System.out.println("   -g <rate_max> :          real number corresponding to the maximum gap rate allowed");
        System.out.println("                            per character (ranges from 0 to 1; default: 0.2)");
        System.out.println("   -g <col_rate:row_rate> : real numbers corresponding to the maximum gap rates allowed");
        System.out.println("                            per sequence and character, respectively (range from 0 to 1;");
        System.out.println("                            default: 0:0.2)");
        System.out.println("   -h <thr_max> :         real number corresponding to the maximum entropy threshold");
        System.out.println("                          (ranges from 0 to 1; default: 0.5)");
        System.out.println("   -h <thr_min:thr_max> : real numbers corresponding to the minimum and maximum entropy");
        System.out.println("                          threshold, respectively (range from 0 to 1; default: 0:0.5)");
        System.out.println("   -b <min_size> : integer number corresponding to the minimum length of selected");
        System.out.println("                   region(s) (ranges from 1 to alignment length; default: 5)");
        System.out.println("   -w <size> : sliding window size (must be odd; ranges from 1 to alignment length; if");
        System.out.println("               set to 1, then entropy-like values are not smoothed; default: 3)");
        System.out.println("   -s [NO,YES] : if set to YES, performs a stationarity-based trimming of the multiple");
        System.out.println("                 sequence alignement (default: NO)");
        System.out.println("   -o<x> <outfile> : output file in phylip sequential (-o, -op, -opp, -oppp), fasta (-of),");
        System.out.println("                     nexus (-on, -onn, -onnn) or html (-oh) format; for phylip and nexus");
        System.out.println("                     format, options -opp and -onn allow NCBI-formatted sequence names to");
        System.out.println("                     be renamed onto their taxon name only; options -oppp and -onnn allow");
        System.out.println("                     renaming onto 'taxon name'_____'accession number' (default: -oppp)");
        System.out.println("   -c<x> <outfile> : same as previous option but for the complementary alignment, except ");
        System.out.println("                     for html output (i.e. -ch do not exist)");
        System.out.println("   -o<y> <outfile> : converts the trimmed alignment in Amino Acid- (-oaa), DNA- (-odna),");
        System.out.println("                     codon- (-oco) or RY- (-ory) coding sequences (can be combined with ");
        System.out.println("                     -o<x> options; default: no conversion)");
        System.out.println("                     (see documentation for more details and more output options)");
        System.out.println("");
    }
}

