/*
  BMGE (Block Mapping and Gathering with Entropy): selection of phylogenetic informative regions from multiple sequence alignments
  Copyright (C) 2010  Alexis Criscuolo 

  This file is part of BMGE.

  BMGE is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  BMGE is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Contact: 
  Unité de Biologie Moléculaire du Gène chez les Extrêmophiles
  Département de Microbiologie
  INSTITUT  PASTEUR
  25 rue du Dr Roux - 75015 Paris  (France)

  alexis.criscuolo@pasteur.fr
*/

package jap;
import Jama.*;

public class Model {
    //http://blocks.fhcrc.org/blocks/uploads/blosum/
    private static final double[][] BL30 = {{0.0096,0.0038,0.0031,0.0043,0.0014,0.0031,0.0044,0.0052,0.0016,0.0040,0.0056,0.0044,0.0018,0.0027,0.0028,0.0056,0.0040,0.0005,0.0014,0.0056},{0.0038,0.0109,0.0019,0.0026,0.0011,0.0031,0.0031,0.0032,0.0014,0.0022,0.0039,0.0043,0.0012,0.0023,0.0021,0.0035,0.0019,0.0007,0.0022,0.0031},{0.0031,0.0019,0.0055,0.0027,0.0010,0.0014,0.0024,0.0032,0.0011,0.0024,0.0032,0.0027,0.0009,0.0017,0.0012,0.0028,0.0024,0.0002,0.0008,0.0022},{0.0043,0.0026,0.0027,0.0095,0.0010,0.0018,0.0037,0.0035,0.0011,0.0018,0.0043,0.0032,0.0008,0.0011,0.0021,0.0034,0.0024,0.0004,0.0015,0.0027},{0.0014,0.0011,0.0010,0.0010,0.0070,0.0007,0.0018,0.0011,0.0004,0.0012,0.0023,0.0010,0.0004,0.0008,0.0007,0.0013,0.0009,0.0003,0.0004,0.0012},{0.0031,0.0031,0.0014,0.0018,0.0007,0.0039,0.0028,0.0020,0.0010,0.0016,0.0027,0.0021,0.0007,0.0010,0.0015,0.0021,0.0016,0.0004,0.0011,0.0015},{0.0044,0.0031,0.0024,0.0037,0.0018,0.0028,0.0094,0.0035,0.0018,0.0023,0.0051,0.0053,0.0012,0.0016,0.0030,0.0038,0.0023,0.0007,0.0016,0.0026},{0.0052,0.0032,0.0032,0.0035,0.0011,0.0020,0.0035,0.0173,0.0015,0.0036,0.0051,0.0039,0.0013,0.0022,0.0030,0.0051,0.0028,0.0011,0.0016,0.0033},{0.0016,0.0014,0.0011,0.0011,0.0004,0.0010,0.0018,0.0015,0.0060,0.0012,0.0022,0.0013,0.0008,0.0008,0.0014,0.0017,0.0010,0.0002,0.0010,0.0012},{0.0040,0.0022,0.0024,0.0018,0.0012,0.0016,0.0023,0.0036,0.0012,0.0072,0.0066,0.0026,0.0014,0.0027,0.0017,0.0033,0.0027,0.0005,0.0018,0.0063},{0.0056,0.0039,0.0032,0.0043,0.0023,0.0027,0.0051,0.0051,0.0022,0.0066,0.0139,0.0044,0.0027,0.0055,0.0027,0.0047,0.0046,0.0009,0.0045,0.0074},{0.0044,0.0043,0.0027,0.0032,0.0010,0.0021,0.0053,0.0039,0.0013,0.0026,0.0044,0.0063,0.0017,0.0023,0.0029,0.0042,0.0025,0.0006,0.0017,0.0030},{0.0018,0.0012,0.0009,0.0008,0.0004,0.0007,0.0012,0.0013,0.0008,0.0014,0.0027,0.0017,0.0012,0.0008,0.0005,0.0010,0.0010,0.0002,0.0007,0.0015},{0.0027,0.0023,0.0017,0.0011,0.0008,0.0010,0.0016,0.0022,0.0008,0.0027,0.0055,0.0023,0.0008,0.0077,0.0011,0.0027,0.0016,0.0007,0.0024,0.0032},{0.0028,0.0021,0.0012,0.0021,0.0007,0.0015,0.0030,0.0030,0.0014,0.0017,0.0027,0.0029,0.0005,0.0011,0.0091,0.0024,0.0020,0.0004,0.0011,0.0017},{0.0056,0.0035,0.0028,0.0034,0.0013,0.0021,0.0038,0.0051,0.0017,0.0033,0.0047,0.0042,0.0010,0.0027,0.0024,0.0075,0.0041,0.0005,0.0017,0.0036},{0.0040,0.0019,0.0024,0.0024,0.0009,0.0016,0.0023,0.0028,0.0010,0.0027,0.0046,0.0025,0.0010,0.0016,0.0020,0.0041,0.0046,0.0003,0.0014,0.0036},{0.0005,0.0007,0.0002,0.0004,0.0003,0.0004,0.0007,0.0011,0.0002,0.0005,0.0009,0.0006,0.0002,0.0007,0.0004,0.0005,0.0003,0.0027,0.0009,0.0005},{0.0014,0.0022,0.0008,0.0015,0.0004,0.0011,0.0016,0.0016,0.0010,0.0018,0.0045,0.0017,0.0007,0.0024,0.0011,0.0017,0.0014,0.0009,0.0044,0.0024},{0.0056,0.0031,0.0022,0.0027,0.0012,0.0015,0.0026,0.0033,0.0012,0.0063,0.0074,0.0030,0.0015,0.0032,0.0017,0.0036,0.0036,0.0005,0.0024,0.0083}};
    private static final double[][] BL35 = {{0.0129,0.0033,0.0030,0.0036,0.0017,0.0026,0.0041,0.0065,0.0016,0.0037,0.0050,0.0045,0.0017,0.0024,0.0028,0.0055,0.0040,0.0007,0.0022,0.0051},{0.0033,0.0097,0.0019,0.0023,0.0009,0.0025,0.0026,0.0028,0.0012,0.0018,0.0032,0.0044,0.0011,0.0018,0.0017,0.0028,0.0019,0.0006,0.0017,0.0027},{0.0030,0.0019,0.0061,0.0031,0.0010,0.0017,0.0023,0.0040,0.0014,0.0021,0.0025,0.0027,0.0008,0.0015,0.0015,0.0026,0.0021,0.0003,0.0011,0.0018},{0.0036,0.0023,0.0031,0.0125,0.0009,0.0017,0.0044,0.0033,0.0014,0.0018,0.0032,0.0031,0.0007,0.0014,0.0022,0.0030,0.0021,0.0004,0.0013,0.0023},{0.0017,0.0009,0.0010,0.0009,0.0108,0.0005,0.0015,0.0013,0.0004,0.0009,0.0017,0.0013,0.0003,0.0007,0.0007,0.0011,0.0012,0.0002,0.0004,0.0012},{0.0026,0.0025,0.0017,0.0017,0.0005,0.0041,0.0032,0.0021,0.0009,0.0013,0.0022,0.0023,0.0007,0.0008,0.0016,0.0023,0.0016,0.0003,0.0012,0.0014},{0.0041,0.0026,0.0023,0.0044,0.0015,0.0032,0.0103,0.0032,0.0015,0.0021,0.0042,0.0048,0.0010,0.0017,0.0028,0.0035,0.0026,0.0007,0.0017,0.0028},{0.0065,0.0028,0.0040,0.0033,0.0013,0.0021,0.0032,0.0224,0.0016,0.0027,0.0041,0.0042,0.0014,0.0021,0.0029,0.0056,0.0027,0.0008,0.0021,0.0029},{0.0016,0.0012,0.0014,0.0014,0.0004,0.0009,0.0015,0.0016,0.0065,0.0010,0.0018,0.0012,0.0008,0.0007,0.0011,0.0015,0.0011,0.0002,0.0010,0.0009},{0.0037,0.0018,0.0021,0.0018,0.0009,0.0013,0.0021,0.0027,0.0010,0.0080,0.0072,0.0025,0.0016,0.0028,0.0021,0.0026,0.0025,0.0005,0.0021,0.0068},{0.0050,0.0032,0.0025,0.0032,0.0017,0.0022,0.0042,0.0041,0.0018,0.0072,0.0176,0.0038,0.0031,0.0051,0.0025,0.0039,0.0041,0.0010,0.0034,0.0073},{0.0045,0.0044,0.0027,0.0031,0.0013,0.0023,0.0048,0.0042,0.0012,0.0025,0.0038,0.0090,0.0014,0.0022,0.0029,0.0037,0.0031,0.0007,0.0018,0.0029},{0.0017,0.0011,0.0008,0.0007,0.0003,0.0007,0.0010,0.0014,0.0008,0.0016,0.0031,0.0014,0.0014,0.0009,0.0006,0.0011,0.0010,0.0003,0.0009,0.0016},{0.0024,0.0018,0.0015,0.0014,0.0007,0.0008,0.0017,0.0021,0.0007,0.0028,0.0051,0.0022,0.0009,0.0084,0.0010,0.0022,0.0018,0.0006,0.0029,0.0031},{0.0028,0.0017,0.0015,0.0022,0.0007,0.0016,0.0028,0.0029,0.0011,0.0021,0.0025,0.0029,0.0006,0.0010,0.0141,0.0021,0.0024,0.0003,0.0011,0.0020},{0.0055,0.0028,0.0026,0.0030,0.0011,0.0023,0.0035,0.0056,0.0015,0.0026,0.0039,0.0037,0.0011,0.0022,0.0021,0.0081,0.0041,0.0005,0.0017,0.0032},{0.0040,0.0019,0.0021,0.0021,0.0012,0.0016,0.0026,0.0027,0.0011,0.0025,0.0041,0.0031,0.0010,0.0018,0.0024,0.0041,0.0057,0.0005,0.0013,0.0037},{0.0007,0.0006,0.0003,0.0004,0.0002,0.0003,0.0007,0.0008,0.0002,0.0005,0.0010,0.0007,0.0003,0.0006,0.0003,0.0005,0.0005,0.0021,0.0007,0.0005},{0.0022,0.0017,0.0011,0.0013,0.0004,0.0012,0.0017,0.0021,0.0010,0.0021,0.0034,0.0018,0.0009,0.0029,0.0011,0.0017,0.0013,0.0007,0.0051,0.0022},{0.0051,0.0027,0.0018,0.0023,0.0012,0.0014,0.0028,0.0029,0.0009,0.0068,0.0073,0.0029,0.0016,0.0031,0.0020,0.0032,0.0037,0.0005,0.0022,0.0090}};
    private static final double[][] BL40 = {{0.0148,0.0029,0.0029,0.0032,0.0015,0.0026,0.0040,0.0066,0.0014,0.0037,0.0050,0.0041,0.0017,0.0022,0.0027,0.0060,0.0040,0.0007,0.0019,0.0054},{0.0029,0.0109,0.0019,0.0021,0.0007,0.0024,0.0026,0.0023,0.0012,0.0017,0.0030,0.0051,0.0010,0.0016,0.0014,0.0025,0.0019,0.0005,0.0016,0.0023},{0.0029,0.0019,0.0069,0.0031,0.0007,0.0017,0.0023,0.0035,0.0013,0.0017,0.0021,0.0027,0.0007,0.0013,0.0014,0.0030,0.0022,0.0003,0.0010,0.0017},{0.0032,0.0021,0.0031,0.0126,0.0009,0.0016,0.0048,0.0031,0.0014,0.0016,0.0027,0.0030,0.0007,0.0013,0.0019,0.0030,0.0024,0.0003,0.0011,0.0022},{0.0015,0.0007,0.0007,0.0009,0.0093,0.0004,0.0010,0.0012,0.0003,0.0008,0.0015,0.0010,0.0003,0.0008,0.0005,0.0013,0.0011,0.0001,0.0004,0.0012},{0.0026,0.0024,0.0017,0.0016,0.0004,0.0048,0.0032,0.0020,0.0010,0.0012,0.0023,0.0026,0.0007,0.0008,0.0013,0.0026,0.0015,0.0004,0.0010,0.0014},{0.0040,0.0026,0.0023,0.0048,0.0010,0.0032,0.0118,0.0028,0.0015,0.0018,0.0036,0.0045,0.0010,0.0015,0.0026,0.0034,0.0025,0.0005,0.0014,0.0025},{0.0066,0.0023,0.0035,0.0031,0.0012,0.0020,0.0028,0.0260,0.0014,0.0024,0.0034,0.0035,0.0013,0.0021,0.0028,0.0052,0.0029,0.0008,0.0017,0.0028},{0.0014,0.0012,0.0013,0.0014,0.0003,0.0010,0.0015,0.0014,0.0060,0.0009,0.0017,0.0013,0.0007,0.0009,0.0008,0.0013,0.0009,0.0002,0.0012,0.0008},{0.0037,0.0017,0.0017,0.0016,0.0008,0.0012,0.0018,0.0024,0.0009,0.0105,0.0082,0.0023,0.0018,0.0031,0.0020,0.0025,0.0028,0.0005,0.0020,0.0083},{0.0050,0.0030,0.0021,0.0027,0.0015,0.0023,0.0036,0.0034,0.0017,0.0082,0.0209,0.0037,0.0037,0.0055,0.0021,0.0034,0.0039,0.0009,0.0031,0.0082},{0.0041,0.0051,0.0027,0.0030,0.0010,0.0026,0.0045,0.0035,0.0013,0.0023,0.0037,0.0099,0.0012,0.0018,0.0023,0.0034,0.0029,0.0005,0.0017,0.0027},{0.0017,0.0010,0.0007,0.0007,0.0003,0.0007,0.0010,0.0013,0.0007,0.0018,0.0037,0.0012,0.0018,0.0011,0.0007,0.0011,0.0011,0.0002,0.0010,0.0018},{0.0022,0.0016,0.0013,0.0013,0.0008,0.0008,0.0015,0.0021,0.0009,0.0031,0.0055,0.0018,0.0011,0.0105,0.0010,0.0019,0.0019,0.0008,0.0032,0.0031},{0.0027,0.0014,0.0014,0.0019,0.0005,0.0013,0.0026,0.0028,0.0008,0.0020,0.0021,0.0023,0.0007,0.0010,0.0151,0.0022,0.0022,0.0003,0.0009,0.0018},{0.0060,0.0025,0.0030,0.0030,0.0013,0.0026,0.0034,0.0052,0.0013,0.0025,0.0034,0.0034,0.0011,0.0019,0.0022,0.0089,0.0043,0.0004,0.0015,0.0032},{0.0040,0.0019,0.0022,0.0024,0.0011,0.0015,0.0025,0.0029,0.0009,0.0028,0.0039,0.0029,0.0011,0.0019,0.0022,0.0043,0.0070,0.0003,0.0014,0.0040},{0.0007,0.0005,0.0003,0.0003,0.0001,0.0004,0.0005,0.0008,0.0002,0.0005,0.0009,0.0005,0.0002,0.0008,0.0003,0.0004,0.0003,0.0045,0.0008,0.0005},{0.0019,0.0016,0.0010,0.0011,0.0004,0.0010,0.0014,0.0017,0.0012,0.0020,0.0031,0.0017,0.0010,0.0032,0.0009,0.0015,0.0014,0.0008,0.0060,0.0020},{0.0054,0.0023,0.0017,0.0022,0.0012,0.0014,0.0025,0.0028,0.0008,0.0083,0.0082,0.0027,0.0018,0.0031,0.0018,0.0032,0.0040,0.0005,0.0020,0.0113}};
    private static final double[][] BL45 = {{0.0181,0.0029,0.0026,0.0027,0.0015,0.0024,0.0038,0.0063,0.0013,0.0036,0.0052,0.0037,0.0016,0.0021,0.0024,0.0062,0.0041,0.0006,0.0017,0.0055},{0.0029,0.0130,0.0020,0.0020,0.0006,0.0025,0.0031,0.0022,0.0013,0.0016,0.0029,0.0061,0.0010,0.0014,0.0013,0.0026,0.0020,0.0004,0.0014,0.0021},{0.0026,0.0020,0.0079,0.0031,0.0007,0.0016,0.0022,0.0033,0.0013,0.0015,0.0019,0.0028,0.0007,0.0011,0.0011,0.0031,0.0025,0.0002,0.0009,0.0016},{0.0027,0.0020,0.0031,0.0132,0.0006,0.0017,0.0047,0.0028,0.0012,0.0014,0.0022,0.0028,0.0006,0.0010,0.0015,0.0028,0.0023,0.0002,0.0011,0.0017},{0.0015,0.0006,0.0007,0.0006,0.0094,0.0004,0.0007,0.0010,0.0003,0.0008,0.0015,0.0008,0.0004,0.0007,0.0004,0.0011,0.0010,0.0001,0.0004,0.0012},{0.0024,0.0025,0.0016,0.0017,0.0004,0.0057,0.0032,0.0019,0.0010,0.0013,0.0022,0.0029,0.0008,0.0007,0.0011,0.0024,0.0015,0.0003,0.0010,0.0014},{0.0038,0.0031,0.0022,0.0047,0.0007,0.0032,0.0131,0.0025,0.0014,0.0017,0.0031,0.0045,0.0009,0.0013,0.0023,0.0032,0.0025,0.0004,0.0012,0.0023},{0.0063,0.0022,0.0033,0.0028,0.0010,0.0019,0.0025,0.0285,0.0012,0.0019,0.0032,0.0030,0.0011,0.0017,0.0022,0.0049,0.0027,0.0006,0.0014,0.0025},{0.0013,0.0013,0.0013,0.0012,0.0003,0.0010,0.0014,0.0012,0.0058,0.0007,0.0016,0.0013,0.0006,0.0008,0.0007,0.0013,0.0009,0.0001,0.0012,0.0008},{0.0036,0.0016,0.0015,0.0014,0.0008,0.0013,0.0017,0.0019,0.0007,0.0124,0.0093,0.0020,0.0023,0.0031,0.0016,0.0023,0.0028,0.0005,0.0019,0.0094},{0.0052,0.0029,0.0019,0.0022,0.0015,0.0022,0.0031,0.0032,0.0016,0.0093,0.0263,0.0031,0.0041,0.0057,0.0019,0.0032,0.0038,0.0008,0.0031,0.0088},{0.0037,0.0061,0.0028,0.0028,0.0008,0.0029,0.0045,0.0030,0.0013,0.0020,0.0031,0.0120,0.0011,0.0015,0.0020,0.0033,0.0028,0.0005,0.0015,0.0025},{0.0016,0.0010,0.0007,0.0006,0.0004,0.0008,0.0009,0.0011,0.0006,0.0023,0.0041,0.0011,0.0026,0.0012,0.0007,0.0010,0.0011,0.0002,0.0009,0.0022},{0.0021,0.0014,0.0011,0.0010,0.0007,0.0007,0.0013,0.0017,0.0008,0.0031,0.0057,0.0015,0.0012,0.0124,0.0009,0.0017,0.0017,0.0008,0.0034,0.0031},{0.0024,0.0013,0.0011,0.0015,0.0004,0.0011,0.0023,0.0022,0.0007,0.0016,0.0019,0.0020,0.0007,0.0009,0.0160,0.0020,0.0019,0.0003,0.0007,0.0016},{0.0062,0.0026,0.0031,0.0028,0.0011,0.0024,0.0032,0.0049,0.0013,0.0023,0.0032,0.0033,0.0010,0.0017,0.0020,0.0104,0.0047,0.0004,0.0015,0.0031},{0.0041,0.0020,0.0025,0.0023,0.0010,0.0015,0.0025,0.0027,0.0009,0.0028,0.0038,0.0028,0.0011,0.0017,0.0019,0.0047,0.0086,0.0003,0.0013,0.0038},{0.0006,0.0004,0.0002,0.0002,0.0001,0.0003,0.0004,0.0006,0.0001,0.0005,0.0008,0.0005,0.0002,0.0008,0.0003,0.0004,0.0003,0.0053,0.0008,0.0004},{0.0017,0.0014,0.0009,0.0011,0.0004,0.0010,0.0012,0.0014,0.0012,0.0019,0.0031,0.0015,0.0009,0.0034,0.0007,0.0015,0.0013,0.0008,0.0066,0.0019},{0.0055,0.0021,0.0016,0.0017,0.0012,0.0014,0.0023,0.0025,0.0008,0.0094,0.0088,0.0025,0.0022,0.0031,0.0016,0.0031,0.0038,0.0004,0.0019,0.0141}};
    private static final double[][] BL50 = {{0.0192,0.0027,0.0024,0.0026,0.0015,0.0022,0.0034,0.0062,0.0012,0.0035,0.0048,0.0033,0.0016,0.0020,0.0022,0.0062,0.0039,0.0005,0.0015,0.0054},{0.0027,0.0152,0.0020,0.0019,0.0005,0.0025,0.0029,0.0020,0.0013,0.0015,0.0028,0.0064,0.0009,0.0012,0.0011,0.0025,0.0021,0.0004,0.0013,0.0020},{0.0024,0.0020,0.0101,0.0035,0.0006,0.0016,0.0023,0.0031,0.0015,0.0013,0.0017,0.0027,0.0007,0.0009,0.0011,0.0032,0.0026,0.0002,0.0009,0.0015},{0.0026,0.0019,0.0035,0.0161,0.0005,0.0017,0.0048,0.0028,0.0011,0.0012,0.0018,0.0026,0.0005,0.0008,0.0015,0.0028,0.0022,0.0002,0.0009,0.0016},{0.0015,0.0005,0.0006,0.0005,0.0091,0.0004,0.0006,0.0009,0.0003,0.0008,0.0014,0.0006,0.0004,0.0006,0.0004,0.0011,0.0010,0.0001,0.0004,0.0013},{0.0022,0.0025,0.0016,0.0017,0.0004,0.0057,0.0033,0.0017,0.0010,0.0011,0.0019,0.0029,0.0008,0.0007,0.0011,0.0022,0.0015,0.0003,0.0009,0.0014},{0.0034,0.0029,0.0023,0.0048,0.0006,0.0033,0.0141,0.0023,0.0013,0.0015,0.0026,0.0043,0.0008,0.0012,0.0019,0.0030,0.0024,0.0004,0.0012,0.0020},{0.0062,0.0020,0.0031,0.0028,0.0009,0.0017,0.0023,0.0316,0.0011,0.0018,0.0027,0.0028,0.0009,0.0015,0.0019,0.0044,0.0025,0.0005,0.0012,0.0022},{0.0012,0.0013,0.0015,0.0011,0.0003,0.0010,0.0013,0.0011,0.0064,0.0007,0.0013,0.0014,0.0005,0.0009,0.0006,0.0012,0.0009,0.0002,0.0013,0.0007},{0.0035,0.0015,0.0013,0.0012,0.0008,0.0011,0.0015,0.0018,0.0007,0.0140,0.0104,0.0017,0.0022,0.0030,0.0013,0.0021,0.0029,0.0005,0.0018,0.0107},{0.0048,0.0028,0.0017,0.0018,0.0014,0.0019,0.0026,0.0027,0.0013,0.0104,0.0304,0.0027,0.0042,0.0058,0.0017,0.0029,0.0038,0.0008,0.0027,0.0092},{0.0033,0.0064,0.0027,0.0026,0.0006,0.0029,0.0043,0.0028,0.0014,0.0017,0.0027,0.0130,0.0010,0.0012,0.0018,0.0031,0.0026,0.0004,0.0013,0.0022},{0.0016,0.0009,0.0007,0.0005,0.0004,0.0008,0.0008,0.0009,0.0005,0.0022,0.0042,0.0010,0.0029,0.0012,0.0005,0.0010,0.0011,0.0003,0.0007,0.0021},{0.0020,0.0012,0.0009,0.0008,0.0006,0.0007,0.0012,0.0015,0.0009,0.0030,0.0058,0.0012,0.0012,0.0154,0.0007,0.0016,0.0015,0.0009,0.0039,0.0030},{0.0022,0.0011,0.0011,0.0015,0.0004,0.0011,0.0019,0.0019,0.0006,0.0013,0.0017,0.0018,0.0005,0.0007,0.0171,0.0018,0.0016,0.0002,0.0006,0.0016},{0.0062,0.0025,0.0032,0.0028,0.0011,0.0022,0.0030,0.0044,0.0012,0.0021,0.0029,0.0031,0.0010,0.0016,0.0018,0.0111,0.0047,0.0003,0.0013,0.0029},{0.0039,0.0021,0.0026,0.0022,0.0010,0.0015,0.0024,0.0025,0.0009,0.0029,0.0038,0.0026,0.0011,0.0015,0.0016,0.0047,0.0100,0.0004,0.0012,0.0041},{0.0005,0.0004,0.0002,0.0002,0.0001,0.0003,0.0004,0.0005,0.0002,0.0005,0.0008,0.0004,0.0003,0.0009,0.0002,0.0003,0.0004,0.0059,0.0008,0.0005},{0.0015,0.0013,0.0009,0.0009,0.0004,0.0009,0.0012,0.0012,0.0013,0.0018,0.0027,0.0013,0.0007,0.0039,0.0006,0.0013,0.0012,0.0008,0.0077,0.0018},{0.0054,0.0020,0.0015,0.0016,0.0013,0.0014,0.0020,0.0022,0.0007,0.0107,0.0092,0.0022,0.0021,0.0030,0.0016,0.0029,0.0041,0.0005,0.0018,0.0164}};
    private static final double[][] BL55 = {{0.0198,0.0025,0.0022,0.0024,0.0016,0.0020,0.0032,0.0059,0.0011,0.0034,0.0045,0.0033,0.0015,0.0019,0.0022,0.0064,0.0040,0.0004,0.0015,0.0054},{0.0025,0.0157,0.0019,0.0018,0.0005,0.0025,0.0028,0.0019,0.0013,0.0014,0.0026,0.0062,0.0008,0.0011,0.0010,0.0024,0.0020,0.0003,0.0011,0.0018},{0.0022,0.0019,0.0116,0.0035,0.0005,0.0015,0.0023,0.0030,0.0014,0.0012,0.0016,0.0025,0.0006,0.0008,0.0010,0.0031,0.0025,0.0002,0.0008,0.0013},{0.0024,0.0018,0.0035,0.0177,0.0005,0.0016,0.0048,0.0026,0.0010,0.0013,0.0017,0.0026,0.0005,0.0007,0.0014,0.0028,0.0021,0.0002,0.0008,0.0016},{0.0016,0.0005,0.0005,0.0005,0.0100,0.0003,0.0005,0.0008,0.0003,0.0010,0.0014,0.0005,0.0004,0.0006,0.0004,0.0011,0.0011,0.0001,0.0004,0.0014},{0.0020,0.0025,0.0015,0.0016,0.0003,0.0064,0.0034,0.0015,0.0011,0.0010,0.0018,0.0030,0.0008,0.0006,0.0010,0.0020,0.0015,0.0003,0.0008,0.0013},{0.0032,0.0028,0.0023,0.0048,0.0005,0.0034,0.0150,0.0021,0.0012,0.0014,0.0023,0.0044,0.0007,0.0010,0.0017,0.0030,0.0023,0.0004,0.0011,0.0019},{0.0059,0.0019,0.0030,0.0026,0.0008,0.0015,0.0021,0.0341,0.0010,0.0017,0.0024,0.0027,0.0008,0.0013,0.0016,0.0042,0.0025,0.0005,0.0010,0.0021},{0.0011,0.0013,0.0014,0.0010,0.0003,0.0011,0.0012,0.0010,0.0074,0.0006,0.0011,0.0013,0.0004,0.0008,0.0006,0.0011,0.0008,0.0002,0.0013,0.0007},{0.0034,0.0014,0.0012,0.0013,0.0010,0.0010,0.0014,0.0017,0.0006,0.0158,0.0105,0.0016,0.0023,0.0031,0.0012,0.0020,0.0029,0.0004,0.0016,0.0115},{0.0045,0.0026,0.0016,0.0017,0.0014,0.0018,0.0023,0.0024,0.0011,0.0105,0.0328,0.0025,0.0045,0.0057,0.0016,0.0027,0.0035,0.0007,0.0026,0.0092},{0.0033,0.0062,0.0025,0.0026,0.0005,0.0030,0.0044,0.0027,0.0013,0.0016,0.0025,0.0142,0.0009,0.0011,0.0018,0.0032,0.0025,0.0003,0.0011,0.0021},{0.0015,0.0008,0.0006,0.0005,0.0004,0.0008,0.0007,0.0008,0.0004,0.0023,0.0045,0.0009,0.0036,0.0013,0.0005,0.0009,0.0011,0.0002,0.0007,0.0022},{0.0019,0.0011,0.0008,0.0007,0.0006,0.0006,0.0010,0.0013,0.0008,0.0031,0.0057,0.0011,0.0013,0.0163,0.0006,0.0014,0.0013,0.0009,0.0040,0.0028},{0.0022,0.0010,0.0010,0.0014,0.0004,0.0010,0.0017,0.0016,0.0006,0.0012,0.0016,0.0018,0.0005,0.0006,0.0184,0.0018,0.0016,0.0002,0.0006,0.0015},{0.0064,0.0024,0.0031,0.0028,0.0011,0.0020,0.0030,0.0042,0.0011,0.0020,0.0027,0.0032,0.0009,0.0014,0.0018,0.0122,0.0049,0.0003,0.0012,0.0027},{0.0040,0.0020,0.0025,0.0021,0.0011,0.0015,0.0023,0.0025,0.0008,0.0029,0.0035,0.0025,0.0011,0.0013,0.0016,0.0049,0.0115,0.0003,0.0011,0.0039},{0.0004,0.0003,0.0002,0.0002,0.0001,0.0003,0.0004,0.0005,0.0002,0.0004,0.0007,0.0003,0.0002,0.0009,0.0002,0.0003,0.0003,0.0063,0.0010,0.0004},{0.0015,0.0011,0.0008,0.0008,0.0004,0.0008,0.0011,0.0010,0.0013,0.0016,0.0026,0.0011,0.0007,0.0040,0.0006,0.0012,0.0011,0.0010,0.0086,0.0017},{0.0054,0.0018,0.0013,0.0016,0.0014,0.0013,0.0019,0.0021,0.0007,0.0115,0.0092,0.0021,0.0022,0.0028,0.0015,0.0027,0.0039,0.0004,0.0017,0.0181}};
    private static final double[][] BL60 = {{0.0210,0.0024,0.0020,0.0022,0.0016,0.0020,0.0030,0.0058,0.0011,0.0033,0.0046,0.0033,0.0014,0.0017,0.0021,0.0063,0.0038,0.0004,0.0014,0.0052},{0.0024,0.0174,0.0019,0.0016,0.0004,0.0025,0.0027,0.0017,0.0013,0.0013,0.0025,0.0063,0.0008,0.0010,0.0010,0.0023,0.0019,0.0003,0.0010,0.0017},{0.0020,0.0019,0.0129,0.0037,0.0005,0.0015,0.0022,0.0028,0.0014,0.0010,0.0014,0.0024,0.0005,0.0008,0.0009,0.0031,0.0023,0.0002,0.0007,0.0012},{0.0022,0.0016,0.0037,0.0197,0.0004,0.0017,0.0050,0.0025,0.0010,0.0013,0.0016,0.0025,0.0005,0.0008,0.0013,0.0028,0.0020,0.0002,0.0006,0.0013},{0.0016,0.0004,0.0005,0.0004,0.0116,0.0003,0.0004,0.0008,0.0002,0.0010,0.0015,0.0005,0.0004,0.0005,0.0004,0.0011,0.0010,0.0002,0.0004,0.0014},{0.0020,0.0025,0.0015,0.0017,0.0003,0.0069,0.0035,0.0013,0.0011,0.0009,0.0017,0.0031,0.0008,0.0006,0.0009,0.0019,0.0014,0.0003,0.0007,0.0012},{0.0030,0.0027,0.0022,0.0050,0.0004,0.0035,0.0161,0.0020,0.0013,0.0013,0.0021,0.0042,0.0007,0.0009,0.0015,0.0030,0.0021,0.0003,0.0009,0.0017},{0.0058,0.0017,0.0028,0.0025,0.0008,0.0013,0.0020,0.0364,0.0010,0.0015,0.0021,0.0025,0.0008,0.0012,0.0014,0.0040,0.0022,0.0004,0.0009,0.0019},{0.0011,0.0013,0.0014,0.0010,0.0002,0.0011,0.0013,0.0010,0.0084,0.0006,0.0010,0.0012,0.0004,0.0008,0.0005,0.0011,0.0008,0.0002,0.0014,0.0006},{0.0033,0.0013,0.0010,0.0013,0.0010,0.0009,0.0013,0.0015,0.0006,0.0173,0.0111,0.0016,0.0025,0.0031,0.0010,0.0018,0.0027,0.0004,0.0015,0.0117},{0.0046,0.0025,0.0014,0.0016,0.0015,0.0017,0.0021,0.0021,0.0010,0.0111,0.0362,0.0025,0.0048,0.0056,0.0015,0.0025,0.0034,0.0008,0.0023,0.0095},{0.0033,0.0063,0.0024,0.0025,0.0005,0.0031,0.0042,0.0025,0.0012,0.0016,0.0025,0.0152,0.0009,0.0010,0.0017,0.0031,0.0024,0.0003,0.0010,0.0020},{0.0014,0.0008,0.0005,0.0005,0.0004,0.0008,0.0007,0.0008,0.0004,0.0025,0.0048,0.0009,0.0040,0.0012,0.0004,0.0009,0.0011,0.0002,0.0006,0.0024},{0.0017,0.0010,0.0008,0.0008,0.0005,0.0006,0.0009,0.0012,0.0008,0.0031,0.0056,0.0010,0.0012,0.0182,0.0006,0.0013,0.0012,0.0009,0.0042,0.0026},{0.0021,0.0010,0.0009,0.0013,0.0004,0.0009,0.0015,0.0014,0.0005,0.0010,0.0015,0.0017,0.0004,0.0006,0.0194,0.0017,0.0014,0.0002,0.0005,0.0013},{0.0063,0.0023,0.0031,0.0028,0.0011,0.0019,0.0030,0.0040,0.0011,0.0018,0.0025,0.0031,0.0009,0.0013,0.0017,0.0127,0.0048,0.0003,0.0011,0.0025},{0.0038,0.0019,0.0023,0.0020,0.0010,0.0014,0.0021,0.0022,0.0008,0.0027,0.0034,0.0024,0.0011,0.0012,0.0014,0.0048,0.0123,0.0003,0.0010,0.0038},{0.0004,0.0003,0.0002,0.0002,0.0002,0.0003,0.0003,0.0004,0.0002,0.0004,0.0008,0.0003,0.0002,0.0009,0.0002,0.0003,0.0003,0.0066,0.0009,0.0004},{0.0014,0.0010,0.0007,0.0006,0.0004,0.0007,0.0009,0.0009,0.0014,0.0015,0.0023,0.0010,0.0006,0.0042,0.0005,0.0011,0.0010,0.0009,0.0099,0.0016},{0.0052,0.0017,0.0012,0.0013,0.0014,0.0012,0.0017,0.0019,0.0006,0.0117,0.0095,0.0020,0.0024,0.0026,0.0013,0.0025,0.0038,0.0004,0.0016,0.0192}};
    private static final double[][] BL62 = {{0.0215,0.0023,0.0019,0.0022,0.0016,0.0019,0.0030,0.0058,0.0011,0.0032,0.0044,0.0033,0.0013,0.0016,0.0022,0.0063,0.0037,0.0004,0.0013,0.0051},{0.0023,0.0178,0.0020,0.0016,0.0004,0.0025,0.0027,0.0017,0.0012,0.0012,0.0024,0.0062,0.0008,0.0009,0.0010,0.0023,0.0018,0.0003,0.0009,0.0016},{0.0019,0.0020,0.0141,0.0037,0.0004,0.0015,0.0022,0.0029,0.0014,0.0010,0.0014,0.0024,0.0005,0.0008,0.0009,0.0031,0.0022,0.0002,0.0007,0.0012},{0.0022,0.0016,0.0037,0.0213,0.0004,0.0016,0.0049,0.0025,0.0010,0.0012,0.0015,0.0024,0.0005,0.0008,0.0012,0.0028,0.0019,0.0002,0.0006,0.0013},{0.0016,0.0004,0.0004,0.0004,0.0119,0.0003,0.0004,0.0008,0.0002,0.0011,0.0016,0.0005,0.0004,0.0005,0.0004,0.0010,0.0009,0.0001,0.0003,0.0014},{0.0019,0.0025,0.0015,0.0016,0.0003,0.0073,0.0035,0.0014,0.0010,0.0009,0.0016,0.0031,0.0007,0.0005,0.0008,0.0019,0.0014,0.0002,0.0007,0.0012},{0.0030,0.0027,0.0022,0.0049,0.0004,0.0035,0.0161,0.0019,0.0014,0.0012,0.0020,0.0041,0.0007,0.0009,0.0014,0.0030,0.0020,0.0003,0.0009,0.0017},{0.0058,0.0017,0.0029,0.0025,0.0008,0.0014,0.0019,0.0378,0.0010,0.0014,0.0021,0.0025,0.0007,0.0012,0.0014,0.0038,0.0022,0.0004,0.0008,0.0018},{0.0011,0.0012,0.0014,0.0010,0.0002,0.0010,0.0014,0.0010,0.0093,0.0006,0.0010,0.0012,0.0004,0.0008,0.0005,0.0011,0.0007,0.0002,0.0015,0.0006},{0.0032,0.0012,0.0010,0.0012,0.0011,0.0009,0.0012,0.0014,0.0006,0.0184,0.0114,0.0016,0.0025,0.0030,0.0010,0.0017,0.0027,0.0004,0.0014,0.0120},{0.0044,0.0024,0.0014,0.0015,0.0016,0.0016,0.0020,0.0021,0.0010,0.0114,0.0371,0.0025,0.0049,0.0054,0.0014,0.0024,0.0033,0.0007,0.0022,0.0095},{0.0033,0.0062,0.0024,0.0024,0.0005,0.0031,0.0041,0.0025,0.0012,0.0016,0.0025,0.0161,0.0009,0.0009,0.0016,0.0031,0.0023,0.0003,0.0010,0.0019},{0.0013,0.0008,0.0005,0.0005,0.0004,0.0007,0.0007,0.0007,0.0004,0.0025,0.0049,0.0009,0.0040,0.0012,0.0004,0.0009,0.0010,0.0002,0.0006,0.0023},{0.0016,0.0009,0.0008,0.0008,0.0005,0.0005,0.0009,0.0012,0.0008,0.0030,0.0054,0.0009,0.0012,0.0183,0.0005,0.0012,0.0012,0.0008,0.0042,0.0026},{0.0022,0.0010,0.0009,0.0012,0.0004,0.0008,0.0014,0.0014,0.0005,0.0010,0.0014,0.0016,0.0004,0.0005,0.0191,0.0017,0.0014,0.0001,0.0005,0.0012},{0.0063,0.0023,0.0031,0.0028,0.0010,0.0019,0.0030,0.0038,0.0011,0.0017,0.0024,0.0031,0.0009,0.0012,0.0017,0.0126,0.0047,0.0003,0.0010,0.0024},{0.0037,0.0018,0.0022,0.0019,0.0009,0.0014,0.0020,0.0022,0.0007,0.0027,0.0033,0.0023,0.0010,0.0012,0.0014,0.0047,0.0125,0.0003,0.0009,0.0036},{0.0004,0.0003,0.0002,0.0002,0.0001,0.0002,0.0003,0.0004,0.0002,0.0004,0.0007,0.0003,0.0002,0.0008,0.0001,0.0003,0.0003,0.0065,0.0009,0.0004},{0.0013,0.0009,0.0007,0.0006,0.0003,0.0007,0.0009,0.0008,0.0015,0.0014,0.0022,0.0010,0.0006,0.0042,0.0005,0.0010,0.0009,0.0009,0.0102,0.0015},{0.0051,0.0016,0.0012,0.0013,0.0014,0.0012,0.0017,0.0018,0.0006,0.0120,0.0095,0.0019,0.0023,0.0026,0.0012,0.0024,0.0036,0.0004,0.0015,0.0196}};
    private static final double[][] BL65 = {{0.0222,0.0022,0.0019,0.0021,0.0016,0.0018,0.0029,0.0057,0.0010,0.0031,0.0043,0.0032,0.0013,0.0016,0.0021,0.0065,0.0037,0.0004,0.0013,0.0049},{0.0022,0.0181,0.0019,0.0015,0.0004,0.0024,0.0025,0.0016,0.0013,0.0012,0.0023,0.0062,0.0007,0.0009,0.0009,0.0022,0.0017,0.0003,0.0009,0.0015},{0.0019,0.0019,0.0148,0.0037,0.0004,0.0015,0.0021,0.0027,0.0014,0.0009,0.0013,0.0024,0.0005,0.0007,0.0008,0.0030,0.0022,0.0002,0.0007,0.0011},{0.0021,0.0015,0.0037,0.0225,0.0004,0.0016,0.0049,0.0024,0.0009,0.0011,0.0014,0.0024,0.0004,0.0007,0.0011,0.0027,0.0019,0.0001,0.0006,0.0012},{0.0016,0.0004,0.0004,0.0004,0.0127,0.0003,0.0003,0.0007,0.0002,0.0012,0.0016,0.0005,0.0004,0.0005,0.0003,0.0011,0.0009,0.0002,0.0004,0.0014},{0.0018,0.0024,0.0015,0.0016,0.0003,0.0076,0.0034,0.0013,0.0010,0.0008,0.0016,0.0030,0.0007,0.0005,0.0008,0.0018,0.0013,0.0002,0.0006,0.0011},{0.0029,0.0025,0.0021,0.0049,0.0003,0.0034,0.0168,0.0018,0.0013,0.0012,0.0019,0.0040,0.0006,0.0008,0.0014,0.0029,0.0021,0.0002,0.0008,0.0016},{0.0057,0.0016,0.0027,0.0024,0.0007,0.0013,0.0018,0.0396,0.0009,0.0013,0.0020,0.0024,0.0007,0.0011,0.0013,0.0037,0.0022,0.0004,0.0008,0.0017},{0.0010,0.0013,0.0014,0.0009,0.0002,0.0010,0.0013,0.0009,0.0096,0.0006,0.0009,0.0012,0.0003,0.0008,0.0005,0.0011,0.0007,0.0002,0.0016,0.0006},{0.0031,0.0012,0.0009,0.0011,0.0012,0.0008,0.0012,0.0013,0.0006,0.0191,0.0115,0.0015,0.0025,0.0030,0.0009,0.0017,0.0027,0.0004,0.0015,0.0120},{0.0043,0.0023,0.0013,0.0014,0.0016,0.0016,0.0019,0.0020,0.0009,0.0115,0.0388,0.0024,0.0052,0.0056,0.0013,0.0024,0.0033,0.0007,0.0023,0.0094},{0.0032,0.0062,0.0024,0.0024,0.0005,0.0030,0.0040,0.0024,0.0012,0.0015,0.0024,0.0166,0.0008,0.0009,0.0015,0.0030,0.0023,0.0003,0.0010,0.0019},{0.0013,0.0007,0.0005,0.0004,0.0004,0.0007,0.0006,0.0007,0.0003,0.0025,0.0052,0.0008,0.0045,0.0012,0.0004,0.0008,0.0010,0.0002,0.0006,0.0023},{0.0016,0.0009,0.0007,0.0007,0.0005,0.0005,0.0008,0.0011,0.0008,0.0030,0.0056,0.0009,0.0012,0.0186,0.0005,0.0012,0.0012,0.0009,0.0043,0.0025},{0.0021,0.0009,0.0008,0.0011,0.0003,0.0008,0.0014,0.0013,0.0005,0.0009,0.0013,0.0015,0.0004,0.0005,0.0195,0.0016,0.0013,0.0001,0.0004,0.0012},{0.0065,0.0022,0.0030,0.0027,0.0011,0.0018,0.0029,0.0037,0.0011,0.0017,0.0024,0.0030,0.0008,0.0012,0.0016,0.0137,0.0048,0.0003,0.0010,0.0023},{0.0037,0.0017,0.0022,0.0019,0.0009,0.0013,0.0021,0.0022,0.0007,0.0027,0.0033,0.0023,0.0010,0.0012,0.0013,0.0048,0.0133,0.0003,0.0009,0.0035},{0.0004,0.0003,0.0002,0.0001,0.0002,0.0002,0.0002,0.0004,0.0002,0.0004,0.0007,0.0003,0.0002,0.0009,0.0001,0.0003,0.0003,0.0074,0.0010,0.0004},{0.0013,0.0009,0.0007,0.0006,0.0004,0.0006,0.0008,0.0008,0.0016,0.0015,0.0023,0.0010,0.0006,0.0043,0.0004,0.0010,0.0009,0.0010,0.0113,0.0015},{0.0049,0.0015,0.0011,0.0012,0.0014,0.0011,0.0016,0.0017,0.0006,0.0120,0.0094,0.0019,0.0023,0.0025,0.0012,0.0023,0.0035,0.0004,0.0015,0.0206}};
    private static final double[][] BL70 = {{0.0236,0.0022,0.0018,0.0020,0.0016,0.0018,0.0028,0.0056,0.0010,0.0029,0.0040,0.0031,0.0012,0.0015,0.0022,0.0064,0.0036,0.0004,0.0012,0.0048},{0.0022,0.0193,0.0018,0.0014,0.0004,0.0025,0.0025,0.0016,0.0012,0.0011,0.0020,0.0062,0.0007,0.0008,0.0009,0.0021,0.0016,0.0002,0.0009,0.0015},{0.0018,0.0018,0.0155,0.0038,0.0004,0.0014,0.0021,0.0027,0.0013,0.0009,0.0012,0.0023,0.0005,0.0006,0.0007,0.0029,0.0021,0.0002,0.0006,0.0011},{0.0020,0.0014,0.0038,0.0238,0.0004,0.0015,0.0049,0.0024,0.0009,0.0010,0.0012,0.0022,0.0004,0.0007,0.0010,0.0026,0.0018,0.0001,0.0005,0.0011},{0.0016,0.0004,0.0004,0.0004,0.0144,0.0003,0.0003,0.0007,0.0002,0.0011,0.0015,0.0004,0.0004,0.0006,0.0003,0.0010,0.0009,0.0002,0.0003,0.0013},{0.0018,0.0025,0.0014,0.0015,0.0003,0.0083,0.0034,0.0012,0.0011,0.0008,0.0015,0.0030,0.0007,0.0005,0.0008,0.0017,0.0013,0.0002,0.0006,0.0011},{0.0028,0.0025,0.0021,0.0049,0.0003,0.0034,0.0183,0.0018,0.0014,0.0011,0.0017,0.0039,0.0006,0.0007,0.0013,0.0028,0.0020,0.0002,0.0007,0.0015},{0.0056,0.0016,0.0027,0.0024,0.0007,0.0012,0.0018,0.0421,0.0008,0.0011,0.0018,0.0023,0.0006,0.0011,0.0012,0.0035,0.0020,0.0004,0.0007,0.0016},{0.0010,0.0012,0.0013,0.0009,0.0002,0.0011,0.0014,0.0008,0.0099,0.0005,0.0009,0.0011,0.0003,0.0008,0.0004,0.0011,0.0007,0.0002,0.0017,0.0006},{0.0029,0.0011,0.0009,0.0010,0.0011,0.0008,0.0011,0.0011,0.0005,0.0202,0.0117,0.0013,0.0025,0.0029,0.0008,0.0016,0.0025,0.0004,0.0014,0.0119},{0.0040,0.0020,0.0012,0.0012,0.0015,0.0015,0.0017,0.0018,0.0009,0.0117,0.0417,0.0023,0.0052,0.0055,0.0013,0.0023,0.0030,0.0007,0.0022,0.0094},{0.0031,0.0062,0.0023,0.0022,0.0004,0.0030,0.0039,0.0023,0.0011,0.0013,0.0023,0.0173,0.0008,0.0008,0.0014,0.0028,0.0022,0.0002,0.0009,0.0017},{0.0012,0.0007,0.0005,0.0004,0.0004,0.0007,0.0006,0.0006,0.0003,0.0025,0.0052,0.0008,0.0046,0.0011,0.0004,0.0008,0.0010,0.0002,0.0005,0.0022},{0.0015,0.0008,0.0006,0.0007,0.0006,0.0005,0.0007,0.0011,0.0008,0.0029,0.0055,0.0008,0.0011,0.0197,0.0005,0.0011,0.0011,0.0009,0.0043,0.0025},{0.0022,0.0009,0.0007,0.0010,0.0003,0.0008,0.0013,0.0012,0.0004,0.0008,0.0013,0.0014,0.0004,0.0005,0.0206,0.0016,0.0012,0.0001,0.0004,0.0011},{0.0064,0.0021,0.0029,0.0026,0.0010,0.0017,0.0028,0.0035,0.0011,0.0016,0.0023,0.0028,0.0008,0.0011,0.0016,0.0142,0.0046,0.0003,0.0010,0.0021},{0.0036,0.0016,0.0021,0.0018,0.0009,0.0013,0.0020,0.0020,0.0007,0.0025,0.0030,0.0022,0.0010,0.0011,0.0012,0.0046,0.0138,0.0002,0.0009,0.0034},{0.0004,0.0002,0.0002,0.0001,0.0002,0.0002,0.0002,0.0004,0.0002,0.0004,0.0007,0.0002,0.0002,0.0009,0.0001,0.0003,0.0002,0.0075,0.0009,0.0004},{0.0012,0.0009,0.0006,0.0005,0.0003,0.0006,0.0007,0.0007,0.0017,0.0014,0.0022,0.0009,0.0005,0.0043,0.0004,0.0010,0.0009,0.0009,0.0124,0.0014},{0.0048,0.0015,0.0011,0.0011,0.0013,0.0011,0.0015,0.0016,0.0006,0.0119,0.0094,0.0017,0.0022,0.0025,0.0011,0.0021,0.0034,0.0004,0.0014,0.0218}};
    private static final double[][] BL75 = {{0.0245,0.0021,0.0017,0.0018,0.0016,0.0017,0.0028,0.0055,0.0010,0.0028,0.0039,0.0030,0.0012,0.0014,0.0022,0.0064,0.0036,0.0003,0.0012,0.0047},{0.0021,0.0204,0.0017,0.0013,0.0004,0.0024,0.0024,0.0015,0.0012,0.0011,0.0019,0.0062,0.0007,0.0007,0.0009,0.0021,0.0016,0.0002,0.0008,0.0014},{0.0017,0.0017,0.0162,0.0036,0.0004,0.0014,0.0020,0.0026,0.0013,0.0008,0.0011,0.0023,0.0004,0.0006,0.0007,0.0028,0.0020,0.0001,0.0006,0.0010},{0.0018,0.0013,0.0036,0.0253,0.0004,0.0014,0.0048,0.0023,0.0008,0.0009,0.0011,0.0021,0.0004,0.0006,0.0010,0.0025,0.0017,0.0001,0.0005,0.0010},{0.0016,0.0004,0.0004,0.0004,0.0152,0.0003,0.0003,0.0006,0.0002,0.0012,0.0015,0.0004,0.0004,0.0006,0.0003,0.0010,0.0009,0.0001,0.0003,0.0014},{0.0017,0.0024,0.0014,0.0014,0.0003,0.0090,0.0034,0.0011,0.0011,0.0007,0.0014,0.0029,0.0007,0.0005,0.0007,0.0017,0.0012,0.0002,0.0006,0.0010},{0.0028,0.0024,0.0020,0.0048,0.0003,0.0034,0.0194,0.0017,0.0013,0.0010,0.0016,0.0037,0.0006,0.0007,0.0012,0.0027,0.0019,0.0002,0.0007,0.0015},{0.0055,0.0015,0.0026,0.0023,0.0006,0.0011,0.0017,0.0436,0.0008,0.0011,0.0017,0.0022,0.0006,0.0010,0.0011,0.0035,0.0020,0.0003,0.0006,0.0015},{0.0010,0.0012,0.0013,0.0008,0.0002,0.0011,0.0013,0.0008,0.0100,0.0005,0.0008,0.0011,0.0003,0.0007,0.0004,0.0010,0.0007,0.0002,0.0016,0.0006},{0.0028,0.0011,0.0008,0.0009,0.0012,0.0007,0.0010,0.0011,0.0005,0.0210,0.0115,0.0012,0.0026,0.0028,0.0008,0.0015,0.0024,0.0004,0.0014,0.0122},{0.0039,0.0019,0.0011,0.0011,0.0015,0.0014,0.0016,0.0017,0.0008,0.0115,0.0433,0.0021,0.0052,0.0055,0.0012,0.0022,0.0029,0.0007,0.0021,0.0093},{0.0030,0.0062,0.0023,0.0021,0.0004,0.0029,0.0037,0.0022,0.0011,0.0012,0.0021,0.0180,0.0008,0.0008,0.0013,0.0026,0.0021,0.0002,0.0009,0.0016},{0.0012,0.0007,0.0004,0.0004,0.0004,0.0007,0.0006,0.0006,0.0003,0.0026,0.0052,0.0008,0.0049,0.0011,0.0004,0.0007,0.0010,0.0002,0.0005,0.0022},{0.0014,0.0007,0.0006,0.0006,0.0006,0.0005,0.0007,0.0010,0.0007,0.0028,0.0055,0.0008,0.0011,0.0206,0.0005,0.0010,0.0011,0.0008,0.0044,0.0024},{0.0022,0.0009,0.0007,0.0010,0.0003,0.0007,0.0012,0.0011,0.0004,0.0008,0.0012,0.0013,0.0004,0.0005,0.0214,0.0015,0.0011,0.0001,0.0004,0.0011},{0.0064,0.0021,0.0028,0.0025,0.0010,0.0017,0.0027,0.0035,0.0010,0.0015,0.0022,0.0026,0.0007,0.0010,0.0015,0.0153,0.0046,0.0002,0.0009,0.0021},{0.0036,0.0016,0.0020,0.0017,0.0009,0.0012,0.0019,0.0020,0.0007,0.0024,0.0029,0.0021,0.0010,0.0011,0.0011,0.0046,0.0143,0.0002,0.0008,0.0033},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0002,0.0003,0.0002,0.0004,0.0007,0.0002,0.0002,0.0008,0.0001,0.0002,0.0002,0.0080,0.0010,0.0004},{0.0012,0.0008,0.0006,0.0005,0.0003,0.0006,0.0007,0.0006,0.0016,0.0014,0.0021,0.0009,0.0005,0.0044,0.0004,0.0009,0.0008,0.0010,0.0136,0.0014},{0.0047,0.0014,0.0010,0.0010,0.0014,0.0010,0.0015,0.0015,0.0006,0.0122,0.0093,0.0016,0.0022,0.0024,0.0011,0.0021,0.0033,0.0004,0.0014,0.0230}};
    private static final double[][] BL80 = {{0.0252,0.0020,0.0016,0.0018,0.0015,0.0017,0.0028,0.0053,0.0009,0.0027,0.0036,0.0029,0.0011,0.0014,0.0021,0.0064,0.0036,0.0003,0.0011,0.0046},{0.0020,0.0210,0.0017,0.0013,0.0003,0.0024,0.0023,0.0015,0.0012,0.0010,0.0018,0.0061,0.0006,0.0007,0.0009,0.0020,0.0015,0.0002,0.0007,0.0013},{0.0016,0.0017,0.0166,0.0037,0.0004,0.0014,0.0019,0.0025,0.0012,0.0007,0.0011,0.0022,0.0004,0.0006,0.0007,0.0029,0.0020,0.0001,0.0006,0.0009},{0.0018,0.0013,0.0037,0.0262,0.0003,0.0014,0.0048,0.0022,0.0008,0.0008,0.0011,0.0020,0.0003,0.0006,0.0009,0.0024,0.0016,0.0001,0.0005,0.0010},{0.0015,0.0003,0.0004,0.0003,0.0172,0.0003,0.0003,0.0006,0.0002,0.0011,0.0014,0.0004,0.0004,0.0005,0.0003,0.0010,0.0009,0.0001,0.0003,0.0013},{0.0017,0.0024,0.0014,0.0014,0.0003,0.0094,0.0035,0.0011,0.0011,0.0007,0.0014,0.0028,0.0007,0.0005,0.0007,0.0017,0.0012,0.0002,0.0005,0.0010},{0.0028,0.0023,0.0019,0.0048,0.0003,0.0035,0.0208,0.0017,0.0012,0.0010,0.0015,0.0036,0.0006,0.0006,0.0012,0.0026,0.0019,0.0002,0.0006,0.0015},{0.0053,0.0015,0.0025,0.0022,0.0006,0.0011,0.0017,0.0463,0.0008,0.0009,0.0016,0.0020,0.0005,0.0009,0.0010,0.0034,0.0019,0.0003,0.0006,0.0014},{0.0009,0.0012,0.0012,0.0008,0.0002,0.0011,0.0012,0.0008,0.0104,0.0004,0.0008,0.0010,0.0003,0.0007,0.0004,0.0010,0.0007,0.0001,0.0016,0.0005},{0.0027,0.0010,0.0007,0.0008,0.0011,0.0007,0.0010,0.0009,0.0004,0.0220,0.0111,0.0012,0.0025,0.0027,0.0007,0.0015,0.0024,0.0003,0.0013,0.0123},{0.0036,0.0018,0.0011,0.0011,0.0014,0.0014,0.0015,0.0016,0.0008,0.0111,0.0442,0.0019,0.0052,0.0052,0.0012,0.0021,0.0028,0.0006,0.0020,0.0089},{0.0029,0.0061,0.0022,0.0020,0.0004,0.0028,0.0036,0.0020,0.0010,0.0012,0.0019,0.0190,0.0007,0.0007,0.0012,0.0026,0.0020,0.0002,0.0008,0.0015},{0.0011,0.0006,0.0004,0.0003,0.0004,0.0007,0.0006,0.0005,0.0003,0.0025,0.0052,0.0007,0.0053,0.0010,0.0003,0.0007,0.0009,0.0002,0.0005,0.0022},{0.0014,0.0007,0.0006,0.0006,0.0005,0.0005,0.0006,0.0009,0.0007,0.0027,0.0052,0.0007,0.0010,0.0211,0.0004,0.0010,0.0011,0.0007,0.0046,0.0022},{0.0021,0.0009,0.0007,0.0009,0.0003,0.0007,0.0012,0.0010,0.0004,0.0007,0.0012,0.0012,0.0003,0.0004,0.0221,0.0014,0.0011,0.0001,0.0003,0.0010},{0.0064,0.0020,0.0029,0.0024,0.0010,0.0017,0.0026,0.0034,0.0010,0.0015,0.0021,0.0026,0.0007,0.0010,0.0014,0.0167,0.0048,0.0002,0.0009,0.0021},{0.0036,0.0015,0.0020,0.0016,0.0009,0.0012,0.0019,0.0019,0.0007,0.0024,0.0028,0.0020,0.0009,0.0011,0.0011,0.0048,0.0156,0.0002,0.0008,0.0033},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0002,0.0003,0.0001,0.0003,0.0006,0.0002,0.0002,0.0007,0.0001,0.0002,0.0002,0.0087,0.0010,0.0004},{0.0011,0.0007,0.0006,0.0005,0.0003,0.0005,0.0006,0.0006,0.0016,0.0013,0.0020,0.0008,0.0005,0.0046,0.0003,0.0009,0.0008,0.0010,0.0148,0.0012},{0.0046,0.0013,0.0009,0.0010,0.0013,0.0010,0.0015,0.0014,0.0005,0.0123,0.0089,0.0015,0.0022,0.0022,0.0010,0.0021,0.0033,0.0004,0.0012,0.0246}};
    private static final double[][] BL85 = {{0.0267,0.0019,0.0015,0.0017,0.0015,0.0016,0.0027,0.0051,0.0009,0.0025,0.0035,0.0027,0.0011,0.0013,0.0021,0.0062,0.0036,0.0003,0.0010,0.0044},{0.0019,0.0217,0.0016,0.0012,0.0003,0.0022,0.0021,0.0014,0.0011,0.0010,0.0017,0.0058,0.0006,0.0006,0.0008,0.0019,0.0014,0.0002,0.0007,0.0012},{0.0015,0.0016,0.0172,0.0036,0.0004,0.0013,0.0018,0.0024,0.0012,0.0007,0.0010,0.0021,0.0004,0.0005,0.0006,0.0028,0.0019,0.0001,0.0006,0.0008},{0.0017,0.0012,0.0036,0.0275,0.0003,0.0013,0.0047,0.0022,0.0008,0.0007,0.0010,0.0019,0.0003,0.0005,0.0009,0.0023,0.0015,0.0001,0.0004,0.0009},{0.0015,0.0003,0.0004,0.0003,0.0182,0.0003,0.0003,0.0006,0.0001,0.0011,0.0013,0.0004,0.0003,0.0006,0.0003,0.0010,0.0009,0.0001,0.0003,0.0014},{0.0016,0.0022,0.0013,0.0013,0.0003,0.0102,0.0034,0.0010,0.0011,0.0007,0.0013,0.0027,0.0007,0.0005,0.0006,0.0016,0.0012,0.0002,0.0005,0.0009},{0.0027,0.0021,0.0018,0.0047,0.0003,0.0034,0.0223,0.0016,0.0011,0.0009,0.0014,0.0033,0.0005,0.0006,0.0012,0.0025,0.0018,0.0002,0.0006,0.0014},{0.0051,0.0014,0.0024,0.0022,0.0006,0.0010,0.0016,0.0496,0.0007,0.0009,0.0015,0.0019,0.0005,0.0008,0.0010,0.0033,0.0017,0.0003,0.0006,0.0013},{0.0009,0.0011,0.0012,0.0008,0.0001,0.0011,0.0011,0.0007,0.0107,0.0004,0.0007,0.0009,0.0002,0.0006,0.0004,0.0009,0.0006,0.0002,0.0015,0.0005},{0.0025,0.0010,0.0007,0.0007,0.0011,0.0007,0.0009,0.0009,0.0004,0.0231,0.0108,0.0011,0.0025,0.0026,0.0007,0.0014,0.0023,0.0003,0.0012,0.0123},{0.0035,0.0017,0.0010,0.0010,0.0013,0.0013,0.0014,0.0015,0.0007,0.0108,0.0457,0.0018,0.0050,0.0051,0.0011,0.0020,0.0027,0.0006,0.0019,0.0085},{0.0027,0.0058,0.0021,0.0019,0.0004,0.0027,0.0033,0.0019,0.0009,0.0011,0.0018,0.0200,0.0007,0.0007,0.0012,0.0024,0.0020,0.0002,0.0007,0.0014},{0.0011,0.0006,0.0004,0.0003,0.0003,0.0007,0.0005,0.0005,0.0002,0.0025,0.0050,0.0007,0.0060,0.0010,0.0003,0.0007,0.0009,0.0002,0.0005,0.0021},{0.0013,0.0006,0.0005,0.0005,0.0006,0.0005,0.0006,0.0008,0.0006,0.0026,0.0051,0.0007,0.0010,0.0224,0.0004,0.0010,0.0010,0.0007,0.0046,0.0021},{0.0021,0.0008,0.0006,0.0009,0.0003,0.0006,0.0012,0.0010,0.0004,0.0007,0.0011,0.0012,0.0003,0.0004,0.0231,0.0014,0.0010,0.0001,0.0003,0.0010},{0.0062,0.0019,0.0028,0.0023,0.0010,0.0016,0.0025,0.0033,0.0009,0.0014,0.0020,0.0024,0.0007,0.0010,0.0014,0.0185,0.0049,0.0002,0.0009,0.0020},{0.0036,0.0014,0.0019,0.0015,0.0009,0.0012,0.0018,0.0017,0.0006,0.0023,0.0027,0.0020,0.0009,0.0010,0.0010,0.0049,0.0174,0.0002,0.0008,0.0032},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0002,0.0003,0.0002,0.0003,0.0006,0.0002,0.0002,0.0007,0.0001,0.0002,0.0002,0.0094,0.0010,0.0003},{0.0010,0.0007,0.0006,0.0004,0.0003,0.0005,0.0006,0.0006,0.0015,0.0012,0.0019,0.0007,0.0005,0.0046,0.0003,0.0009,0.0008,0.0010,0.0160,0.0011},{0.0044,0.0012,0.0008,0.0009,0.0014,0.0009,0.0014,0.0013,0.0005,0.0123,0.0085,0.0014,0.0021,0.0021,0.0010,0.0020,0.0032,0.0003,0.0011,0.0262}};
    private static final double[][] BL90 = {{0.0289,0.0019,0.0014,0.0016,0.0014,0.0016,0.0027,0.0049,0.0008,0.0023,0.0031,0.0026,0.0010,0.0012,0.0020,0.0061,0.0035,0.0003,0.0010,0.0042},{0.0019,0.0229,0.0015,0.0011,0.0003,0.0021,0.0020,0.0013,0.0011,0.0009,0.0016,0.0057,0.0006,0.0006,0.0008,0.0018,0.0013,0.0002,0.0006,0.0011},{0.0014,0.0015,0.0178,0.0034,0.0004,0.0013,0.0017,0.0022,0.0011,0.0006,0.0009,0.0020,0.0003,0.0005,0.0006,0.0026,0.0018,0.0001,0.0005,0.0008},{0.0016,0.0011,0.0034,0.0289,0.0003,0.0012,0.0048,0.0021,0.0007,0.0006,0.0009,0.0018,0.0003,0.0005,0.0008,0.0022,0.0015,0.0001,0.0004,0.0008},{0.0014,0.0003,0.0004,0.0003,0.0190,0.0002,0.0002,0.0005,0.0001,0.0010,0.0012,0.0003,0.0003,0.0005,0.0003,0.0009,0.0008,0.0001,0.0003,0.0013},{0.0016,0.0021,0.0013,0.0012,0.0002,0.0113,0.0034,0.0010,0.0010,0.0006,0.0012,0.0027,0.0007,0.0004,0.0006,0.0015,0.0012,0.0002,0.0005,0.0009},{0.0027,0.0020,0.0017,0.0048,0.0002,0.0034,0.0241,0.0015,0.0011,0.0009,0.0013,0.0032,0.0005,0.0005,0.0011,0.0024,0.0017,0.0002,0.0005,0.0014},{0.0049,0.0013,0.0022,0.0021,0.0005,0.0010,0.0015,0.0521,0.0007,0.0008,0.0014,0.0018,0.0005,0.0007,0.0009,0.0032,0.0016,0.0003,0.0005,0.0012},{0.0008,0.0011,0.0011,0.0007,0.0001,0.0010,0.0011,0.0007,0.0115,0.0004,0.0007,0.0009,0.0002,0.0006,0.0004,0.0009,0.0006,0.0001,0.0014,0.0005},{0.0023,0.0009,0.0006,0.0006,0.0010,0.0006,0.0009,0.0008,0.0004,0.0245,0.0102,0.0010,0.0024,0.0024,0.0007,0.0013,0.0021,0.0003,0.0011,0.0120},{0.0031,0.0016,0.0009,0.0009,0.0012,0.0012,0.0013,0.0014,0.0007,0.0102,0.0473,0.0016,0.0049,0.0047,0.0010,0.0019,0.0025,0.0006,0.0018,0.0081},{0.0026,0.0057,0.0020,0.0018,0.0003,0.0027,0.0032,0.0018,0.0009,0.0010,0.0016,0.0211,0.0007,0.0007,0.0011,0.0023,0.0019,0.0001,0.0007,0.0013},{0.0010,0.0006,0.0003,0.0003,0.0003,0.0007,0.0005,0.0005,0.0002,0.0024,0.0049,0.0007,0.0068,0.0009,0.0003,0.0006,0.0009,0.0002,0.0004,0.0020},{0.0012,0.0006,0.0005,0.0005,0.0005,0.0004,0.0005,0.0007,0.0006,0.0024,0.0047,0.0007,0.0009,0.0228,0.0004,0.0009,0.0009,0.0007,0.0046,0.0020},{0.0020,0.0008,0.0006,0.0008,0.0003,0.0006,0.0011,0.0009,0.0004,0.0007,0.0010,0.0011,0.0003,0.0004,0.0240,0.0013,0.0010,0.0001,0.0003,0.0009},{0.0061,0.0018,0.0026,0.0022,0.0009,0.0015,0.0024,0.0032,0.0009,0.0013,0.0019,0.0023,0.0006,0.0009,0.0013,0.0202,0.0049,0.0002,0.0009,0.0019},{0.0035,0.0013,0.0018,0.0015,0.0008,0.0012,0.0017,0.0016,0.0006,0.0021,0.0025,0.0019,0.0009,0.0009,0.0010,0.0049,0.0193,0.0002,0.0008,0.0030},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0002,0.0003,0.0001,0.0003,0.0006,0.0001,0.0002,0.0007,0.0001,0.0002,0.0002,0.0101,0.0010,0.0003},{0.0010,0.0006,0.0005,0.0004,0.0003,0.0005,0.0005,0.0005,0.0014,0.0011,0.0018,0.0007,0.0004,0.0046,0.0003,0.0009,0.0008,0.0010,0.0173,0.0011},{0.0042,0.0011,0.0008,0.0008,0.0013,0.0009,0.0014,0.0012,0.0005,0.0120,0.0081,0.0013,0.0020,0.0020,0.0009,0.0019,0.0030,0.0003,0.0011,0.0287}};
    private static final double[][] BL95 = {{0.0311,0.0018,0.0014,0.0015,0.0014,0.0016,0.0025,0.0047,0.0007,0.0021,0.0029,0.0024,0.0009,0.0011,0.0018,0.0061,0.0034,0.0003,0.0009,0.0040},{0.0018,0.0243,0.0014,0.0010,0.0003,0.0019,0.0018,0.0012,0.0010,0.0008,0.0014,0.0055,0.0006,0.0006,0.0007,0.0017,0.0013,0.0002,0.0006,0.0010},{0.0014,0.0014,0.0190,0.0033,0.0004,0.0012,0.0016,0.0021,0.0011,0.0006,0.0008,0.0018,0.0003,0.0004,0.0005,0.0025,0.0018,0.0001,0.0005,0.0008},{0.0015,0.0010,0.0033,0.0304,0.0003,0.0012,0.0047,0.0019,0.0007,0.0005,0.0008,0.0017,0.0003,0.0004,0.0008,0.0021,0.0014,0.0001,0.0004,0.0007},{0.0014,0.0003,0.0004,0.0003,0.0199,0.0002,0.0002,0.0005,0.0001,0.0010,0.0011,0.0003,0.0003,0.0005,0.0002,0.0009,0.0008,0.0001,0.0003,0.0012},{0.0016,0.0019,0.0012,0.0012,0.0002,0.0123,0.0032,0.0009,0.0010,0.0006,0.0012,0.0026,0.0007,0.0004,0.0006,0.0015,0.0011,0.0002,0.0005,0.0008},{0.0025,0.0018,0.0016,0.0047,0.0002,0.0032,0.0258,0.0014,0.0010,0.0008,0.0011,0.0030,0.0005,0.0005,0.0010,0.0023,0.0016,0.0001,0.0005,0.0013},{0.0047,0.0012,0.0021,0.0019,0.0005,0.0009,0.0014,0.0552,0.0006,0.0007,0.0013,0.0016,0.0004,0.0007,0.0009,0.0031,0.0016,0.0003,0.0005,0.0011},{0.0007,0.0010,0.0011,0.0007,0.0001,0.0010,0.0010,0.0006,0.0123,0.0004,0.0006,0.0008,0.0002,0.0005,0.0004,0.0008,0.0006,0.0001,0.0013,0.0004},{0.0021,0.0008,0.0006,0.0005,0.0010,0.0006,0.0008,0.0007,0.0004,0.0261,0.0096,0.0009,0.0023,0.0023,0.0006,0.0012,0.0020,0.0003,0.0011,0.0118},{0.0029,0.0014,0.0008,0.0008,0.0011,0.0012,0.0011,0.0013,0.0006,0.0096,0.0492,0.0015,0.0048,0.0045,0.0009,0.0017,0.0023,0.0005,0.0016,0.0076},{0.0024,0.0055,0.0018,0.0017,0.0003,0.0026,0.0030,0.0016,0.0008,0.0009,0.0015,0.0219,0.0006,0.0006,0.0011,0.0021,0.0017,0.0001,0.0006,0.0012},{0.0009,0.0006,0.0003,0.0003,0.0003,0.0007,0.0005,0.0004,0.0002,0.0023,0.0048,0.0006,0.0078,0.0009,0.0003,0.0006,0.0008,0.0002,0.0004,0.0020},{0.0011,0.0006,0.0004,0.0004,0.0005,0.0004,0.0005,0.0007,0.0005,0.0023,0.0045,0.0006,0.0009,0.0236,0.0004,0.0009,0.0009,0.0007,0.0045,0.0019},{0.0018,0.0007,0.0005,0.0008,0.0002,0.0006,0.0010,0.0009,0.0004,0.0006,0.0009,0.0011,0.0003,0.0004,0.0253,0.0013,0.0009,0.0001,0.0003,0.0008},{0.0061,0.0017,0.0025,0.0021,0.0009,0.0015,0.0023,0.0031,0.0008,0.0012,0.0017,0.0021,0.0006,0.0009,0.0013,0.0222,0.0048,0.0002,0.0008,0.0018},{0.0034,0.0013,0.0018,0.0014,0.0008,0.0011,0.0016,0.0016,0.0006,0.0020,0.0023,0.0017,0.0008,0.0009,0.0009,0.0048,0.0216,0.0002,0.0007,0.0031},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0001,0.0003,0.0001,0.0003,0.0005,0.0001,0.0002,0.0007,0.0001,0.0002,0.0002,0.0101,0.0009,0.0003},{0.0009,0.0006,0.0005,0.0004,0.0003,0.0005,0.0005,0.0005,0.0013,0.0011,0.0016,0.0006,0.0004,0.0045,0.0003,0.0008,0.0007,0.0009,0.0182,0.0010},{0.0040,0.0010,0.0008,0.0007,0.0012,0.0008,0.0013,0.0011,0.0004,0.0118,0.0076,0.0012,0.0020,0.0019,0.0008,0.0018,0.0031,0.0003,0.0010,0.0308}};
    private static final double[][] BL100 = {{0.0340,0.0016,0.0013,0.0014,0.0013,0.0015,0.0022,0.0042,0.0007,0.0019,0.0027,0.0022,0.0008,0.0010,0.0017,0.0058,0.0032,0.0003,0.0008,0.0037},{0.0016,0.0266,0.0013,0.0009,0.0002,0.0017,0.0017,0.0011,0.0010,0.0007,0.0013,0.0052,0.0005,0.0005,0.0006,0.0015,0.0012,0.0002,0.0005,0.0009},{0.0013,0.0013,0.0204,0.0030,0.0004,0.0011,0.0015,0.0019,0.0010,0.0005,0.0007,0.0017,0.0003,0.0004,0.0004,0.0023,0.0017,0.0001,0.0005,0.0007},{0.0014,0.0009,0.0030,0.0321,0.0002,0.0011,0.0047,0.0018,0.0006,0.0005,0.0007,0.0015,0.0002,0.0004,0.0007,0.0019,0.0013,0.0001,0.0004,0.0007},{0.0013,0.0002,0.0004,0.0002,0.0201,0.0002,0.0002,0.0004,0.0001,0.0009,0.0010,0.0003,0.0003,0.0005,0.0002,0.0009,0.0008,0.0001,0.0003,0.0011},{0.0015,0.0017,0.0011,0.0011,0.0002,0.0139,0.0029,0.0008,0.0010,0.0005,0.0011,0.0024,0.0006,0.0004,0.0006,0.0013,0.0010,0.0002,0.0004,0.0007},{0.0022,0.0017,0.0015,0.0047,0.0002,0.0029,0.0297,0.0012,0.0009,0.0007,0.0010,0.0027,0.0004,0.0004,0.0009,0.0022,0.0015,0.0001,0.0004,0.0012},{0.0042,0.0011,0.0019,0.0018,0.0004,0.0008,0.0012,0.0581,0.0005,0.0006,0.0012,0.0015,0.0004,0.0006,0.0008,0.0029,0.0015,0.0002,0.0004,0.0009},{0.0007,0.0010,0.0010,0.0006,0.0001,0.0010,0.0009,0.0005,0.0138,0.0003,0.0006,0.0007,0.0002,0.0005,0.0003,0.0008,0.0006,0.0001,0.0012,0.0004},{0.0019,0.0007,0.0005,0.0005,0.0009,0.0005,0.0007,0.0006,0.0003,0.0284,0.0090,0.0008,0.0022,0.0020,0.0005,0.0011,0.0019,0.0002,0.0010,0.0112},{0.0027,0.0013,0.0007,0.0007,0.0010,0.0011,0.0010,0.0012,0.0006,0.0090,0.0526,0.0013,0.0045,0.0041,0.0008,0.0015,0.0021,0.0004,0.0014,0.0071},{0.0022,0.0052,0.0017,0.0015,0.0003,0.0024,0.0027,0.0015,0.0007,0.0008,0.0013,0.0240,0.0006,0.0006,0.0009,0.0019,0.0015,0.0001,0.0005,0.0011},{0.0008,0.0005,0.0003,0.0002,0.0003,0.0006,0.0004,0.0004,0.0002,0.0022,0.0045,0.0006,0.0093,0.0009,0.0003,0.0005,0.0008,0.0002,0.0003,0.0019},{0.0010,0.0005,0.0004,0.0004,0.0005,0.0004,0.0004,0.0006,0.0005,0.0020,0.0041,0.0006,0.0009,0.0257,0.0003,0.0008,0.0008,0.0007,0.0044,0.0017},{0.0017,0.0006,0.0004,0.0007,0.0002,0.0006,0.0009,0.0008,0.0003,0.0005,0.0008,0.0009,0.0003,0.0003,0.0263,0.0011,0.0008,0.0001,0.0002,0.0007},{0.0058,0.0015,0.0023,0.0019,0.0009,0.0013,0.0022,0.0029,0.0008,0.0011,0.0015,0.0019,0.0005,0.0008,0.0011,0.0240,0.0047,0.0002,0.0007,0.0017},{0.0032,0.0012,0.0017,0.0013,0.0008,0.0010,0.0015,0.0015,0.0006,0.0019,0.0021,0.0015,0.0008,0.0008,0.0008,0.0047,0.0243,0.0002,0.0006,0.0029},{0.0003,0.0002,0.0001,0.0001,0.0001,0.0002,0.0001,0.0002,0.0001,0.0002,0.0004,0.0001,0.0002,0.0007,0.0001,0.0002,0.0002,0.0107,0.0009,0.0003},{0.0008,0.0005,0.0005,0.0004,0.0003,0.0004,0.0004,0.0004,0.0012,0.0010,0.0014,0.0005,0.0003,0.0044,0.0002,0.0007,0.0006,0.0009,0.0197,0.0009},{0.0037,0.0009,0.0007,0.0007,0.0011,0.0007,0.0012,0.0009,0.0004,0.0112,0.0071,0.0011,0.0019,0.0017,0.0007,0.0017,0.0029,0.0003,0.0009,0.0329}};

    public static final byte BLOSUM30 = (byte) 30; public static final byte BLOSUM35 = (byte) 35;
    public static final byte BLOSUM40 = (byte) 40; public static final byte BLOSUM45 = (byte) 45;
    public static final byte BLOSUM50 = (byte) 50; public static final byte BLOSUM55 = (byte) 55;
    public static final byte BLOSUM60 = (byte) 60; public static final byte BLOSUM62 = (byte) 62; 
    public static final byte BLOSUM65 = (byte) 65; 
    public static final byte BLOSUM70 = (byte) 70; public static final byte BLOSUM75 = (byte) 75;
    public static final byte BLOSUM80 = (byte) 80; public static final byte BLOSUM85 = (byte) 85;
    public static final byte BLOSUM90 = (byte) 90; public static final byte BLOSUM95 = (byte) 95;
    public static final byte BLOSUM100 = (byte) 100;

    private static Matrix mat, pam1;
    private static int i;
    private static double rate;

    private Model() {}

    public static Matrix getID(int size) {
	return Matrix.identity(size , size);
    }

    public static Matrix getAminoAcidSimilarity(byte name) {
	switch (name) {
	case BLOSUM30: return new Matrix(BL30);
	case BLOSUM35: return new Matrix(BL35);
	case BLOSUM40: return new Matrix(BL40);
	case BLOSUM45: return new Matrix(BL45);
	case BLOSUM50: return new Matrix(BL50);
	case BLOSUM55: return new Matrix(BL55);
	case BLOSUM60: return new Matrix(BL60);
	case BLOSUM62: return new Matrix(BL62);
	case BLOSUM65: return new Matrix(BL65);
	case BLOSUM70: return new Matrix(BL70);
	case BLOSUM75: return new Matrix(BL75);
	case BLOSUM80: return new Matrix(BL80);
	case BLOSUM85: return new Matrix(BL85);
	case BLOSUM90: return new Matrix(BL90);
	case BLOSUM95: return new Matrix(BL95);
	case BLOSUM100: return new Matrix(BL100);
	default: return getID(20);
	}
    }

    private static Matrix getDNAPAM1(double ts_tv_ratio) {
	rate = 1.0 / (200.0 + 100.0 * ts_tv_ratio);
	pam1 = new Matrix(4 , 4 , rate);
	i = -1; while ( ++i < 4 ) pam1.set(i , i , 0.99);
	rate *= ts_tv_ratio;
	pam1.set(1 , 0 , rate); pam1.set(0 , 1 , rate);
	pam1.set(2 , 3 , rate); pam1.set(3 , 2 , rate);
	return pam1;
    }

    public static Matrix getDNAPAM(int n , double ts_tv_ratio) {
	mat = getID(4); 
	if ( n <= 0 ) return mat;
	pam1 = getDNAPAM1(ts_tv_ratio);
	if ( n == 1 ) return pam1;
	i = 0;
	while ( ++i <= n ) mat = mat.times(pam1);
	return mat;
    }
	
	
	

}

	