      subroutine getline(unit, eof)
c  gets a line from unit unit. eof is true when the end of file
c  is reached. all characters are converted to uppercase.
c  sets l_i (begin of a word) and l_j (end of a word) to 0.
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          26-AUG-1988
c
c
      implicit none
c  global variables
      character*80 line
      integer l_i, l_j
      common / in_out / line,l_i,l_j
c  input / output
      integer unit
      logical eof
c  local variables
      integer ck
      integer i
c
c  begin
c
      eof = .false.
      l_i = 0
      l_j = 0
      do i=1, 80
        line(i:i) = ' '
      end do
      read(unit, '(a)', end=111) line
      goto 112
111   eof = .true.
112   continue
      return
      end

      subroutine uppercase(line)
c
c  input / output
      character*80 line
c  local
      integer i, ck
c
c  begin
c
      do i=1,80
        ck = ichar(line(i:i))
        if ((ck.ge.'61'X).and.(ck.le.'7A'X)) then
          line(i:i) = char(ck-32)
        end if
      end do
      return
      end

      subroutine get_word(word)
c  gets a word from the current line (max 10 char)
c  and updates l_i and l_j
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          26-AUG-1988
c
c
      implicit none
c  global variables
      character*80 line
      integer l_i, l_j
      common / in_out / line, l_i, l_j
c  input / output
      character*10 word
c  local variables
      integer i, length
      integer ck
c
c  begin
c
      do i=1, 10
        word(i:i) = ' '
      end do
c
      if (l_j .ge. 80) then
        l_i = 81
        l_j = 81
ccc        write(*,*) ' error:  end of current line reached.'
ccc        write(*,*) ' <blank> returned.'
        goto 9999
      end if
      i = l_j + 1
      do while ((line(i:i) .eq. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      if (line(i:i) .eq. ' ') i = 81
      l_i = i
c
      if (l_i .ge. 80) then
        l_i = 81
        l_j = 81
ccc        write(*,*) ' error:  end of current line reached.'
ccc        write(*,*) ' <blank> returned.'
        goto 9999
      end if
      i = l_i + 1
      do while ((line(i:i) .ne. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      if (line(i:i) .ne. ' ') i = 81
      l_j = i - 1
c
      length = l_j - l_i + 1
      if (length .gt. 10) length = 10
      do i=1, length
        word(i:i) = line((l_i+i-1):(l_i+i-1))
      end do
c
c convert to uppercase letters
      do i=1, length
        ck = ichar(word(i:i))
        if ((ck.ge.'61'X).and.(ck.le.'7A'X)) then
          word(i:i) = char(ck-32)
        end if
      end do
c
 9999 return
      end


      subroutine get_int(int)
c  gets a word from the current line (max 10 char)
c  and updates l_i and l_j
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          26-AUG-1988
c
c
      implicit none
c  global variables
      character*80 line
      integer l_i, l_j
      common / in_out / line, l_i, l_j
c  input / output
      integer int
c  local variables
      integer i, length
c
c  begin
c
      int = 0
c
      if (l_j .ge. 80) then
        l_i = 81
        l_j = 81
ccc        write(*,*) ' error:  end of current line reached.'
ccc        write(*,*) ' 0 returned.'
        goto 9999
      end if
      i = l_j + 1
      do while ((line(i:i) .eq. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      if (line(i:i) .eq. ' ') i = 81
      l_i = i
c
      if (l_i .ge. 80) then
        l_i = 81
        l_j = 81
ccc        write(*,*) ' error:  end of current line reached.'
ccc        write(*,*) ' 0 returned.'
        goto 9999
      end if
      i = l_i + 1
      do while ((line(i:i) .ne. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      if (line(i:i) .ne. ' ') i = 81
      l_j = i - 1
c
      read(line(l_i:l_j),*,err=111) int
      goto 112
 111  write(*,*) ' error:  ',line(l_i:l_j), '  is not an integer.'
      write(*,*) ' 0 returned.'
 112  continue
c
 9999 return
      end


      subroutine putline(unit)
c  outputs the current line to unit unit.
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          27-AUG-1988
c
c
      implicit none
c  global variables
      character*80 line
      integer l_i, l_j
      common / in_out / line,l_i,l_j
c  input / output
      integer unit
c  local variables
c
c  begin
c
      write(unit, '(a)') line
      return
      end

      subroutine INQUIRE_STRING(prompt, word)
c
c  gets a word from input (max 80 char)
c  and updates l_i and l_j
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          31-AUG-1988
c
c
      implicit none
c  global variables
      character*80 line
      integer l_i, l_j
      common / in_out / line, l_i, l_j
c  input / output
      character*(*) prompt
      character word*80
c  local variables
      integer i, length
      logical eof
c
c  begin
c
      do i=1, 80
        word(i:i) = ' '
      end do
c
      write(*,'('' '',a ,$)') prompt
      call getline(5,eof)
      i = l_j + 1
      do while ((line(i:i) .eq. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      l_i = i
c
      i = l_i + 1
      do while ((line(i:i) .ne. ' ') .and. (i .lt. 80)) 
        i = i + 1
      end do
      if (line(i:i) .ne. ' ') i = 81
      l_j = i - 1
c
      length = l_j - l_i + 1
      do i=1, length
        word(i:i) = line((l_i+i-1):(l_i+i-1))
      end do
c
 9999 return
      end


      subroutine remove_version(filename)
c
c  simply removes the version number from a filename
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          15-NOV-1988
c
c
      implicit none
c  input / output
      character filename*80
c  local variables
      integer i, length
      logical eof
c
c  begin
c
      i = index(filename, ';')
      if (i .gt. 0) then
        do while ((filename(i:i) .ne. ' ') .and. (i.lt.80))
          filename(i:i) = ' '
          i = i + 1
        end do
      end if
      return
      end
c
c
      SUBROUTINE TRIML(ST,STLEN)
C routine removes leading blanks in string ST and fills the
C remainder on the right site with blanks
C
C Axel Brunger, 2-JUL-84
C =======================
C
      IMPLICIT NONE
C input/output
      CHARACTER*(*) ST
      INTEGER STLEN
C local
      INTEGER IS, I, STOLD
      CHARACTER*1 TEMP
C begin
      IF (STLEN.GT.0) then
        STOLD=STLEN
        IS=1
        do WHILE (IS.LE.STLEN.AND.ST(IS:IS).EQ.' ') 
          IS=IS+1
        end do
        STLEN=STLEN-IS+1
        IF (STLEN.LT.STOLD) then
          IS=IS-1
C
C The following code avoids a self-assignment ( ST(..) = ST(..) )
C and therefore makes the CFT 1.13 compiler on the CRAY happy.
C As soon as this is fixed (in the compiler) this inefficient loop
C should be replaced !
          DO I=1,STLEN
            TEMP=ST(I+IS:I+IS)
            ST(I:I)=TEMP
          end do
          ST(STLEN+1:STOLD)=' '
        end if
      end if
      RETURN
      END
c
      logical function NEXT_FILE_OPEN
     2   (prompt, file, unit, access, form)
c
c  Gets a filename from SYS$INPUT and tries to open the file. 
c  Loops until a file can be accessed in the way specified by ACCESS
c  or an empty input line.
c  Is TRUE when the file has been opened, otherwise FALSE.
c  Uses Axel Brungers ASSFIL routine
c
c  Author: Michael Nilges, LCP, NIDDK, NIH
c    30-NOV-1988  written on the basis of earlier versions
c
      implicit none
c input/output
      character*(*) prompt, file, access, form
      integer unit
c local
      logical err, opened
c begin
c
c  input coordinate file
      err = .true.
      do while (err)
        call INQUIRE_STRING(prompt, file)
        if (file(1:1) .eq. ' ') then
          err = .false.
          opened = .false.
          unit = 0
        else 
          call ASSFIL(file, unit, access, form, err)
          opened = (.not. err)
        end if
      end do
      NEXT_FILE_OPEN = opened
c
      end

      SUBROUTINE ASSFIL(NAME,UNIT,ACCESS,FORM,ERR)
C
C Checks whether file NAME already open and then returns the unit
C otherwise it gets a free FORTRAN unit, tries to open the file 
C NAME and gets the full filename specification.
C
C ACCESS : 'WRITE', 'READ', 'APPEND'
C FORM : 'FORMATTED', 'UNFORMATTED'
C NAME : <filename>, 'INPUT', 'OUTPUT'
C
C Axel Brunger, 22-SEP-85
C =======================
C converted to fortran v, Michael Nilges, 25-FEB 1988
c
      IMPLICIT NONE
C input/output
      CHARACTER*(*) NAME, ACCESS, FORM
      INTEGER UNIT
      LOGICAL ERR
C local
      INTEGER L, TMAX, TLEN
      PARAMETER (TMAX=132)
      CHARACTER*(TMAX) T
      CHARACTER*11 STATUS
      LOGICAL QOPEN, QFORM, QWRITE
C begin
C
      L=LEN(NAME)
      CALL TRIM(NAME,L)
C
C inquire about the file
      CALL VINQRE('FILE',NAME,0,0,QOPEN,QFORM,QWRITE,UNIT)
C
C if file is already open do some error checking
      if (QOPEN) then

      ERR=.TRUE.
      if  (FORM.EQ.'FORMATTED'.AND..NOT.QFORM) then
         WRITE(6,'(2A)') ' %ASSFIL-ERR: file ',
     &   'already open but not formatted as requested'
      else if (FORM.EQ.'UNFORMATTED'.AND.QFORM) then
         WRITE(6,'(2A)') ' %ASSFIL-ERR: file ',
     &   'already open but not unformatted as requested'
      else if 
     & ((ACCESS.EQ.'WRITE'.OR.ACCESS.EQ.'APPEND').AND..NOT.QWRITE)
     & then
         WRITE(6,'(2A)') ' %ASSFIL-ERR: file ',
     &   'already open but not for write access as requested'
      else if (ACCESS.EQ.'READ'.AND.QWRITE) then
         WRITE(6,'(2A)') ' %ASSFIL-ERR: file ',
     &   'already open but not for read access as requested'
      else 
         ERR=.FALSE.
      end if
      ELSE
C
C file not open, get a free FORTRAN unit
      UNIT=0
      UNIT=UNIT+1
      CALL VINQRE('UNIT',T,TMAX,TLEN,QOPEN,QFORM,QWRITE,UNIT)
      do while (UNIT.le.99.and.QOPEN) 
        UNIT=UNIT+1
        CALL VINQRE('UNIT',T,TMAX,TLEN,QOPEN,QFORM,QWRITE,UNIT)
      end do
      if (QOPEN) then
      WRITE(6,'(A)')' %ASSFIL-ERR: no free unit available'
      ERR=.TRUE.
      ELSE 
        CALL VOPEN(UNIT,NAME,FORM,ACCESS,ERR)
        if (ERR) then
        WRITE(6,'(2A)') ' %ASSFIL-ERR: error opening file ',NAME(1:L)
        ELSE
C
C get full file name to print message about opening a file
        CALL VINQRE('UNIT',T,TMAX,TLEN,QOPEN,QFORM,QWRITE,UNIT)
        WRITE(6,'(3A)') ' ASSFIL: file ',T(1:TLEN),' opened.'
        end if
      end if
      end if
      RETURN
      END


      SUBROUTINE VOPEN(UNIT,FILE,FORM,ACCESS,ERR)
C
C Opens a file.
C
C +++++++++++++++++++++++++++++
C machine dependent VAX version
C +++++++++++++++++++++++++++++
C
C Axel Brunger, 30-APR-85
C =======================
C
      IMPLICIT NONE
C input/output

      INTEGER MAXUN
      PARAMETER (MAXUN=99)
      INTEGER IFREEU(MAXUN)
      CHARACTER*60 COSPDN(MAXUN)
      CHARACTER*8  COSDN(MAXUN)
      COMMON /IOCHAN/ IFREEU
      COMMON /CIOCHA/ COSPDN, COSDN
      SAVE /IOCHAN/
      SAVE /CIOCHA/

      INTEGER UNIT
      CHARACTER*(*) FILE, FORM, ACCESS
      LOGICAL ERR, firstfile
C local
      INTEGER I
C begin
      ERR=.FALSE.
      firstfile = .false.
      if (FILE.EQ.'$$INITIAL$$') then
C---------------------------------------------------------------
C special section for initialization
C open standard input (channel 5) readonly
        OPEN(FORM='FORMATTED',STATUS='OLD',ACCESS='SEQUENTIAL',
     &     UNIT=5,READONLY)
        firstfile = .true.
C
C open standard output (channel 6)
CC      OPEN(FORM='FORMATTED',STATUS='NEW',ACCESS='SEQUENTIAL',
CC     &     UNIT=6,CARRIAGECONTROL='LIST')
C
C Initialize list of free FORTRAN units.
C It is assumed that system input is assigned to unit 5
C and system output is assigned to unit 6 and all other
C units are deassigned.
        DO I=1,MAXUN
           IFREEU(I)=0
        end do
        IFREEU(5)=10
        IFREEU(6)=1
      else if (FORM.NE.'FORMATTED'.AND.FORM.NE.'UNFORMATTED') then
        WRITE(6,'(3A)')
     & ' %VOPEN-ERR: unknown format qualifier "',FORM,'"'
        ERR=.TRUE.
C---------------------------------------------------------------
C write append access
      else if (ACCESS.EQ.'APPEND') then
      OPEN(FILE=FILE,FORM=FORM,STATUS='OLD',ACCESS='APPEND',ERR=9999,
     &     UNIT=UNIT)
C---------------------------------------------------------------
C read access
      else if (ACCESS.EQ.'READ') then
      OPEN(FILE=FILE,FORM=FORM,STATUS='OLD',ACCESS='SEQUENTIAL',
     &     ERR=9999,UNIT=UNIT)
C---------------------------------------------------------------
C write access
      else if (ACCESS.EQ.'WRITE') then
      OPEN(FILE=FILE,FORM=FORM,STATUS='NEW',ACCESS='SEQUENTIAL',
     &     ERR=9999,UNIT=UNIT)
C---------------------------------------------------------------
      else 
        WRITE(6,'(3A)')
     &  ' %VOPEN-ERR: unknown access qualilifer "',ACCESS,'"'
        ERR=.TRUE.
      end if
      GOTO 8888
9999  ERR=.TRUE.
8888  CONTINUE
C
      IF (.NOT.(ERR.or.firstfile))  then
C
C put appropriate code in IFREEU array:
C  +10 read formatted
C  +1  write/append formatted
C  -1  write/append unformatted
C  -10 read unformatted
      if  (FORM.EQ.'FORMATTED') then 
         IFREEU(UNIT)=1
      ELSE 
         IFREEU(UNIT)=-1
      end if
      IF (ACCESS.EQ.'READ') IFREEU(UNIT)=IFREEU(UNIT)*10
      end if !IF (.NOT.ERR)
      RETURN
      END
C
      SUBROUTINE VINQRE(MODE,NAME,MAXLEN,LENGTH,QOPEN,QFORM,QWRITE,
     &                  UNIT)
C
C file inquiry by file name or FORTRAN unit
C Flag QOPEN indicates whether file or unit is "open".
C Flag QFORM indicates whether file was opened formatted.
C Flag QWRITe indicates whether file was opened write-access.
C For inquiry by unit MAXLEN has to be specified (max length of NAME)
C and LENGTH returns with the length of NAME.
C For inquiry by file the two names INPUT and OUTPUT are reserved
C for the standard input and output channels 5 and 6.
C
C +++++++++++++++++++++++++++++
C machine dependent VAX version
C +++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C I/O

      INTEGER MAXUN
      PARAMETER (MAXUN=99)
      INTEGER IFREEU(MAXUN)
      CHARACTER*60 COSPDN(MAXUN)
      CHARACTER*8  COSDN(MAXUN)
      COMMON /IOCHAN/ IFREEU
      COMMON /CIOCHA/ COSPDN, COSDN
      SAVE /IOCHAN/
      SAVE /CIOCHA/

      CHARACTER*(*) MODE, NAME
      INTEGER MAXLEN, LENGTH
      LOGICAL QOPEN, QFORM, QWRITE
      INTEGER UNIT
C begin
      QOPEN=.TRUE.
      if (MODE.EQ.'FILE'.AND.NAME.EQ.'INPUT') then
         UNIT=5
      else if (MODE.EQ.'FILE'.AND.NAME.EQ.'OUTPUT') then
         UNIT=6
      else if (MODE.EQ.'FILE') then 
         INQUIRE(FILE=NAME,OPENED=QOPEN,NUMBER=UNIT)
      else if (MODE.EQ.'UNIT') then
         INQUIRE(UNIT=UNIT,OPENED=QOPEN,NAME=NAME)
         LENGTH=MAXLEN
         CALL TRIM(NAME,LENGTH)
      end if
C
C if file is open then get QFORM and QWRITE flags
      IF (QOPEN) then
        if (IFREEU(UNIT).eq.(+1)) then
          QFORM=.TRUE.
          QWRITE=.TRUE.
        else if (IFREEU(UNIT).eq.(+10)) then
          QFORM=.TRUE.
          QWRITE=.FALSE.
        else if (IFREEU(UNIT).eq.(-1)) then
          QFORM=.FALSE.
          QWRITE=.TRUE.
        else if (IFREEU(UNIT).eq.(-10)) then
          QFORM=.FALSE.
          QWRITE=.FALSE.
        end if
      end if
      RETURN
      END
C
      SUBROUTINE VCLOSE(UNIT,DISPOS,ERR)
C
C closes a file/unit with disposition DISPOS and sets the
C corresponding IFREEU element to zero.
C
C DONT CLOSE UNIT 5 OR 6 !!
C
C +++++++++++++++++++++++++++++
C machine dependent VAX version
C +++++++++++++++++++++++++++++
C
C By Axel Brunger, 21-APR-85
C
      IMPLICIT NONE
C I/O

      INTEGER MAXUN
      PARAMETER (MAXUN=99)
      INTEGER IFREEU(MAXUN)
      CHARACTER*60 COSPDN(MAXUN)
      CHARACTER*8  COSDN(MAXUN)
      COMMON /IOCHAN/ IFREEU
      COMMON /CIOCHA/ COSPDN, COSDN
      SAVE /IOCHAN/
      SAVE /CIOCHA/

      INTEGER UNIT
      CHARACTER*(*) DISPOS
      LOGICAL ERR
C begin
      ERR=.FALSE.
      IF (UNIT.NE.6.AND.UNIT.NE.5) then
         CLOSE(UNIT=UNIT,STATUS=DISPOS,ERR=9999)
         IFREEU(UNIT)=0
      end if
      GOTO 8888
9999  CONTINUE
      WRITE(6,'(A)') ' %VCLOSE-ERR: error during close '
      ERR=.TRUE.
8888  CONTINUE
      RETURN
      END
      SUBROUTINE TRIM(ST,STLEN)
C routine removes trailing blanks in string ST
C
C Axel Brunger, 10-DEC-83
C =======================
C
      IMPLICIT NONE
C input/output
      CHARACTER*(*) ST
      INTEGER STLEN
C begin
      IF (STLEN.GT.0) then
      do WHILE (STLEN.GE.1.AND.ST(STLEN:STLEN).EQ.' ') 
        STLEN=STLEN-1
      end do
      end if
      RETURN
      END
