"""
Setup.py
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import copy, glob, os, re, shutil, string

from Aria.Main import Messages, ParsePath
from Aria.ThirdParty import TextFile
from Aria.DataIO import Csi2Aria, SequenceList


def SetupNewProject(whichsetup, ariadir, projectdir, runnumber, aspectrum1,\
		    aspectrum2, aspectrum3, aspectrum4, aspectrum5,\
		    seqpdbfile, dihedfile, c1File, c2File, c3File, c4File,\
                    c5File, rdc1File, rdc2File, rdc3File, rdc4File, rdc5File,\
                    hbondfile, csifile, segid):
    """
    sets up a new directory tree, copy and create files on the fly
    OUTPUT: returns nothing, but a directory tree will be created
    """
    runDir = os.path.join(projectdir, 'run' + runnumber)
    if os.path.exists(projectdir) == 1:
        if os.path.exists(runDir) == 1:
            print 'run' + runnumber, 'already exists => ARIA stopped'
            Messages.StopAria()
        else:
            print 'project', projectdir, 'exists, run', runnumber, 'does not exist'
            print 'create the new run', runnumber
    else:
        print 'setting up a new project in directory', projectdir
        os.mkdir(projectdir)
    
    #create directories:
    os.mkdir(runDir)
    os.mkdir(os.path.join(runDir, 'begin'))
    os.mkdir(os.path.join(runDir, 'data'))
    os.mkdir(os.path.join(runDir, 'data/dihedrals'))
    os.mkdir(os.path.join(runDir, 'data/hbonds'))
    os.mkdir(os.path.join(runDir, 'data/jcouplings'))
    os.mkdir(os.path.join(runDir, 'data/rdcs'))
    os.mkdir(os.path.join(runDir, 'data/ssbonds'))
    os.mkdir(os.path.join(runDir, 'data/sequence'))
    os.mkdir(os.path.join(runDir, 'protocols'))
    os.mkdir(os.path.join(runDir, 'structures'))
    os.mkdir(os.path.join(runDir, 'toppar'))
    #create iterations 0 to 8
    for it in range(9):
        it = str(it)
  	os.mkdir(os.path.join(runDir, 'structures/it' + it))
        if it == '8':
            os.mkdir(os.path.join(runDir, 'structures/it' + it + '/analysis'))
            os.mkdir(os.path.join(runDir, 'structures/it' + it + '/water'))
            os.mkdir(os.path.join(runDir, 'structures/it' + it + '/water/analysis'))
            os.mkdir(os.path.join(runDir, 'structures/it8/finaldata'))  #for the last .tbl & .list
            iterationfile = open(os.path.join(runDir, 'structures/it' + it + \
                                              '/water/iteration.cns'), 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
            iterationfile = open(os.path.join(runDir, 'structures/it' + it + \
                                  '/analysis/iteration.cns'), 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
            iterationfile = open(os.path.join(runDir, 'structures/it' + it + \
                                  '/water/analysis/iteration.cns'), 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
            iterationfile.close()
            iterationfile = open(os.path.join(runDir, 'structures/it' + it + \
                                              '/finaldata/iteration.cns'), 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
        iterationfile = open(os.path.join(runDir, 'structures/it' + it + \
                                          '/iteration.cns'), 'w')
 	iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
			    it + ')\n')
 	iterationfile.close()
    spectrumtogo = ['aspectrum1', 'aspectrum2', 'aspectrum3', 'aspectrum4',
		    'aspectrum5']
    #create the specified spectra directories:
    for spectrumx in spectrumtogo:
	try:
            exec 'spectrumy = copy.copy(' + spectrumx + ')' 
	except NameError:
	    pass  #for the case when it's empty
	if spectrumy:
	    print '  creating spectrum directory:', spectrumy
	    os.mkdir(runDir + '/data/' + spectrumy)
	    spectrumxplor = open(runDir + '/data/' + spectrumy + \
				 '/spectrum.cns', 'w')
	    spectrumxplor.write('module(spectrum)\nevaluate (&spectrum ="'+\
				spectrumy + '")\n')
	    spectrumxplor.close()

    #create empty .tbl files:
    emptyFiles =['/data/dihedrals/dihedrals.tbl',\
                 '/data/dihedrals/dihedrals_csi.tbl',\
                 '/data/hbonds/hbonds.tbl',\
                 '/data/hbonds/hbonds_csi.tbl',\
                 '/data/jcouplings/c1.tbl',\
                 '/data/jcouplings/c2.tbl',\
                 '/data/jcouplings/c3.tbl',\
                 '/data/jcouplings/c4.tbl',\
                 '/data/jcouplings/c5.tbl',\
                 '/data/rdcs/rdc1.tbl',\
                 '/data/rdcs/rdc2.tbl',\
                 '/data/rdcs/rdc3.tbl',\
                 '/data/rdcs/rdc4.tbl',\
                 '/data/rdcs/rdc5.tbl',\
                 '/data/sequence/secondarystructure.cns',\
                 '/data/sequence/stereoassign.cns',\
                 '/data/ssbonds/ssbonds.tbl']
    for fileToTouch in emptyFiles:
        openfile = runDir + fileToTouch
        openhandle = open(openfile, 'w')
        openhandle.close()

    
    #copy parameter and topology files to /toppar of new project:
    tocopy = glob.glob(ariadir + '/toppar/*')
    for filetocopy in tocopy:
        if filetocopy[-3:] != 'CVS':
            shutil.copy(filetocopy, runDir + '/toppar')

    #copy protocols to /protocols of your new project:
    tocopy = glob.glob(ariadir + '/protocols/*')
    for filetocopy in tocopy:
        if filetocopy[-3:] != 'CVS':
            shutil.copy(filetocopy, runDir + '/protocols')
    
    #copy the dihedrals, hbonds, jcouplings, rdcs:
    tocopy =[[dihedfile, '/data/dihedrals/dihedrals.tbl'],\
             [hbondfile, '/data/hbonds/hbonds.tbl'],\
             [c1File, '/data/jcouplings/c1.tbl'],\
             [c2File, '/data/jcouplings/c2.tbl'],\
             [c3File, '/data/jcouplings/c3.tbl'],\
             [c4File, '/data/jcouplings/c4.tbl'],\
             [c5File, '/data/jcouplings/c5.tbl'],\
             [rdc1File, '/data/rdcs/rdc1.tbl'],\
             [rdc2File, '/data/rdcs/rdc2.tbl'],\
             [rdc3File, '/data/rdcs/rdc3.tbl'],\
             [rdc4File, '/data/rdcs/rdc4.tbl'],\
             [rdc5File, '/data/rdcs/rdc5.tbl']]
    
    for filetocopy in tocopy:
        if filetocopy[0] and os.path.exists(filetocopy[0]):
            print '  copying', filetocopy[0], '\n    to', runDir + \
                  filetocopy[1]
            shutil.copy(filetocopy[0], runDir + filetocopy[1])

    #convert the chemical shift index files (CSI) to ARIA format:
    if csifile:
        print '  converting csi table in ARIA restraints'
        try:
            csilist = Csi2Aria.parseCSI(csifile)
            hbondscsi, phicsi, psicsi = Csi2Aria.makeRestraints(csilist)
            hbondscsifile = runDir + '/data/hbonds/hbonds_csi.tbl'
            dihedralscsifile = runDir + '/data/dihedrals/dihedrals_csi.tbl'
            print '    writing', hbondscsifile
            Csi2Aria.writeRestraint(hbondscsi, hbondscsifile)
            print '    writing', dihedralscsifile
            dihedralscsihandle = open(dihedralscsifile, 'w')
            dihedralscsihandle.write('! CSI restraints, converted by ARIA\n')
            dihedralscsihandle.write('! Phi:\n\n')
            dihedralscsihandle.close()
            Csi2Aria.writeRestraint(phicsi, dihedralscsifile, 'a')
            dihedralscsihandle = open(dihedralscsifile, 'a')   #append it
            dihedralscsihandle.write('\n\n! Psi:\n\n')
            dihedralscsihandle.close()
            Csi2Aria.writeRestraint(psicsi, dihedralscsifile, 'a')   #append it
        except:
            print 'NOTE: csi restraints could not be converted!!!'
    #look if it is a sequence or PDB file, copy it to /data/sequence:
    seqpdbhandle = TextFile.TextFile(seqpdbfile)
    seqorpdb = 0                           #0 means: it is a sequence file
    atom = re.compile('ATOM')
    #this is a very simple test to check the format:
    for line in seqpdbhandle:
	if atom.match(line):   #just look for lines which start with 'ATOM'
	    seqorpdb=1                     #1 means: it is a PDB file
    seqpdbhandle.close()
    if seqorpdb == 1:
	shutil.copy(seqpdbfile, runDir + '/data/sequence')
	print '  ' + seqpdbfile + ' is a PDB file\n  copied to ' +\
	      runDir + '/data/sequence'
    else:
        #check the format of the sequence files
        #ANSIG format contains 'sequence' ... 'end_sequence'
        #PIPP stapp.par contains 'SEQUENCE'
        #XEASY format contains numbers
        ansigSeq = re.compile('sequence.*end_sequence', re.DOTALL)
        pippSeq = re.compile('SEQUENCE')
        seqHandle = open(seqpdbfile)
        seqBigString = string.join(seqHandle.readlines())
        seqHandle.close()
        if ansigSeq.search(seqBigString) and whichsetup == 'ANSIG':
            print '  ' + seqpdbfile + \
                  ' is an ANSIG sequence file\n  converted and copied to ' +\
                  runDir + '/data/sequence'
            SL = SequenceList.SequenceList()
            SL.ReadAnsig(seqpdbfile)
            SL.WriteSeq(runDir + '/data/sequence/' + ParsePath.GetTail(seqpdbfile))
        elif pippSeq.search(seqBigString) and whichsetup == 'PIPPPCK':
            print '  ' + seqpdbfile + \
                  ' is a PIPP stapp.par file\n  converted and copied to ' +\
                  runDir + '/data/sequence'
            SL = SequenceList.SequenceList()
            SL.ReadPipp(seqpdbfile)
            SL.WriteSeq(runDir + '/data/sequence/' + ParsePath.GetTail(seqpdbfile))
        else:
            #some sequence files (XEASY) contain numbers or other stuff:
            #match any non-alphabetic character and remove them:
            notABC = re.compile('[^a-zA-Z\n\t]')
            #input:
            seqHandle = open(seqpdbfile)
            seqBigString = string.join(seqHandle.readlines())
            seqHandle.close()
            seqBigString = notABC.sub(' ', seqBigString)
            #output:
            seqOutFileName = os.path.join(runDir, 'data/sequence', ParsePath.GetTail(seqpdbfile))
            outHandle = open(seqOutFileName, 'w')
            outHandle.write(seqBigString)
            outHandle.close()
            print '  ' + seqpdbfile + ' is a sequence file\n  copied to ' +\
                  runDir + '/data/sequence'
            #printing the 1-letter code sequence to stdout:
            SL = SequenceList.SequenceList()
            SL.ReadSeq(seqOutFileName)
        SL.StdoutOne()
            
    #now parsing the information of new.html and writing to run.cns
    print 'editing run.cns: setting the default values'
    runcnsfile = ariadir + '/protocols/run.cns'
    runcnshandle = TextFile.TextFile(runcnsfile)
    newruncnshandle = TextFile.TextFile(runDir + '/run.cns', 'w')
    fileRootparsed = ParsePath.GetTail(projectdir)
    seqpdbpathparsed = ParsePath.GetTail(seqpdbfile)
    templateparsed = fileRootparsed + '_template.pdb'
    structureparsed = fileRootparsed + '.psf'
    arrow = re.compile('{===>}')

    #looking for the number of spectra:
    spectrumtogo = ['aspectrum1', 'aspectrum2', 'aspectrum3', 'aspectrum4',
		    'aspectrum5']
    foundnspectra = 0
    for spectrumx in spectrumtogo:
        try: exec 'spectrumy = copy.copy(' + spectrumx + ')' 
	except NameError:
	    pass  #for the case when it's empty
	if spectrumy:
            foundnspectra = spectrumx[-1:]

    #get the relative path:
    dihedfile = ParsePath.GetTail(dihedfile)
    hbondfile = ParsePath.GetTail(hbondfile)
    c1File = ParsePath.GetTail(c1File)
    c2File = ParsePath.GetTail(c2File)
    c3File = ParsePath.GetTail(c3File)
    c4File = ParsePath.GetTail(c4File)
    c5File = ParsePath.GetTail(c5File)

    #set the 'None' (=not used) fields to '':
    if not aspectrum1: aspectrum1 = ''
    if not aspectrum2: aspectrum2 = ''
    if not aspectrum3: aspectrum3 = ''
    if not aspectrum4: aspectrum4 = ''
    if not aspectrum5: aspectrum5 = ''
    
    if not hbondfile: hbondfile = ''
    if not seqpdbpathparsed: seqpdbpathparsed = ''
    if not segid: segid = ''
    if not structureparsed: structureparsed = ''
    if not templateparsed: templateparsed = ''

    if aspectrum1:
        aspectrum1tbl = aspectrum1 + '.tbl'
        aspectrum1ppm = aspectrum1 + '.ppm'
    else:
        aspectrum1tbl = ''
        aspectrum1ppm = ''
    if aspectrum2:
        aspectrum2tbl = aspectrum2 + '.tbl'
        aspectrum2ppm = aspectrum2 + '.ppm'
    else:
        aspectrum2tbl = ''
        aspectrum2ppm = ''
    if aspectrum3:
        aspectrum3tbl = aspectrum3 + '.tbl'
        aspectrum3ppm = aspectrum3 + '.ppm'
    else:
        aspectrum3tbl = ''
        aspectrum3ppm = ''
    if aspectrum4:
        aspectrum4tbl = aspectrum4 + '.tbl'
        aspectrum4ppm = aspectrum4 + '.ppm'
    else:
        aspectrum4tbl = ''
        aspectrum4ppm = ''
    if aspectrum5:
        aspectrum5tbl = aspectrum5 + '.tbl'
        aspectrum5ppm = aspectrum5 + '.ppm'
    else:
        aspectrum5tbl = ''
        aspectrum5ppm = ''
    
    toparse = {'aria_dir': ariadir,
	       'aspectrum_1': aspectrum1,
	       'aspectrum_2': aspectrum2,
	       'aspectrum_3': aspectrum3,
	       'aspectrum_4': aspectrum4,
	       'aspectrum_5': aspectrum5,
               'fileroot': fileRootparsed,
	       'hbonds_file': hbondfile,
               'peaklist_1': aspectrum1tbl,
	       'peaklist_2': aspectrum2tbl,
	       'peaklist_3': aspectrum3tbl,
	       'peaklist_4': aspectrum4tbl,
	       'peaklist_5': aspectrum5tbl,
               'project_dir': projectdir,
	       'prot_coor_1': seqpdbpathparsed,
	       'run_dir': runDir,
               'prot_segid_1': segid,
	       'shifts_1': aspectrum1ppm,
	       'shifts_2': aspectrum2ppm,
	       'shifts_3': aspectrum3ppm,
	       'shifts_4': aspectrum4ppm,
	       'shifts_5': aspectrum5ppm,
	       'structure': structureparsed,
	       'template': templateparsed,
               'temptrash_dir': runDir}
#    if whichsetup == 'ARIA_TBLWITHC':
#        toparse['aspectrum']
    toparsewq = {'nspectra': foundnspectra} #without quotationmarks (=wq)
    if seqorpdb == 1:
	toparse['pdb_or_sequence'] = 'PDB'
    else:
	toparse['pdb_or_sequence'] = 'sequence'
    for line in runcnshandle:
        if not re.search('structure_', line):  #for the psf files 2-5
            if arrow.match(line):
                for keyword in toparse.keys():
                    if re.search(keyword, line):
                        line = re.sub('".*"', '"' + toparse[keyword] + '"', line)
                for keywordwq in toparsewq.keys():
                    if re.search(keywordwq, line):
                        line = re.sub('=[^=>]*?;', '=' +\
                                      str(toparsewq[keywordwq]) + ';' , line)
                if whichsetup == 'ARIA_ASSIGN':
                    if re.search('nspectra', line):
                        line = re.sub('=[^=>]*?;', '=0;', line)
                    
	newruncnshandle.write(line)
    runcnshandle.close()
    newruncnshandle.close()
    
    #copy new.html from the current directory in the html directory:
    if os.path.exists('new.html'):
        newhtml = 'new.html'
        print 'copying new.html to', runDir + '/data/new.html' 
        shutil.copy(newhtml, runDir + '/data/new.html')
    else:
        print 'WARNING: could not find new.html file!'
        Messages.StopAria()

    #end:
    print 'created a new directory tree for the project', projectdir
    

def SetupNewRun(ariadir, projectdir, oldrunnumber, olditnumber, runnumber,
                protocolscopy, topparcopy):
    """
    sets up a new run, copy and change some files on the fly
    OUTPUT: returns nothing, but a new run directory will be created
    """
    runDir = projectdir + '/run' + runnumber
    oldrunDir = projectdir + '/run' + oldrunnumber
    if os.path.exists(runDir) == 1:
	print 'run' + runnumber, 'already exists => ARIA stopped'
	Messages.StopAria()
    if os.path.exists(oldrunDir) != 1:
	print 'run' + runnumber, 'does not exist => ARIA stopped'
	Messages.StopAria()
    print 'setting up run' + runnumber, ' in directory', projectdir

    #creating some directories and copying files:
    print '  creating directory', runDir
    os.mkdir(runDir)
    print '  copying', oldrunDir + '/run.cns', 'to', runDir
    shutil.copy(oldrunDir + '/run.cns', runDir)
    print '  copying', oldrunDir + '/begin', 'to',  runDir + '/begin'
    shutil.copytree(oldrunDir + '/begin', runDir + '/begin')
    print '  copying', oldrunDir + '/data', 'to',  runDir + '/data'
    shutil.copytree(oldrunDir + '/data', runDir + '/data')
    if protocolscopy == 'program':
        print '  copying', ariadir + '/protocols', 'to', runDir + '/protocols'
        shutil.copytree(ariadir + '/protocols', runDir + '/protocols')
    elif protocolscopy == 'template':
        print '  copying', oldrunDir + '/protocols', 'to', runDir + '/protocols'
        shutil.copytree(oldrunDir + '/protocols', runDir + '/protocols')
    if topparcopy == 'program':
        print '  copying', ariadir + '/toppar', 'to', runDir + '/toppar'
        shutil.copytree(ariadir + '/toppar', runDir + '/toppar')
    elif topparcopy == 'template':
        print '  copying', oldrunDir + '/toppar', 'to', runDir + '/toppar'
        shutil.copytree(oldrunDir + '/toppar', runDir + '/toppar')

    #copy the iterations:
    print '  creating directory', runDir + '/structures'
    os.mkdir(runDir + '/structures')
    if olditnumber != 'none':
        for it in range(string.atoi(olditnumber) + 1):
            it = str(it)
            print '  copying', oldrunDir + '/structures/it' + it, 'to',\
                  runDir +'/structures/it' + it  
            shutil.copytree(oldrunDir + '/structures/it' + it,\
                        runDir +'/structures/it' + it)
        for it in range(string.atoi(olditnumber) + 1, 9):
            it = str(it)
            print '  creating', oldrunDir + '/structures/it' + it
            os.mkdir(runDir + '/structures/it' + it)
            iterationfile = open (runDir + '/structures/it' + it + \
                                  '/iteration.cns', 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
    else:
        for it in range(9):    #create iterations 0 to 8
            it = str(it)
            os.mkdir(runDir + '/structures/it' + it)
            os.mkdir(runDir + '/structures/it' + it + '/analysis')
            if it == '8':
                os.mkdir(runDir + '/structures/it' + it + '/water')
                os.mkdir(runDir + '/structures/it' + it + '/water/analysis')
                os.mkdir(runDir + '/structures/it8/finaldata')
                iterationfile = open (runDir + '/structures/it' + it + \
                                      '/analysis/iteration.cns', 'w')
                iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                    it + ')\n')
                iterationfile.close()
                iterationfile = open (runDir + '/structures/it' + it + \
                                      '/water/analysis/iteration.cns', 'w')
                iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                    it + ')\n')
                iterationfile.close()
                iterationfile = open (runDir + '/structures/it' + it + \
                                      '/water/iteration.cns', 'w')
                iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                    it + ')\n')
                iterationfile.close()
                iterationfile = open (runDir + '/structures/it' + it + \
                                      '/finaldata/iteration.cns', 'w')
                iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                    it + ')\n')
                iterationfile.close()
            iterationfile = open (runDir + '/structures/it' + it + \
                                  '/iteration.cns', 'w')
            iterationfile.write('module ( iteration )\nevaluate (&iteration=' + \
                                it + ')\n')
            iterationfile.close()
           
    #end:
    print '  created new run' + runnumber, \
          'for the project', projectdir
    

