"""
MAria.py

contains the loop for the iteration 0-8
is only called once by RunAria.py
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision: 1.8 $"
__date__     = "$Date: 2000/04/06 11:54:20 $"

import copy, glob, os, re, string, time

from Aria.Analysis import EnergySorter, ProjectStatus
from Aria.CNS import CallCns
from Aria.DataIO import NoeList, ViolationList
from Aria.Main import ParsePath
from Aria.ThirdParty import task, TextFile

###############################################################################
def ForAllIterations(runDir, protocolsDir, newItDir, tempTrashDir, currit,\
                     nspectra, aspectrum1, aspectrum2, aspectrum3, aspectrum4,\
                     aspectrum5, mdtype, fileRoot, previtDir, templatefile,\
                     rFreeOn, rFreeOneSet, rFreePercent, rFreeMethod,\
                     iniCount, structures, keepStruct,\
                     ariaDir, run):
    """
    includes all the stuff for each iteration:
    calibration, merging, free Rfactor, MD refinement
    all the input must be a string, except currit as an integer
    """
    #get the integer values of the cpunumber, set 0 if '' or None:
    if run['cpunumber_1']:
        cpuNumber1 = string.atoi(run['cpunumber_1'])
    else:
        cpuNumber1 = 0
    if run['cpunumber_2']:
        cpuNumber2 = string.atoi(run['cpunumber_2'])
    else:
        cpuNumber2 = 0
    if run['cpunumber_3']:
        cpuNumber3 = string.atoi(run['cpunumber_3'])
    else:
        cpuNumber3 = 0
    if run['cpunumber_4']:
        cpuNumber4 = string.atoi(run['cpunumber_4'])
    else:
        cpuNumber4 = 0
    if run['cpunumber_5']:
        cpuNumber5 = string.atoi(run['cpunumber_5'])
    else:
        cpuNumber5 = 0
    if run['cpunumber_6']:
        cpuNumber6 = string.atoi(run['cpunumber_6'])
    else:
        cpuNumber6 = 0
    if run['cpunumber_7']:
        cpuNumber7 = string.atoi(run['cpunumber_7'])
    else:
        cpuNumber7 = 0
    if run['cpunumber_8']:
        cpuNumber8 = string.atoi(run['cpunumber_8'])
    else:
        cpuNumber8 = 0
    if run['cpunumber_9']:
        cpuNumber9 = string.atoi(run['cpunumber_9'])
    else:
        cpuNumber9 = 0
    if run['cpunumber_10']:
        cpuNumber10 = string.atoi(run['cpunumber_10'])
    else:
        cpuNumber10 = 0

    #create the queueDic:
    queueDic = {}
    if run['queue_1']:
        queueDic[run['queue_1']] = [run['cns_exe_1'], cpuNumber1, []]
    if run['queue_2']:
        queueDic[run['queue_2']] = [run['cns_exe_2'], cpuNumber2, []]
    if run['queue_3']:
        queueDic[run['queue_3']] = [run['cns_exe_3'], cpuNumber3, []]
    if run['queue_4']:
        queueDic[run['queue_4']] = [run['cns_exe_4'], cpuNumber4, []]
    if run['queue_5']:
        queueDic[run['queue_5']] = [run['cns_exe_5'], cpuNumber5, []]
    if run['queue_6']:
        queueDic[run['queue_6']] = [run['cns_exe_6'], cpuNumber6, []]
    if run['queue_7']:
        queueDic[run['queue_7']] = [run['cns_exe_7'], cpuNumber7, []]
    if run['queue_8']:
        queueDic[run['queue_8']] = [run['cns_exe_8'], cpuNumber8, []]
    if run['queue_9']:
        queueDic[run['queue_9']] = [run['cns_exe_9'], cpuNumber9, []]
    if run['queue_10']:
        queueDic[run['queue_10']] = [run['cns_exe_10'], cpuNumber10, []]

    #get the runPlusNumber as string (e.g. 'run12'):
    runPlusNumber = ParsePath.GetTail(runDir)

    #get some integer values:
    iniCount = string.atoi(iniCount)
    structures = string.atoi(structures)
    keepStruct = string.atoi(keepStruct)
    
    if currit == 0:
        filelisthandle = TextFile.TextFile(runDir + \
                                           '/begin/file.list', 'w')
        filelisthandle.write('"' + templatefile +'"')
        filelisthandle.close()
    else:
        lastit = currit - 1

    spectrumtogo = ['aspectrum1', 'aspectrum2', 'aspectrum3', 'aspectrum4',
		    'aspectrum5']

    #get the status of the whole project, e.g. the calculated structures:
    status = ProjectStatus.GetStatus(run)

    expectedTblFiles = []
    if status['unambigtbl' + str(currit)] == 0 and\
       status['ambigtbl' + str(currit)] == 0:
        #calibrating all spectra:
        for spectrumx in spectrumtogo:
            try: exec 'spectrumy = copy.copy(' + spectrumx + ')'
            except NameError:
                pass  #for the case when it's empty
            if spectrumy:
                #look which queue is free, take that:
                queueIndex = 0
                while 1:
                    queueList = queueDic.keys()
                    eachQueue = queueList[queueIndex]
                    #1. if empty, take it directly:
                    if queueDic[eachQueue][1] > len(queueDic[eachQueue][2]):
                        break
                    #2. if fileNames exist, check if the file already exists:
                    else:
                        breakOut = 0
                        for eachF in queueDic[eachQueue][2]:
                            if os.path.exists(eachF):
                                queueDic[eachQueue][2].remove(eachF)
                                breakOut = 1
                        if breakOut: break
                    if queueIndex == (len(queueList) - 1):
                        queueIndex = 0
                    else:
                        queueIndex = queueIndex + 1
                    time.sleep(1)
                    
                print 'calibrating spectrum', spectrumy                
                #write the temporary job files in the tempTrashDir:
                jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
        """ % (tempTrashDir,\
               ariaDir,\
               str(currit),\
               newItDir,\
               previtDir,\
               runDir,\
               runDir + '/data/' + spectrumy,\
               tempTrashDir,\
               queueDic[eachQueue][0],\
               runDir + '/protocols/calib.inp',\
               newItDir + '/calib_' + spectrumy + '_it' + str(currit) + '.out')
                jobFN = os.path.join(tempTrashDir, fileRoot + '_' +\
                                     runPlusNumber +\
                                     '_it' + str(currit) +\
                                     '_' + spectrumy + '.job')
                jobStream = open(jobFN, 'w')
                jobStream.write(jobString)
                jobStream.close()
                
                #add the expected output file to the list:
                expectedTblFiles.append(newItDir + '/' + spectrumy + '.tbl')
                queueDic[eachQueue][2].append(newItDir + '/' + spectrumy + '.tbl')

                #start the queue with the proper command and job file:
                whatToDo = eachQueue + ' ' + ParsePath.GetTail(jobFN) + ' &'
                print '    queue command:\n   ', whatToDo
                os.chdir(tempTrashDir)
                os.system(whatToDo)
                
                #move to next queue (after the last one, start from 0 again):
                if queueIndex == (len(queueList) - 1):
                    queueIndex = 0
                else:
                    queueIndex = queueIndex + 1

        #wait until all the spectra are calibrated:
        print 'waiting for the calibrated spectra...'
        while 1:
            spectraTblFiles = glob.glob(newItDir + '/*.tbl')
            for eachTbl in spectraTblFiles:
                if eachTbl in expectedTblFiles:
                    expectedTblFiles.remove(eachTbl)
            if len(expectedTblFiles) == 0:
                break
            time.sleep(1)

        #merging (in case that unambig.tbl and ambig.tbl exist, nspectrum=0):
        queueList = queueDic.keys()
        if string.atoi(nspectra) != 0:
            time.sleep(3) #wait for slow networks
            print 'merging of the data'
            jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
        """ % (tempTrashDir,\
               ariaDir,\
               str(currit),\
               newItDir,\
               previtDir,\
               runDir,\
               '',\
               tempTrashDir,\
               queueDic[queueList[0]][0],\
               runDir + '/protocols/merge.inp',\
               newItDir + '/merge_it' + str(currit) + '.out')
            jobFN = os.path.join(tempTrashDir, fileRoot + '_' +\
                                 runPlusNumber + '_it' + str(currit) + '_merge.job')
            jobStream = open(jobFN, 'w')
            jobStream.write(jobString)
            jobStream.close()
            #start the queue with the proper command and job file:
            whatToDo = queueList[0] + ' ' + ParsePath.GetTail(jobFN) + ' &'
            print '    queue command:\n   ', whatToDo
            os.chdir(tempTrashDir)
            os.system(whatToDo)
                
        #wait until all the spectra are calibrated:
        print 'waiting for the merged NOE list...'
        while 1:
            if os.path.exists(newItDir + '/unambig.tbl') and\
               os.path.exists(newItDir + '/ambig.tbl'):
                break
            time.sleep(1)
    else:
        print 'spectra already calibrated and merged'


    #free R-factor refinement, create the modify.list files:
    if rFreeOn == 'true':
        print 'free R-factor refinement switched on'
        if rFreeOneSet == 'false' or currit == 0:
            mergedFile = os.path.join(newItDir, 'merged.list')
            print '  reading', mergedFile
            MERGED = NoeList.NoeList()
            MERGED.ReadList(mergedFile)
            MERGED.IntraSeqMediumLong()

            #count the peaks:
            totalNo = len(MERGED.peakslist)
            intraNo = len(MERGED.intraList)
            seqNo = len(MERGED.seqList)
            mediumNo = len(MERGED.mediumList)
            longNo = len(MERGED.longList)
            unassignedNo = len(MERGED.unassignedList)
            ambiguousNo = len(MERGED.ambiguousList)
            unambiguousNo = intraNo + seqNo + mediumNo + longNo  #without unassigned peaks!

            print 'total number of NOEs:   ', totalNo
            print '  ambiguous NOEs:       ', ambiguousNo
            print '  unambiguous NOEs:     ', unambiguousNo
            print '    intraresidual NOEs: ', intraNo
            print '    sequential NOEs:    ', seqNo
            print '    medium-range NOEs:  ', mediumNo
            print '    long-range NOEs:    ', longNo
            print '  unassigned NOEs:      ', unassignedNo

            #build the test set:
            exclusionRatio = string.atof(rFreePercent) / 100
            from Aria.Rfree import NoeExclusion
            RandomGenerator = NoeExclusion.SetSeed()
            if rFreeMethod == 'random':
                InOutDic = NoeExclusion.RandomExclusion(totalNo, structures,\
                                                        exclusionRatio, RandomGenerator)
            else:
                InOutDic = NoeExclusion.LibraExclusion(totalNo, structures,\
                                                       exclusionRatio, RandomGenerator)
            
            #save the modify files:
            from Aria.DataIO import ModifyList
            writeOutDic = {}
            for (structureNo, peakNo) in InOutDic.keys():
                #get the spectrumName and the peakNumber from the NoeList instance:
                if len(MERGED.peakslist[peakNo].contributions) > 0:
                    spectrumName = MERGED.peakslist[peakNo].contributions[0].spectrumName
                else:
                    spectrumName = None
                peakNumber = MERGED.peakslist[peakNo].peakNumber
                if writeOutDic.has_key(structureNo):
                    writeOutDic[structureNo].append((spectrumName, peakNumber, InOutDic[(structureNo, peakNo)]))
                else:
                    writeOutDic[structureNo] = []
            for eachStructure in writeOutDic.keys():
                #add the modifications for each individual structure:
                ML=ModifyList.ModifyList()
                for eachMod in writeOutDic[eachStructure]:
                    if eachMod[2] == 1 or eachMod[2] == '1':
                        #test=0 means that the peak is not used:
                        ML.AddModification(eachMod[0], eachMod[1],\
                                           test=0)
                #write one modify file for each individual structure:
                outFileName = os.path.join(newItDir, 'modify_' + \
                                           str(eachStructure+1) + '.list')
                print 'writing to', outFileName
                ML.WriteList(outFileName)
                del(ML)
            del(writeOutDic)


    #starting molecular dynamics in parallel:
    if mdtype == 'torsion':
	print 'starting TAD protocol for simulated annealing'
        whichMD = 'torsion'
    else:
	print 'starting Cartesian MD protocol for simulated annealing'
        whichMD = 'Cartesian'
    protocolFile = 'refine.inp'


    #for substituting the count and the output filename:
    parseEval = re.compile('!The next line will be changed automatically.*?\n\s*?evaluate.*?\)')

    #read the file.list file and create a list of filenames:
    insideQuotes = re.compile('"(.*?)"')
    fileList = []
    fileListHandle = open(os.path.join(previtDir, 'file.list'))
    for eachLine in fileListHandle.readlines():
        searched = insideQuotes.search(eachLine)
        fileList.append(searched.group(1))
    fileListHandle.close()


    #loop over all the structures (from ini_count_x to structures_x in run.cns):
    for strucNumber in range(iniCount, structures + 1):
        #look which structures are already calculated:
        if status['pdb_' + str(currit) + '_' + str(strucNumber)] == 1:
            print '    structure', strucNumber, 'already exists.'
            continue
        
        #look which queue is free, take that:
        queueIndex = 0
        while 1:
            queueList = queueDic.keys()
            eachQueue = queueList[queueIndex]
            #1. if empty, take it directly:
            if queueDic[eachQueue][1] > len(queueDic[eachQueue][2]):
                break
            #2. if fileNames exist, check if the structures already exist:
            else:
                breakOut = 0
                for eachF in queueDic[eachQueue][2]:
                    if os.path.exists(eachF):
                        queueDic[eachQueue][2].remove(eachF)
                        breakOut = 1
                if breakOut: break
            if queueIndex == (len(queueList) - 1):
                queueIndex = 0
            else:
                queueIndex = queueIndex + 1
#            print queueDic #test
            time.sleep(2)
            
        print '    calculating structure', strucNumber

        #start jobs from a structure or from a template:
        if strucNumber > keepStruct or currit == 0 or len(fileList) == 0:
            startFrom = os.path.join(runDir, 'begin/' + fileRoot + '_template.pdb')
        else:
            startFrom = fileList[0]
            fileList = fileList[1:]  #just remove it from fileList
        outname = os.path.join(newItDir, fileRoot, str(strucNumber) + '.pdb')

        #create a temporary protocol file in the tempTrashDir:
        inputHandle = open(os.path.join(protocolsDir, protocolFile))
        outputFileName = os.path.join(tempTrashDir, fileRoot + '_' +\
                                      runPlusNumber + '_it' + str(currit) +\
                                      '_refine_' + str(strucNumber) + '.inp')
        outputHandle = open(outputFileName, 'w')
        wholeProtocol = string.join(inputHandle.readlines(), '')
        #replace $whichMD, $count, $file and $filename:
        wholeProtocol = parseEval.sub('evaluate ($whichMD="' +\
                                      whichMD + '")', wholeProtocol, 1)
        wholeProtocol = parseEval.sub('evaluate ($count=' +\
                                      str(strucNumber) + ')', wholeProtocol, 1)
        wholeProtocol = parseEval.sub('evaluate ($file="' +\
                                      startFrom + '")', wholeProtocol, 1)
        wholeProtocol = parseEval.sub('evaluate ($filename="' +\
                                      os.path.join(newItDir, fileRoot + '_' +\
                                                   str(strucNumber)+ '.pdb")'),\
                                      wholeProtocol, 1)
        outputHandle.write(wholeProtocol)
        outputHandle.close()
        stdoutFN = tempTrashDir + '/' +\
                   fileRoot + '_' + \
                   runPlusNumber + '_it' + str(currit) + '_refine_' + str(strucNumber) + '.out'
        #write the temporary job files in the tempTrashDir:
        jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
""" % (tempTrashDir,\
       ariaDir,\
       str(currit),\
       newItDir,\
       previtDir,\
       runDir,\
       '',\
       tempTrashDir,\
       queueDic[eachQueue][0],\
       ParsePath.GetTail(outputFileName),\
       ParsePath.GetTail(stdoutFN))
        jobFN = os.path.join(tempTrashDir, fileRoot + '_' +\
                             runPlusNumber +\
                             '_it' + str(currit) +\
                             '_refine_' + str(strucNumber) + '.job')
        jobStream = open(jobFN, 'w')
        jobStream.write(jobString)
        jobStream.close()

        #start the queue with the proper command and job file:
        whatToDo = eachQueue + ' ' + ParsePath.GetTail(jobFN) + ' &'
        print '      queue command:\n     ', whatToDo
        os.chdir(tempTrashDir)
        os.system(whatToDo)

        #add the file to the queueDic:
        queueDic[eachQueue][2].append(newItDir + '/' + fileRoot + '_' + str(strucNumber) + '.pdb')

    #waiting for all the structures:
    print 'waiting for all the structures...'
    while 1:
        breakOut = 1
        for strucNumber in range(iniCount, structures + 1):
            if not os.path.exists(newItDir + '/' + fileRoot + '_' + str(strucNumber) + '.pdb'):
                breakOut = 0
        if breakOut: break
        time.sleep(2)
        
    EnergySorter.WriteFileList(newItDir)

    #free R-factor refinement, have a look at the violations:
    if rFreeOn == 'true':
        print 'free R-factor refinement: starting the violation analysis'

        #run the noe_violations.inp protocol and create the violation files:
        print 'creating NOE violation files'
        whatToDo = cns + ' < ' + protocolsDir + '/noe_violations.inp > ' + \
                   tempTrashDir + '/violations_' + fileRoot + '_it' + \
                   str(currit) + '.out'
        os.system(whatToDo)

        #read the unambig.tbl and ambig.tbl files:
        UNAMBIG=NoeList.NoeList()
        UNAMBIG.ReadTbl(newitDir + '/unambig.tbl')
        
        AMBIG=NoeList.NoeList()
        AMBIG.ReadTbl(newitDir + '/ambig.tbl')
        
        #read the violation list files:
        for strucNumber in range(iniCount, structures + 1):
            VIOL = ViolationList.ViolationList()
            VIOL.ReadFileName(newitDir + '/' + fileRoot + '_' + str(strucNumber) + '.viol')
            
            #calculate the free R-factors:
            


