"""
ConvertData.py

some functions to convert NMR data into an ARIA readable format
most of the functionality stems from NoeList.py
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import os, re, shutil, string, sys
from Aria.DataIO import NoeList, PpmList
from Aria.Main import ParsePath

###############################################################################
def Ansig2Aria(runDir, aspectrum, noeFile, ppmFile, het1, pro1, het2, pro2,\
               ppmdhet1, ppmdpro1, ppmdhet2, ppmdpro2, whichPeaks):
    """
    method to convert Ansig data in ARIA format for each spectrum
    uses the classes from NoeList.py
    """
    #check if specified 'NOE file' is a crosspeaks export file or a general
    #NOE file, read the first line to figure out what it is:
    isItACross = 1  #default=crosspeaks export file
    testFileHandle = open(noeFile,'r')
    firstLine = testFileHandle.readline()
    crossPeaks = re.compile('crosspeaks')
    generalNoe = re.compile('general')
    if crossPeaks.search(firstLine):
        print 'the NOE file', noeFile, 'is a crosspeaks export file'
    elif generalNoe.search(firstLine):
        print 'the NOE file', noeFile, 'is a general NOE file'
        isItACross = 0
    else:
        print 'WARNING: first line of file', noeFile, \
              'does not contain one of the keywords "crosspeaks" or "general"'
        print 'use the default and suppose that it is a crosspeaks export file!'
    testFileHandle.close()
    
    #build the filename for the output files:
    idfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.id'
    chemFile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm'
    tblfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.tbl'
    
    #copy the ANSIG file to /data:
    print 'copying', noeFile, 'to',  runDir + '/data/' + aspectrum 
    print 'copying', ppmFile, 'to',  runDir + '/data/' + aspectrum
    shutil.copyfile(noeFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(noeFile))
    shutil.copyfile(ppmFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(ppmFile))
    
    #NOEs - convert the data in .tbl format:
    NOE= NoeList.NoeList('ANSIG spectrum')
    if isItACross:
        NOE.ReadAnsigCpe(noeFile, het1, pro1, het2, pro2)
    else:
        NOE.ReadAnsigNoe(noeFile, het1, pro1, het2, pro2)
    NOE.WriteTbl(tblfile, ppmdhet1, ppmdpro1, ppmdhet2, ppmdpro2, whichPeaks)
    
    #PPMs - read .prot file and write .ppm file:
    PPM = PpmList.PpmList()
    print 'reading the chemical shifts from', ppmFile
    PPM.ReadAnsig(ppmFile)
    print 'writing the chemical shifts to', chemFile
    PPM.WriteChem(chemFile)
    PPM.WriteId(idfile)
    del(PPM)
    del(NOE)
    
    
    
###############################################################################
def AriaTblWithC(tblfile, ppmfile, aspectrum, runDir):
    """
    this function is used for the setup with uncalibrated data in ARIA .tbl
    format
    copies the files to the spectra directories
    always takes the spectrumname and creates spectrumname.tbl and
    spectrumname.ppm
    """
    #copy .tbl and .ppm files, .ppm file has the "same" name like .tbl file:
    print '  copying', tblfile, 'to:', runDir + '/data/' + aspectrum + '.tbl'
    print '  copying', ppmfile, 'to:', runDir + '/data/' + aspectrum + '.ppm'
    shutil.copy(tblfile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.tbl')
    shutil.copy(ppmfile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm')
    #create spectrum.cns on the fly:
    spectrumcns = open(runDir + '/data/' + aspectrum + '/spectrum.cns', 'w')
    spectrumcns.write('module(spectrum)\nevaluate (&spectrum ="'+\
                      aspectrum + '")\n')
    spectrumcns.close()
    
    
###############################################################################
def AriaCalList(listFile, ppmFile, aspectrum, runDir):
    """
    this function is used for the setup with calibrated data in ARIA .list
    format
    copies the files to the spectra directories
    always takes the spectrumname and creates spectrumname.list and
    spectrumname.ppm
    """
    #copy .list and .ppm files, .ppm file has the "same" name like .tbl file:
    print '  copying', listFile, 'to:', runDir + '/data/' + aspectrum + '.list'
    print '  copying', ppmFile, 'to:', runDir + '/data/' + aspectrum + '.ppm'
    shutil.copy(listFile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.list')
    shutil.copy(ppmFile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm')
    shutil.copy(listFile, runDir + '/structures/it0/' + aspectrum + '.list')
    #convert them to .tbl files:
    NL=NoeList.NoeList()
    NL.ReadList(listFile)
    NL.WriteTbl(runDir + '/data/' + aspectrum + '/' +aspectrum + '.tbl')
    NL.WriteTbl(runDir + '/structures/it0/' + aspectrum + '.tbl')
    #create spectrum.cns on the fly:
    spectrumcns = open(runDir + '/data/' + aspectrum + '/spectrum.cns', 'w')
    spectrumcns.write('module(spectrum)\nevaluate (&spectrum ="'+\
                      aspectrum + '")\n')
    spectrumcns.close()

    
###############################################################################
def AriaUncalList(listFile, ppmFile, aspectrum, runDir):
    """
    this function is used for the setup with uncalibrated data in ARIA .list
    format
    copies the files to the spectra directories
    always takes the spectrumname and creates spectrumname.tbl and
    spectrumname.ppm
    """
    #copy .tbl and .ppm files, .ppm file has the "same" name like .tbl file:
    print '  copying', listFile, 'to:', runDir + '/data/' + aspectrum + '.list'
    print '  copying', ppmFile, 'to:', runDir + '/data/' + aspectrum + '.ppm'
    shutil.copy(listFile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.list')
    shutil.copy(ppmFile, runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm')
    #convert them to .tbl files:
    NL=NoeList.NoeList()
    NL.ReadList(listFile)
    NL.WriteTbl(runDir + '/data/' + aspectrum + '/' + aspectrum +  '.tbl')
    #create spectrum.cns on the fly:
    spectrumcns = open(runDir + '/data/' + aspectrum + '/spectrum.cns', 'w')
    spectrumcns.write('module(spectrum)\nevaluate (&spectrum ="'+\
                      aspectrum + '")\n')
    spectrumcns.close()
    
    

###############################################################################
def Aurelia2aria(datfile, ppminfile, ppmd1, ppmd2, ppmdhet, outpath, \
		 spectrumname):
    """
    !!!will be moved to NoeList.py soon!!!
    converts AURELIA data into an ARIA readable format
    can only handle 2D data at the moment
    input:   
    output:  
    usage:   
    author:  Jens Linge, linge@embl-heidelberg.de
             7.98
    """    
    print 'starting conversion: AURELIA -> ARIA'
    ppmoutfile = outpath + '/data/' + spectrumname + '/' + spectrumname+'.ppm'
    tblfile = outpath + '/data/' + spectrumname + '/' + spectrumname + '.tbl'

    #can only handle 2D spectra:
    twoorthree = 2
    print '    can only handle 2D spectra'

    #opening file handles:
    dathandle = TextFile.TextFile(datfile, 'r')
    print '  opening file', datfile
    ppminhandle = TextFile.TextFile(ppminfile, 'r')
    print '  opening file', ppminfile
    ppmouthandle = TextFile.TextFile(ppmoutfile, 'w')
    print '  creating file', ppmoutfile
    tblhandle = TextFile.TextFile(tblfile, 'w')
    print '  creating file', tblfile

    #some messages for STDOUT and comments for the output files:
    print '  PPMD1=', ppmd1
    print '  PPMD2=', ppmd2
    ppmouthandle.write('! derived from AURELIA ' + str(twoorthree) +\
		    'D NOESY file ' + datfile + '\n')
    tblhandle.write('! derived from AURELIA ' + str(twoorthree) +\
		    'D NOESY file ' +  datfile + '\n')
    tblhandle.write('! half-widths of frequency windows applied, in ppm:\n')
    tblhandle.write('! ' + ppmd1 + '\n')
    tblhandle.write('! ' + ppmd2 + '\n')
    if twoorthree == 3:
	print '  PPMDHET=', ppmdhet
	tblhandle.write('! ' + ppmdhet + '   hetero atom\n')
    tblhandle.write('\n')

    #for the .ppm table (the same procedure for 2D and 3D):
    #parsing and writing output:
    do = re.compile('do')
    nineninenine = re.compile('999.')
    openbracket = re.compile('\(')
    closebracket = re.compile('\)')
    equalsign = re.compile('=')
    for line in ppminhandle:
	if do.search(line):
	    line = openbracket.sub('',line)
	    line = closebracket.sub('',line)
	    line = equalsign.sub('',line)
	    protlist = string.split(line)
	    shiftppm = protlist[3]
	    atomname = protlist[8]
	    resnumber = protlist[5]
	    newname = PseudoAtom.Pseudo2Atom(atomname) #changing pseudoatom names
	    if nineninenine.search(str(shiftppm)): #those with 999.0 are
		pass                               #not assigned
	    else:
		ppmouthandle.write('do (store1 = ' + shiftppm + ' )\t(resid '+
		resnumber + '\tand name ' + newname + \
		' ) \n')

    #for the .tbl table (2D and 3D case):
    #parsing and writing output from .dat:
    exclamation = re.compile('!')
    scratch = re.compile('#')
    for line in dathandle:
	if scratch.match(line) or exclamation.match(line):
	    continue      #for the comments
	elif string.strip(line) == '':
	    continue      #for the empty lines
        else:
	    peakslist = string.split(line)
	    print peakslist
	    peaknumber = peakslist[0]
	    w1 = peakslist[1]
	    w2 = peakslist[2]
	    if twoorthree == 3:
		pass
	    else:
		intensity = peakslist[3]        #the 2D case
		volume = peakslist[4]
		lower1 = float(w1) - float(ppmd1)
		lower2 = float(w2) - float(ppmd2)
		higher1 = float(w1) + float(ppmd1)
		higher2 = float(w2) + float(ppmd2)
		dist = 6.0
	if volume == 0.0:
 	    errp = 0.0
 	    errm = 6.0
 	else:
	    errp = 0.1
	    errm = 0.1
 	if twoorthree == 2:
	    tblhandle.write('assi ( attr store1 < ' + str(higher1) + \
			    '\tand attr store1 > ' + str(lower1) + ' )\n')
	    tblhandle.write('     ( attr store1 < ' + str(higher2) + \
			    '\tand attr store1 > ' + str(lower2) + ' )\n')
	    tblhandle.write('     ' +  str(dist) + ' ' +  str(errm) + ' ' +\
			    str(errp) + ' peak ' + str(peaknumber) +\
			    ' volume ' +  str(volume) + ' ppm1 ' + \
			    str(w1) + ' ppm2 ' + str(w2) + '\n')
 	else:
	    tblhandle.write('assi ( attr store1 < ' + str(higher2) + \
			    '\tand attr store1 > ' + str(lower2) + ' )\n')
	    tblhandle.write('     ((attr store1 < ' + str(higher3) + \
			    '\tand attr store1 > ' + str(lower3) + ' )\n')
	    tblhandle.write('     and bondedto ( attr store1 < ' + \
			    str(higher1) + '\tand attr store1 > ' + \
			    str(lower1) + '))\n')
	    tblhandle.write('     ' + str(dist) + ' ' + str(errm) + ' ' +\
			    str(errp) + ' peak ' + \
			    str(peaknumber) + ' volume ' + str(volume) + \
			    ' ppm1 ' + str(w2) +\
			    ' ppm2 ' + str(w3) +  '\n')
    #closing file handles:
    dathandle.close()
    ppminhandle.close()
    ppmouthandle.close()
    tblhandle.close()
    

    
###############################################################################
def Nmrview2Aria(runDir, ariadir, aspectrum, dimension, xpkFile, ppmFile):
    """
    converts NMRView .xpk data to ARIA format
    uses Kristy's perl scripts
    """
    #build the filename for the output files:
    idfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.id'
    chemfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm'
    tblfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.tbl'
    
    #copy the NMRView file to /data:
    print 'copying', xpkFile, 'to',  runDir + '/data/' + aspectrum 
    print 'copying', ppmFile, 'to',  runDir + '/data/' + aspectrum
    shutil.copyfile(xpkFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(xpkFile))
    shutil.copyfile(ppmFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(xpkFile))
    
    #NOEs - convert the data in .tbl format:
    if dimension == '2':
        print 'starting nmrview2aria.pl with', xpkFile
        os.system(ariadir + '/Aria/DataIO/nmrview2aria.pl ' + xpkFile + ' > ' + tblfile)
    elif dimension == '3':
        print 'starting nmrview3aria.pl with', xpkFile
        os.system(ariadir + '/Aria/DataIO/nmrview3aria.pl ' + xpkFile + ' > ' + tblfile)
    else:
        print 'WARNING: dimension', dimension, 'is not supported by the method'
        print 'MAria.Nmrview2Aria. Data conversion aborted!'
        return
        
    #PPMs - read chemical shift file and write .ppm file:
    PPM = PpmList.PpmList()
    PPM.ReadNmrView(ppmFile)
    PPM.WriteChem(chemfile)
    PPM.WriteId(idfile)


###############################################################################
def Pipp2Aria(runDir, aspectrum, noeFile, ppmFile, het1, pro1, het2, pro2,\
              ppmdhet1, ppmdpro1, ppmdhet2, ppmdpro2, whichPeaks,\
              assign1, assign2):
    """
    method to convert PIPP data in ARIA format for each spectrum
    uses the classes from NoeList.py
    """
    #check if specified 'NOE file' is a .PCK file or a .ASG file
    isItAPck = 1  #default=PCK file
    testFileHandle = open(noeFile,'r')
    bigString = string.join(testFileHandle.readlines())
    testFileHandle.close()
    vars = re.compile('VARS')
    
    if vars.search(bigString):
        print 'the file', noeFile, 'is a .PCK file'
    else:
        print 'the file', noeFile, 'is an .ASG file'
        isItAPck = 0
    del(bigString)
    
    #build the filename for the output files:
    idfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.id'
    chemfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm'
    tblfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.tbl'
    
    #copy the PIPP files to /data:
    print 'copying', noeFile, 'to',  runDir + '/data/' + aspectrum 
    print 'copying', ppmFile, 'to',  runDir + '/data/' + aspectrum
    shutil.copyfile(noeFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(noeFile))
    shutil.copyfile(ppmFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(noeFile))
    
    #NOEs - convert the data in .tbl format:
    NOE= NoeList.NoeList('PIPP spectrum')
    if isItAPck:
        NOE.ReadPippPck(noeFile, het1, pro1, het2, pro2, assign1, assign2)
    else:
        NOE.ReadPippAsg(noeFile, het1, pro1, het2, pro2)
    NOE.WriteTbl(tblfile, ppmdhet1, ppmdpro1, ppmdhet2, ppmdpro2, whichPeaks)

##     NOE.Stdout() #test
    
    #PPMs - read .prot file and write .ppm file:
    PPM = PpmList.PpmList()
    PPM.ReadPipp(ppmFile)
    PPM.WriteChem(chemfile)
    PPM.WriteId(idfile)


###############################################################################
def Regine2Aria(peaksFile, shiftsFile, aspectrum, runDir, ppmdHet1, ppmdPro1,\
                ppmdHet2, ppmdPro2):
    """
    this function is used for the setup with Regine data

    copies the files to the spectra directories
    always takes the spectrumname and creates spectrumname.tbl and
    spectrumname.ppm
    """
    #build the filename for the output files:
    idfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.id'
    chemfile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.ppm'
    tblFile = runDir + '/data/' + aspectrum + '/' + aspectrum + '.tbl'
    
    #copy the Regine files to /data:
    print 'copying', peaksFile, 'to',  runDir + '/data/' + aspectrum 
    print 'copying', shiftsFile, 'to',  runDir + '/data/' + aspectrum
    shutil.copyfile(peaksFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(peaksFile))
    shutil.copyfile(shiftsFile, runDir + '/data/' + aspectrum + '/' + ParsePath.GetTail(shiftsFile))
    
    #NOEs - convert the data in .tbl format:
    NOE= NoeList.NoeList('Regine')
    NOE.ReadRegine(peaksFile)
##     NOE.Stdout() #test
    NOE.WriteTbl(tblFile, ppmdHet1, ppmdPro1, ppmdHet2, ppmdPro2)

    #PPMs - read .prot file and write .ppm file:
    PPM = PpmList.PpmList()
    PPM.ReadRegine(shiftsFile)
    PPM.WriteChem(chemfile)
    PPM.WriteId(idfile)

    #create spectrum.cns on the fly:
    spectrumcns = open(runDir + '/data/' + aspectrum + '/spectrum.cns', 'w')
    spectrumcns.write('module(spectrum)\nevaluate (&spectrum ="'+\
                      aspectrum + '")\n')
    spectrumcns.close()
    
