"""
CnsAnalysis.py
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import os, time
from Aria.Main import ParsePath

def Analysis(runDir, ariaDir, protocolsDir, newItDir, tempTrashDir, currit, queueDic,\
             fileRoot):
    """
    a method to call all the CNS analysis scripts
    """
    print 'starting analysis scripts for', newItDir
    queueList = queueDic.keys()

    #get the runPlusNumber as string (e.g. 'run12'):
    runPlusNumber = ParsePath.GetTail(runDir)
            
    #1. calculating average structure (wellordered.inp):
    print '  calculating average structure'

    jobString = """cd %s
    setenv ARIA %s
    setenv CURRIT %s
    setenv NEWIT %s
    setenv PREVIT %s
    setenv RUN %s
    setenv SPECTRUM %s
    setenv TEMPTRASH %s
    %s < %s > %s
            """ % (tempTrashDir,\
                   ariaDir,\
                   '8',\
                   newItDir,\
                   newItDir,\
                   runDir,\
                   '',\
                   tempTrashDir,\
                   queueDic[queueList[0]][0],\
                   runDir + '/protocols/wellordered.inp',\
                   newItDir + '/analysis/wellordered.out')
    jobFN = os.path.join(tempTrashDir, fileRoot + '_' + runPlusNumber + '_wellordered.job')
    jobStream = open(jobFN, 'w')
    jobStream.write(jobString)
    jobStream.close()
    #start the queue with the proper command and job file:
    whatToDo = queueList[0] + ' ' + ParsePath.GetTail(jobFN) + ' &'
    print '    queue command:\n   ', whatToDo
    os.chdir(tempTrashDir)
    os.system(whatToDo)

    #waiting:
    print '  waiting for the average structure...'
    while 1:
        if os.path.exists(newItDir + '/analysis/' + fileRoot + '_ave.pdb'):
            break
        time.sleep(1)

    time.sleep(3) #wait for slow networks
    
    #2. all the other analysis scripts:
    print '  running analysis scripts:'
    toDoList = [['calculating the rmsd to the average structure', 'rmsave.inp'],\
                ['analyzing geometry', 'print_geom.inp'],\
                ['analyzing NOEs', 'print_noe.inp'],\
                ['analyzing dihedrals', 'print_dih.inp'],\
                ['analyzing couplings', 'print_coup.inp'],\
                ['calculating circular order parameters', 'cop.inp'],\
                ['calculating energies', 'energy.inp']]
 
    for eachPro in toDoList:
        queueIndex = 0
        while 1:
            queueList = queueDic.keys()
            eachQueue = queueList[queueIndex]
            #1. if empty, take it directly:
            if queueDic[eachQueue][1] > len(queueDic[eachQueue][2]):
                break
            #2. if fileNames exist, check if the file already exists:
            else:
                breakOut = 0
                for eachF in queueDic[eachQueue][2]:
                    if os.path.exists(eachF):
                        queueDic[eachQueue][2].remove(eachF)
                        breakOut = 1
                if breakOut: break
            if queueIndex == (len(queueList) - 1):
                queueIndex = 0
            else:
                queueIndex = queueIndex + 1
            time.sleep(1)
        time.sleep(2) #just to make sure that all the files are there.

        print '   ', eachPro[0]
        inputFN = runDir + '/protocols/' + eachPro[1]
        outputFN = newItDir + '/analysis/' + eachPro[1][:-4] + '.out'
        jobFN = os.path.join(tempTrashDir, fileRoot  + '_' + runPlusNumber + '_' +\
                              eachPro[1][:-4] + '.job')
        jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
""" % (tempTrashDir,\
       ariaDir,\
       '8',\
       newItDir,\
       newItDir,\
       runDir,\
       '',\
       tempTrashDir,\
       queueDic[eachQueue][0],\
       inputFN,\
       outputFN)
        jobStream = open(jobFN, 'w')
        jobStream.write(jobString)
        jobStream.close()
        #start the queue with the proper command and job file:
        whatToDo = eachQueue + ' ' + ParsePath.GetTail(jobFN) + ' &'
        print '      queue command:\n     ', whatToDo
        os.chdir(tempTrashDir)
        os.system(whatToDo)

        #move to next queue (after the last one, start from 0 again):
        #we submit a job every 10 seconds, thus on a slow machine, there
        #might be problems with too many jobs running!!!
        #(we should add filenames to queueDic instead...)
        
        if queueIndex == (len(queueList) - 1):
            queueIndex = 0
            time.sleep(10)
        else:
            queueIndex = queueIndex + 1


